/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment;

import com.sun.enterprise.config.serverbeans.Application;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.glassfish.internal.deployment.ApplicationOrderInfo;
import org.glassfish.internal.deployment.DeploymentType;

public class DeploymentOrder {
    public static final DeploymentType[] APPLICATION_DEPLOYMENT_ORDER = new DeploymentType[]{DeploymentType.INTERNAL_APP, DeploymentType.CONNECTOR, DeploymentType.DEFAULT_APP};
    public static final Comparator APPLICATION_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            for (int i = 0; i < APPLICATION_DEPLOYMENT_ORDER.length; ++i) {
                DeploymentType depType = APPLICATION_DEPLOYMENT_ORDER[i];
                if (depType.isInstance(o1) && !depType.isInstance(o2)) {
                    return -1;
                }
                if (!depType.isInstance(o1) && depType.isInstance(o2)) {
                    return 1;
                }
                if (!depType.isInstance(o1) || !depType.isInstance(o2)) continue;
                return depType.compare(o1, o2);
            }
            throw new RuntimeException("unrecognized type");
        }
    };
    private static final TreeSet application_deployments = new TreeSet(APPLICATION_COMPARATOR);

    public static void addApplicationDeployment(ApplicationOrderInfo app) {
        application_deployments.add(app);
    }

    public static Iterator getApplicationDeployments() {
        ArrayList<Application> appList = new ArrayList<Application>();
        for (ApplicationOrderInfo appOrderInfo : application_deployments) {
            appList.add(appOrderInfo.getApplication());
        }
        return appList.iterator();
    }
}

