/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import com.sun.enterprise.v3.admin.AdminCommandJob;
import com.sun.enterprise.v3.admin.AsyncAdminCommandInvoker;
import jakarta.ws.rs.core.Response;
import org.glassfish.admin.rest.utils.SseEventOutput;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.ProgressEvent;

public final class SseAdminCommandInvoker
extends AsyncAdminCommandInvoker<Response> {
    private static final System.Logger LOG = System.getLogger(SseAdminCommandInvoker.class.getName());
    private final Response.ResponseBuilder builder;
    private SseEventOutput eventOutput;

    public SseAdminCommandInvoker(CommandInvocation<AdminCommandJob> commandInvocation, Response.ResponseBuilder builder) {
        super(commandInvocation);
        this.builder = builder;
    }

    public Response start() {
        AdminCommandJob job = this.getJob();
        LOG.log(System.Logger.Level.TRACE, "Job parameters: {0}, this: {1}", new Object[]{job.getParameters(), this});
        this.eventOutput = new SseEventOutput((AdminCommandState)job);
        AdminCommandEventBroker broker = job.getEventBroker();
        ProgressEventListener progressEventListener = new ProgressEventListener();
        broker.registerListener("ProgressStatus/change", (AdminCommandEventBroker.AdminCommandListener)progressEventListener);
        broker.registerListener("ProgressStatus/state", (AdminCommandEventBroker.AdminCommandListener)progressEventListener);
        broker.registerListener("AdminCommandState/stateChanged", (AdminCommandEventBroker.AdminCommandListener)new AdminCommandJobStateListener());
        this.startJob();
        LOG.log(System.Logger.Level.TRACE, "Writing the current report and leaving. {0}", new Object[]{this});
        this.eventOutput.write();
        return this.builder.entity((Object)this.eventOutput).build();
    }

    private class ProgressEventListener
    implements AdminCommandEventBroker.AdminCommandListener<ProgressEvent> {
        private ProgressEventListener() {
        }

        public void onAdminCommandEvent(String eventName, ProgressEvent event) {
            try {
                LOG.log(System.Logger.Level.TRACE, "onAdminCommandEvent, name: {0}, event: {1}", eventName, event);
                SseAdminCommandInvoker.this.eventOutput.write(eventName, event);
            }
            catch (Exception e) {
                LOG.log(System.Logger.Level.ERROR, () -> "Failed to process progress change event for: " + String.valueOf(event), (Throwable)e);
            }
        }
    }

    private class AdminCommandJobStateListener
    implements AdminCommandEventBroker.AdminCommandListener<AdminCommandJob> {
        private AdminCommandJobStateListener() {
        }

        public void onAdminCommandEvent(String eventName, AdminCommandJob job) {
            if (job != SseAdminCommandInvoker.this.getJob()) {
                LOG.log(System.Logger.Level.TRACE, "Ignoring job state change: {0}", job);
                return;
            }
            try {
                SseAdminCommandInvoker.this.eventOutput.write();
                if (!SseAdminCommandInvoker.this.getJob().isJobStillActive()) {
                    SseAdminCommandInvoker.this.eventOutput.close();
                }
            }
            catch (Exception e) {
                LOG.log(System.Logger.Level.ERROR, () -> "Failed to process progress job event for: " + String.valueOf(job), (Throwable)e);
            }
        }
    }
}

