/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.util.StringTokenizer;

public class HostAndPort {
    private final String host;
    private final int port;
    private final boolean secure;

    public HostAndPort(String host, int port, boolean secure) {
        this.host = host;
        this.port = port;
        this.secure = secure;
    }

    public HostAndPort(HostAndPort rhs) {
        this(rhs.host, rhs.port, rhs.secure);
    }

    public HostAndPort(String host, int port) {
        this(host, port, false);
    }

    public HostAndPort(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, ":", false);
        this.host = tokenizer.nextToken();
        String portString = tokenizer.nextToken();
        this.port = Integer.parseInt(portString);
        this.secure = false;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port == 0) {
            return this.secure ? 8181 : 8080;
        }
        return this.port;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

