/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile.f43;

import com.sun.tdk.signaturetest.core.context.ModFeatures;
import com.sun.tdk.signaturetest.model.ModuleDescription;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.sigfile.Parser;
import com.sun.tdk.signaturetest.sigfile.f42.F42Reader;
import com.sun.tdk.signaturetest.sigfile.f43.F43Parser;
import com.sun.tdk.signaturetest.toyxml.Elem;
import com.sun.tdk.signaturetest.toyxml.ToyParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class F43Reader
extends F42Reader {
    public F43Reader(Format format) {
        super(format);
    }

    @Override
    protected Parser getParser() {
        return new F43Parser();
    }

    @Override
    protected Elem processXMLFragment(String line) {
        ToyParser p = new ToyParser();
        return p.parse(line);
    }

    public static ModuleDescription fromTDom(Elem m) {
        String mainC;
        String features;
        ModuleDescription md = new ModuleDescription();
        assert ("module".equals(m.getNodeName()));
        String name = m.getAttribute("name");
        if (name != null && !name.isEmpty()) {
            md.setName(name);
        }
        if ((features = m.getAttribute("features")) == null) {
            features = "";
        }
        md.setFeatures(ModFeatures.featureSetFromCommaList(features));
        String version = m.getAttribute("version");
        if (version != null && !version.isEmpty()) {
            md.setVersion(version);
        }
        if ((mainC = m.getAttribute("main-class")) != null && !mainC.isEmpty()) {
            md.setMainClass(mainC);
        }
        List<Elem> pkgs = m.getElementsByTagName("package");
        HashSet<String> pkSet = new HashSet<String>();
        for (Elem p : pkgs) {
            String pkgName = p.getAttribute("name");
            if (pkgName.isEmpty()) continue;
            pkSet.add(pkgName);
        }
        md.setPackages(pkSet);
        List<Elem> exps = m.getElementsByTagName("exports");
        HashSet<ModuleDescription.Exports> exSet = new HashSet<ModuleDescription.Exports>();
        for (Elem e : exps) {
            ModuleDescription.Exports export = new ModuleDescription.Exports();
            export.source = e.getAttribute("source");
            HashSet<String> taSet = new HashSet<String>();
            List<Elem> targs = e.getElementsByTagName("target");
            for (Elem t : targs) {
                taSet.add(t.getAttribute("name"));
            }
            export.targets = taSet;
            exSet.add(export);
        }
        md.setExports(exSet);
        List<Elem> reqs = m.getElementsByTagName("requires");
        HashSet<ModuleDescription.Requires> rqSet = new HashSet<ModuleDescription.Requires>();
        for (Elem r : reqs) {
            ModuleDescription.Requires rq = new ModuleDescription.Requires();
            rq.name = r.getAttribute("name");
            HashSet<ModuleDescription.Requires.Modifier> ms = new HashSet<ModuleDescription.Requires.Modifier>();
            if ("true".equals(r.getAttribute(ModuleDescription.Requires.Modifier.MANDATED.name().toLowerCase()))) {
                ms.add(ModuleDescription.Requires.Modifier.MANDATED);
            }
            if ("true".equals(r.getAttribute(ModuleDescription.Requires.Modifier.STATIC.name().toLowerCase()))) {
                ms.add(ModuleDescription.Requires.Modifier.STATIC);
            }
            if ("true".equals(r.getAttribute(ModuleDescription.Requires.Modifier.SYNTHETIC.name().toLowerCase()))) {
                ms.add(ModuleDescription.Requires.Modifier.SYNTHETIC);
            }
            if ("true".equals(r.getAttribute(ModuleDescription.Requires.Modifier.TRANSITIVE.name().toLowerCase()))) {
                ms.add(ModuleDescription.Requires.Modifier.TRANSITIVE);
            }
            rq.modifiers = ms;
            rqSet.add(rq);
        }
        md.setRequires(rqSet);
        List<Elem> prs = m.getElementsByTagName("provides");
        HashMap<String, ModuleDescription.Provides> prMap = new HashMap<String, ModuleDescription.Provides>();
        for (int i = 0; i < prs.size(); ++i) {
            Elem p;
            p = prs.get(i);
            ModuleDescription.Provides pr = new ModuleDescription.Provides();
            pr.service = p.getAttribute("service");
            pr.providers = new HashSet<String>();
            List<Elem> ps = p.getElementsByTagName("provider");
            for (Elem t : ps) {
                pr.providers.add(t.getAttribute("name"));
            }
            prMap.put(pr.service, pr);
        }
        md.setProvides(prMap);
        List<Elem> uses = m.getElementsByTagName("uses");
        HashSet<String> usSet = new HashSet<String>();
        for (Elem c : uses) {
            usSet.add(c.getAttribute("name"));
        }
        md.setUses(usSet);
        return md;
    }
}

