/*
 * Copyright (c) 2007, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.jpa.core.entityManagerFactory;

import javax.persistence.*;
import java.math.BigInteger;

/*
 * Member
 */

@Entity
@Table(name = "MEMBER")
public class Member implements java.io.Serializable {

  private int memberId;

  private Integer version;

  private String memberName;

  public Member() {
  }

  public Member(int memberId, String memberName) {
    this.memberId = memberId;
    this.memberName = memberName;
  }

  // ===========================================================
  // getters and setters for the state fields

  @Id
  @Column(name = "MEMBER_ID")
  public int getMemberId() {
    return memberId;
  }

  public void setMemberId(int memberId) {
    this.memberId = memberId;
  }

  @Version
  @Column(name = "VERSION")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer i) {
    version = i;
  }

  @Column(name = "MEMBER_NAME")
  public String getMemberName() {
    return memberName;
  }

  public void setMemberName(String memberName) {
    this.memberName = memberName;
  }

}
