/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.generator;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.ArchetypeException;
import org.apache.maven.archetype.exception.ArchetypeGenerationFailure;
import org.apache.maven.archetype.exception.ArchetypeNotDefined;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.generator.ArchetypeGenerator;
import org.apache.maven.archetype.generator.FilesetArchetypeGenerator;
import org.apache.maven.archetype.old.OldArchetype;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ArchetypeGenerator.class)
public class DefaultArchetypeGenerator
extends AbstractLogEnabled
implements ArchetypeGenerator {
    @Requirement
    private ArtifactRepositoryLayout defaultArtifactRepositoryLayout;
    @Requirement
    private ArchetypeArtifactManager archetypeArtifactManager;
    @Requirement
    private FilesetArchetypeGenerator filesetGenerator;
    @Requirement
    private OldArchetype oldArchetype;

    private File getArchetypeFile(ArchetypeGenerationRequest request, ArtifactRepository localRepository) throws ArchetypeException {
        if (!this.isArchetypeDefined(request)) {
            throw new ArchetypeNotDefined("The archetype is not defined");
        }
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        ArtifactRepository remoteRepo = null;
        if (request != null && request.getArchetypeRepository() != null) {
            remoteRepo = this.createRepository(request.getArchetypeRepository(), request.getArchetypeArtifactId() + "-repo");
            repos.add(remoteRepo);
        }
        if (!this.archetypeArtifactManager.exists(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), remoteRepo, localRepository, repos, request.getProjectBuildingRequest())) {
            throw new UnknownArchetype("The desired archetype does not exist (" + request.getArchetypeGroupId() + ":" + request.getArchetypeArtifactId() + ":" + request.getArchetypeVersion() + ")");
        }
        File archetypeFile = this.archetypeArtifactManager.getArchetypeFile(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), remoteRepo, localRepository, repos, request.getProjectBuildingRequest());
        return archetypeFile;
    }

    private void generateArchetype(ArchetypeGenerationRequest request, File archetypeFile) throws ArchetypeException {
        if (this.archetypeArtifactManager.isFileSetArchetype(archetypeFile)) {
            this.processFileSetArchetype(request, archetypeFile);
        } else if (this.archetypeArtifactManager.isOldArchetype(archetypeFile)) {
            this.processOldArchetype(request, archetypeFile);
        } else {
            throw new ArchetypeGenerationFailure("The defined artifact is not an archetype");
        }
    }

    public String getPackageAsDirectory(String packageName) {
        return StringUtils.replace((String)packageName, (String)".", (String)"/");
    }

    private boolean isArchetypeDefined(ArchetypeGenerationRequest request) {
        return StringUtils.isNotEmpty((String)request.getArchetypeGroupId()) && StringUtils.isNotEmpty((String)request.getArchetypeArtifactId()) && StringUtils.isNotEmpty((String)request.getArchetypeVersion());
    }

    private void processFileSetArchetype(ArchetypeGenerationRequest request, File archetypeFile) throws ArchetypeException {
        this.filesetGenerator.generateArchetype(request, archetypeFile);
    }

    private void processOldArchetype(ArchetypeGenerationRequest request, File archetypeFile) throws ArchetypeGenerationFailure, InvalidPackaging {
        this.oldArchetype.createArchetype(request, archetypeFile);
    }

    @Override
    public void generateArchetype(ArchetypeGenerationRequest request, File archetypeFile, ArchetypeGenerationResult result) {
        try {
            this.generateArchetype(request, archetypeFile);
        }
        catch (ArchetypeException e) {
            result.setCause(e);
        }
    }

    @Override
    public void generateArchetype(ArchetypeGenerationRequest request, ArchetypeGenerationResult result) {
        try {
            File archetypeFile = this.getArchetypeFile(request, request.getLocalRepository());
            this.generateArchetype(request, archetypeFile, result);
        }
        catch (ArchetypeException ex) {
            result.setCause(ex);
        }
    }

    private ArtifactRepository createRepository(String url, String repositoryId) {
        String updatePolicyFlag = "always";
        String checksumPolicyFlag = "warn";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        return new MavenArtifactRepository(repositoryId, url, this.defaultArtifactRepositoryLayout, snapshotsPolicy, releasesPolicy);
    }
}

