/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.json;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.EMapPropertyHolder;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.json.JsonAdapter;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public final class JsonExporter {
    @Extension
    private JsonAdapter _jsonAdapter = new JsonAdapter();
    private final BiMap<ElkNode, String> nodeIdMap = HashBiMap.create();
    private final BiMap<ElkPort, String> portIdMap = HashBiMap.create();
    private final BiMap<ElkEdge, String> edgeIdMap = HashBiMap.create();
    private final BiMap<ElkEdgeSection, String> edgeSectionIdMap = HashBiMap.create();
    private final Map<ElkNode, Object> nodeJsonMap = Maps.newHashMap();
    private final Map<ElkPort, Object> portJsonMap = Maps.newHashMap();
    private final Map<ElkEdge, Object> edgeJsonMap = Maps.newHashMap();
    private final Map<ElkEdgeSection, Object> edgeSectionJsonMap = Maps.newHashMap();
    private int nodeIdCounter = 0;
    private int portIdCounter = 0;
    private int edgeIdCounter = 0;
    private int edgeSectionIdCounter = 0;
    private boolean omitZeroPos = true;
    private boolean omitZeroDim = true;
    private boolean omitLayout = false;
    private boolean shortLayoutOptionKeys = true;

    public boolean setOptions(boolean omitZeroPos, boolean omitZeroDim, boolean omitLayout, boolean shortLayoutOptionKeys) {
        boolean _xblockexpression = false;
        this.omitZeroPos = omitZeroPos;
        this.omitZeroDim = omitZeroDim;
        this.omitLayout = omitLayout;
        _xblockexpression = this.shortLayoutOptionKeys = shortLayoutOptionKeys;
        return _xblockexpression;
    }

    public JsonObject export(ElkNode root) {
        this.init();
        JsonArray jsonArray = this._jsonAdapter.newJsonArray();
        this.transformNode(root, jsonArray);
        this.transformEdges(root);
        JsonObject jsonGraph = this._jsonAdapter.optJSONObject(jsonArray, 0);
        return jsonGraph;
    }

    private int init() {
        int _xblockexpression = 0;
        this.nodeIdMap.clear();
        this.portIdMap.clear();
        this.edgeIdMap.clear();
        this.edgeSectionIdMap.clear();
        this.nodeJsonMap.clear();
        this.portJsonMap.clear();
        this.edgeJsonMap.clear();
        this.edgeSectionJsonMap.clear();
        this.nodeIdCounter = 0;
        this.portIdCounter = 0;
        this.edgeIdCounter = 0;
        this.edgeSectionIdCounter = 0;
        _xblockexpression = 0;
        return _xblockexpression;
    }

    private void transformNode(ElkNode node, Object arrayA) {
        boolean _isNullOrEmpty_2;
        boolean _not_2;
        boolean _isNullOrEmpty_1;
        boolean _not_1;
        boolean _not;
        JsonObject jsonObj = this.createAndRegister(node);
        JsonArray array = this._jsonAdapter.toJsonArray(arrayA);
        this._jsonAdapter.addJsonArr(array, (JsonElement)jsonObj);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)node.getLabels());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            final JsonArray labels = this._jsonAdapter.newJsonArray();
            this._jsonAdapter.addJsonObj(jsonObj, "labels", (JsonElement)labels);
            Consumer<ElkLabel> _function = new Consumer<ElkLabel>(){

                @Override
                public void accept(ElkLabel it) {
                    JsonExporter.this.transformLabel(it, labels);
                }
            };
            node.getLabels().forEach((Consumer)_function);
        }
        boolean bl2 = _not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)node.getPorts()));
        if (_not_1) {
            final JsonArray ports = this._jsonAdapter.newJsonArray();
            this._jsonAdapter.addJsonObj(jsonObj, "ports", (JsonElement)ports);
            Consumer<ElkPort> _function_1 = new Consumer<ElkPort>(){

                @Override
                public void accept(ElkPort it) {
                    JsonExporter.this.transformPort(it, ports);
                }
            };
            node.getPorts().forEach((Consumer)_function_1);
        }
        boolean bl3 = _not_2 = !(_isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty((Iterable)node.getChildren()));
        if (_not_2) {
            final JsonArray children = this._jsonAdapter.newJsonArray();
            this._jsonAdapter.addJsonObj(jsonObj, "children", (JsonElement)children);
            Consumer<ElkNode> _function_2 = new Consumer<ElkNode>(){

                @Override
                public void accept(ElkNode it) {
                    JsonExporter.this.transformNode(it, children);
                }
            };
            node.getChildren().forEach((Consumer)_function_2);
        }
        this.transformProperties((EMapPropertyHolder)node, jsonObj);
        this.transferShapeLayout((ElkShape)node, jsonObj);
    }

    private void transformPort(ElkPort port, Object arrayA) {
        boolean _not;
        JsonObject jsonObj = this.createAndRegister(port);
        JsonArray array = this._jsonAdapter.toJsonArray(arrayA);
        this._jsonAdapter.addJsonArr(array, (JsonElement)jsonObj);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)port.getLabels());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            final JsonArray labels = this._jsonAdapter.newJsonArray();
            this._jsonAdapter.addJsonObj(jsonObj, "labels", (JsonElement)labels);
            Consumer<ElkLabel> _function = new Consumer<ElkLabel>(){

                @Override
                public void accept(ElkLabel it) {
                    JsonExporter.this.transformLabel(it, labels);
                }
            };
            port.getLabels().forEach((Consumer)_function);
        }
        this.transformProperties((EMapPropertyHolder)port, jsonObj);
        this.transferShapeLayout((ElkShape)port, jsonObj);
    }

    private void transformEdges(ElkNode node) {
        boolean _not;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)node.getContainedEdges());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            JsonObject jsonObj = this._jsonAdapter.toJsonObject(this.nodeJsonMap.get(node));
            final JsonArray edges = this._jsonAdapter.newJsonArray();
            this._jsonAdapter.addJsonObj(jsonObj, "edges", (JsonElement)edges);
            Consumer<ElkEdge> _function = new Consumer<ElkEdge>(){

                @Override
                public void accept(ElkEdge it) {
                    JsonExporter.this.transformEdge(it, edges);
                }
            };
            node.getContainedEdges().forEach((Consumer)_function);
        }
        Consumer<ElkNode> _function_1 = new Consumer<ElkNode>(){

            @Override
            public void accept(ElkNode it) {
                JsonExporter.this.transformEdges(it);
            }
        };
        node.getChildren().forEach((Consumer)_function_1);
    }

    private void transformEdge(ElkEdge edge, Object arrayA) {
        boolean _not;
        JsonObject jsonObj = this.createAndRegister(edge);
        JsonArray array = this._jsonAdapter.toJsonArray(arrayA);
        this._jsonAdapter.addJsonArr(array, (JsonElement)jsonObj);
        final JsonArray sources = this._jsonAdapter.newJsonArray();
        Consumer<ElkConnectableShape> _function = new Consumer<ElkConnectableShape>(){

            @Override
            public void accept(ElkConnectableShape s) {
                String source = (String)JsonExporter.this.portIdMap.get((Object)s);
                if (source == null) {
                    source = (String)JsonExporter.this.nodeIdMap.get((Object)s);
                }
                if (source == null) {
                    JsonExporter.this._jsonAdapter.formatError("Unknown edge source: " + s);
                }
                JsonExporter.this._jsonAdapter.addJsonArr(sources, (JsonElement)JsonExporter.this._jsonAdapter.toJson(source));
            }
        };
        edge.getSources().forEach((Consumer)_function);
        this._jsonAdapter.addJsonObj(jsonObj, "sources", (JsonElement)sources);
        final JsonArray targets = this._jsonAdapter.newJsonArray();
        Consumer<ElkConnectableShape> _function_1 = new Consumer<ElkConnectableShape>(){

            @Override
            public void accept(ElkConnectableShape t) {
                String target = (String)JsonExporter.this.portIdMap.get((Object)t);
                if (target == null) {
                    target = (String)JsonExporter.this.nodeIdMap.get((Object)t);
                }
                if (target == null) {
                    JsonExporter.this._jsonAdapter.formatError("Unknown edge target: " + target);
                }
                JsonExporter.this._jsonAdapter.addJsonArr(targets, (JsonElement)JsonExporter.this._jsonAdapter.toJson(target));
            }
        };
        edge.getTargets().forEach((Consumer)_function_1);
        this._jsonAdapter.addJsonObj(jsonObj, "targets", (JsonElement)targets);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)edge.getLabels());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            final JsonArray labels = this._jsonAdapter.newJsonArray();
            this._jsonAdapter.addJsonObj(jsonObj, "labels", (JsonElement)labels);
            Consumer<ElkLabel> _function_2 = new Consumer<ElkLabel>(){

                @Override
                public void accept(ElkLabel it) {
                    JsonExporter.this.transformLabel(it, labels);
                }
            };
            edge.getLabels().forEach((Consumer)_function_2);
        }
        if (!this.omitLayout && !IterableExtensions.isNullOrEmpty((Iterable)edge.getSections())) {
            final JsonArray sections = this._jsonAdapter.newJsonArray();
            this._jsonAdapter.addJsonObj(jsonObj, "sections", (JsonElement)sections);
            Consumer<ElkEdgeSection> _function_3 = new Consumer<ElkEdgeSection>(){

                @Override
                public void accept(ElkEdgeSection it) {
                    JsonExporter.this.transformSection(it, sections);
                }
            };
            edge.getSections().forEach((Consumer)_function_3);
        }
        KVectorChain jps = (KVectorChain)edge.getProperty(CoreOptions.JUNCTION_POINTS);
        if (!this.omitLayout && !IterableExtensions.isNullOrEmpty((Iterable)jps)) {
            final JsonArray jsonJPs = this._jsonAdapter.newJsonArray();
            Consumer<KVector> _function_4 = new Consumer<KVector>(){

                @Override
                public void accept(KVector jp) {
                    JsonObject jsonPnt = JsonExporter.this._jsonAdapter.newJsonObject();
                    JsonExporter.this._jsonAdapter.addJsonObj(jsonPnt, "x", jp.x);
                    JsonExporter.this._jsonAdapter.addJsonObj(jsonPnt, "y", jp.y);
                    JsonExporter.this._jsonAdapter.addJsonArr(jsonJPs, (JsonElement)jsonPnt);
                }
            };
            jps.forEach((Consumer)_function_4);
            this._jsonAdapter.addJsonObj(jsonObj, "junctionPoints", (JsonElement)jsonJPs);
        }
        this.transformProperties((EMapPropertyHolder)edge, jsonObj);
    }

    private void transformSection(ElkEdgeSection section, Object sectionsA) {
        boolean _isNullOrEmpty_1;
        boolean _not_1;
        boolean _isNullOrEmpty;
        boolean _not;
        ElkConnectableShape _outgoingShape;
        boolean _tripleNotEquals_1;
        ElkConnectableShape _incomingShape;
        boolean _tripleNotEquals;
        JsonObject jsonObj = this.createAndRegister(section);
        JsonArray sections = this._jsonAdapter.toJsonArray(sectionsA);
        this._jsonAdapter.addJsonArr(sections, (JsonElement)jsonObj);
        JsonObject startPoint = this._jsonAdapter.newJsonObject();
        startPoint.addProperty("x", (Number)section.getStartX());
        startPoint.addProperty("y", (Number)section.getStartY());
        this._jsonAdapter.addJsonObj(jsonObj, "startPoint", (JsonElement)startPoint);
        JsonObject endPoint = this._jsonAdapter.newJsonObject();
        endPoint.addProperty("x", (Number)section.getEndX());
        endPoint.addProperty("y", (Number)section.getEndY());
        this._jsonAdapter.addJsonObj(jsonObj, "endPoint", (JsonElement)endPoint);
        if (!this.omitLayout && !IterableExtensions.isNullOrEmpty((Iterable)section.getBendPoints())) {
            final JsonArray bendPoints = this._jsonAdapter.newJsonArray();
            Consumer<ElkBendPoint> _function = new Consumer<ElkBendPoint>(){

                @Override
                public void accept(ElkBendPoint pnt) {
                    JsonObject jsonPnt = JsonExporter.this._jsonAdapter.newJsonObject();
                    jsonPnt.addProperty("x", (Number)pnt.getX());
                    jsonPnt.addProperty("y", (Number)pnt.getY());
                    JsonExporter.this._jsonAdapter.addJsonArr(bendPoints, (JsonElement)jsonPnt);
                }
            };
            section.getBendPoints().forEach((Consumer)_function);
            this._jsonAdapter.addJsonObj(jsonObj, "bendPoints", (JsonElement)bendPoints);
        }
        boolean bl = _tripleNotEquals = (_incomingShape = section.getIncomingShape()) != null;
        if (_tripleNotEquals) {
            jsonObj.addProperty("incomingShape", this.idByElement((EMapPropertyHolder)section.getIncomingShape()));
        }
        boolean bl2 = _tripleNotEquals_1 = (_outgoingShape = section.getOutgoingShape()) != null;
        if (_tripleNotEquals_1) {
            jsonObj.addProperty("outgoingShape", this.idByElement((EMapPropertyHolder)section.getOutgoingShape()));
        }
        boolean bl3 = _not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)section.getIncomingSections()));
        if (_not) {
            final JsonArray incomingSections = this._jsonAdapter.newJsonArray();
            Consumer<ElkEdgeSection> _function_1 = new Consumer<ElkEdgeSection>(){

                @Override
                public void accept(ElkEdgeSection sec) {
                    JsonExporter.this._jsonAdapter.addJsonArr(incomingSections, (JsonElement)JsonExporter.this._jsonAdapter.toJson(JsonExporter.this.idByElement((EMapPropertyHolder)sec)));
                }
            };
            section.getIncomingSections().forEach((Consumer)_function_1);
            this._jsonAdapter.addJsonObj(jsonObj, "incomingSections", (JsonElement)incomingSections);
        }
        boolean bl4 = _not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)section.getOutgoingSections()));
        if (_not_1) {
            final JsonArray outgoingSections = this._jsonAdapter.newJsonArray();
            Consumer<ElkEdgeSection> _function_2 = new Consumer<ElkEdgeSection>(){

                @Override
                public void accept(ElkEdgeSection sec) {
                    JsonExporter.this._jsonAdapter.addJsonArr(outgoingSections, (JsonElement)JsonExporter.this._jsonAdapter.toJson(JsonExporter.this.idByElement((EMapPropertyHolder)sec)));
                }
            };
            section.getOutgoingSections().forEach((Consumer)_function_2);
            this._jsonAdapter.addJsonObj(jsonObj, "outgoingSections", (JsonElement)outgoingSections);
        }
        this.transformProperties((EMapPropertyHolder)section, jsonObj);
    }

    private void transformLabel(ElkLabel label, Object array) {
        boolean _not;
        JsonObject jsonLabel = this._jsonAdapter.newJsonObject();
        jsonLabel.addProperty("text", label.getText());
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)label.getIdentifier());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            jsonLabel.addProperty("id", label.getIdentifier());
        }
        this._jsonAdapter.addJsonArr(this._jsonAdapter.toJsonArray(array), (JsonElement)jsonLabel);
        this.transformProperties((EMapPropertyHolder)label, jsonLabel);
        this.transferShapeLayout((ElkShape)label, jsonLabel);
    }

    private void transformProperties(EMapPropertyHolder holder, Object parentA) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)holder.getProperties());
        if (_isNullOrEmpty) {
            return;
        }
        final JsonObject jsonProps = this._jsonAdapter.newJsonObject();
        JsonObject parent = this._jsonAdapter.toJsonObject(parentA);
        this._jsonAdapter.addJsonObj(parent, "layoutOptions", (JsonElement)jsonProps);
        Consumer _function = new Consumer<Map.Entry<IProperty<?>, Object>>(){

            @Override
            public void accept(Map.Entry<IProperty<?>, Object> p) {
                String _xifexpression = null;
                _xifexpression = JsonExporter.this.shortLayoutOptionKeys ? JsonExporter.this.getShortOptionKey(p.getKey().getId()) : p.getKey().getId();
                String key = _xifexpression;
                jsonProps.addProperty(key, p.getValue().toString());
            }
        };
        holder.getProperties().entrySet().forEach(_function);
    }

    private void transferShapeLayout(ElkShape shape, Object jsonObjA) {
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        if (!this.omitLayout) {
            if (!this.omitZeroPos) {
                jsonObj.addProperty("x", (Number)shape.getX());
                jsonObj.addProperty("y", (Number)shape.getY());
            } else {
                double _y;
                boolean _notEquals_1;
                boolean _notEquals;
                double _x = shape.getX();
                boolean bl = _notEquals = _x != 0.0;
                if (_notEquals) {
                    jsonObj.addProperty("x", (Number)shape.getX());
                }
                boolean bl2 = _notEquals_1 = (_y = shape.getY()) != 0.0;
                if (_notEquals_1) {
                    jsonObj.addProperty("y", (Number)shape.getY());
                }
            }
        }
        if (!this.omitZeroDim) {
            jsonObj.addProperty("width", (Number)shape.getWidth());
            jsonObj.addProperty("height", (Number)shape.getHeight());
        } else {
            double _height;
            boolean _notEquals_3;
            boolean _notEquals_2;
            double _width = shape.getWidth();
            boolean bl = _notEquals_2 = _width != 0.0;
            if (_notEquals_2) {
                jsonObj.addProperty("width", (Number)shape.getWidth());
            }
            boolean bl3 = _notEquals_3 = (_height = shape.getHeight()) != 0.0;
            if (_notEquals_3) {
                jsonObj.addProperty("height", (Number)shape.getHeight());
            }
        }
    }

    private JsonObject createAndRegister(ElkNode node) {
        JsonObject obj = this._jsonAdapter.newJsonObject();
        String _elvis = null;
        String _identifier = node.getIdentifier();
        _elvis = _identifier != null ? _identifier : "n" + Integer.valueOf(this.nodeIdCounter);
        String id = _elvis;
        while (this.nodeIdMap.inverse().containsKey((Object)id)) {
            String _id = id;
            id = String.valueOf(_id) + "_";
        }
        obj.addProperty("id", id);
        ++this.nodeIdCounter;
        this.nodeIdMap.put((Object)node, (Object)id);
        this.nodeJsonMap.put(node, obj);
        return obj;
    }

    private JsonObject createAndRegister(ElkPort port) {
        JsonObject obj = this._jsonAdapter.newJsonObject();
        String _elvis = null;
        String _identifier = port.getIdentifier();
        _elvis = _identifier != null ? _identifier : "p" + Integer.valueOf(this.portIdCounter);
        String id = _elvis;
        while (this.portIdMap.inverse().containsKey((Object)id)) {
            String _id = id;
            id = String.valueOf(_id) + "_";
        }
        obj.addProperty("id", id);
        ++this.portIdCounter;
        this.portIdMap.put((Object)port, (Object)id);
        this.portJsonMap.put(port, obj);
        return obj;
    }

    private JsonObject createAndRegister(ElkEdge edge) {
        JsonObject obj = this._jsonAdapter.newJsonObject();
        String _elvis = null;
        String _identifier = edge.getIdentifier();
        _elvis = _identifier != null ? _identifier : "e" + Integer.valueOf(this.edgeIdCounter);
        String id = _elvis;
        while (this.edgeIdMap.inverse().containsKey((Object)id)) {
            String _id = id;
            id = String.valueOf(_id) + "_";
        }
        obj.addProperty("id", id);
        ++this.edgeIdCounter;
        this.edgeIdMap.put((Object)edge, (Object)id);
        this.edgeJsonMap.put(edge, obj);
        return obj;
    }

    private JsonObject createAndRegister(ElkEdgeSection section) {
        JsonObject obj = this._jsonAdapter.newJsonObject();
        String _elvis = null;
        String _identifier = section.getIdentifier();
        _elvis = _identifier != null ? _identifier : "s" + Integer.valueOf(this.edgeSectionIdCounter);
        String id = _elvis;
        while (this.edgeSectionIdMap.inverse().containsKey((Object)id)) {
            String _id = id;
            id = String.valueOf(_id) + "_";
        }
        obj.addProperty("id", id);
        this.edgeSectionIdCounter = this.edgeIdCounter + 1;
        this.edgeSectionIdMap.put((Object)section, (Object)id);
        this.edgeSectionJsonMap.put(section, obj);
        return obj;
    }

    private String _idByElement(ElkNode node) {
        return (String)this.nodeIdMap.get((Object)node);
    }

    private String _idByElement(ElkPort port) {
        return (String)this.portIdMap.get((Object)port);
    }

    private String _idByElement(ElkEdgeSection section) {
        return (String)this.edgeSectionIdMap.get((Object)section);
    }

    private String getShortOptionKey(String fullId) {
        LayoutOptionData option = LayoutMetaDataService.getInstance().getOptionData(fullId);
        Iterable idSplit = Splitter.on((String)".").split((CharSequence)option.getId());
        boolean foundMatch = false;
        int _size = IterableExtensions.size((Iterable)idSplit);
        int i = _size - 1;
        if (i >= 1 && Objects.equal((Object)option.getGroup(), (Object)((Object[])Conversions.unwrapArray((Object)idSplit, Object.class))[i - 1])) {
            --i;
        }
        while (i >= 0 && !foundMatch) {
            boolean _tripleNotEquals;
            Iterable suffix = IterableExtensions.drop((Iterable)idSplit, (int)i);
            LayoutOptionData _optionDataBySuffix = LayoutMetaDataService.getInstance().getOptionDataBySuffix(IterableExtensions.join((Iterable)suffix, (CharSequence)"."));
            boolean bl = _tripleNotEquals = _optionDataBySuffix != null;
            if (_tripleNotEquals) {
                foundMatch = true;
                continue;
            }
            --i;
        }
        if (foundMatch) {
            return IterableExtensions.join((Iterable)IterableExtensions.drop((Iterable)idSplit, (int)i), (CharSequence)".");
        }
        return option.getId();
    }

    public <T> Iterator<T> emptyIfNull(Iterator<T> iterator) {
        Iterator<T> _xifexpression = null;
        if (iterator == null) {
            return Collections.emptyIterator();
        }
        _xifexpression = iterator;
        return _xifexpression;
    }

    private String idByElement(EMapPropertyHolder node) {
        if (node instanceof ElkNode) {
            return this._idByElement((ElkNode)node);
        }
        if (node instanceof ElkPort) {
            return this._idByElement((ElkPort)node);
        }
        if (node instanceof ElkEdgeSection) {
            return this._idByElement((ElkEdgeSection)node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }
}

