/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.data.cmsis;

import com.github.zafarkhaja.semver.Version;
import org.eclipse.embedcdt.packs.core.ConsoleStream;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.eclipse.embedcdt.packs.data.Activator;
import org.eclipse.embedcdt.packs.data.Utils;
import org.eclipse.embedcdt.packs.data.cmsis.PdscUtils;
import org.eclipse.ui.console.MessageConsoleStream;

public class PdscTreeParser {
    protected MessageConsoleStream fOut = ConsoleStream.getConsoleOut();
    protected Version fSemVer;

    protected boolean checkValid(Node node) {
        if (node == null || !node.hasChildren()) {
            return false;
        }
        Leaf firstChild = node.getFirstChild();
        if (!firstChild.isType("package")) {
            String msg = "Missing <package>; instead, <" + firstChild.getType() + "> encountered";
            this.fOut.println("Error+" + msg);
            Utils.reportError(msg);
            return false;
        }
        String schemaVersion = firstChild.getProperty("schemaVersion");
        this.fSemVer = Version.valueOf((String)schemaVersion);
        if (!PdscUtils.isSchemaValid(this.fSemVer)) {
            Activator.log((String)("Unrecognised schema version " + schemaVersion));
            return false;
        }
        return true;
    }

    protected Node addUniqueVendor(Node parent, String vendorName, String vendorId) {
        if (parent.hasChildren()) {
            for (Leaf child : parent.getChildren()) {
                if (!vendorId.equals(child.getProperty("vendor.id"))) continue;
                return (Node)child;
            }
        }
        Node vendor = Node.addNewChild((Node)parent, (String)"vendor");
        vendor.setName(vendorName);
        vendor.putProperty("vendor.id", vendorId);
        return vendor;
    }

    protected String updatePosixSeparators(String spath) {
        return spath.replace('\\', '/');
    }
}

