/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.dsf;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.core.Messages;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.debug.gdbjtag.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.services.IGnuMcuDebuggerCommandsService;

public abstract class GnuMcuDebuggerCommandsService
extends AbstractDsfService
implements IGnuMcuDebuggerCommandsService {
    protected DsfSession fSession;
    protected ILaunchConfiguration fConfig;
    protected boolean fDoDoubleBackslash;
    protected DsfServicesTracker fTracker;
    protected IGDBBackend fGdbBackend;
    protected Map<String, Object> fAttributes;
    protected String fMode;

    public GnuMcuDebuggerCommandsService(DsfSession session, ILaunchConfiguration lc, String mode) {
        this(session, lc, mode, false);
    }

    public GnuMcuDebuggerCommandsService(DsfSession session, ILaunchConfiguration lc, String mode, boolean doubleBackslash) {
        super(session);
        this.fSession = session;
        this.fConfig = lc;
        this.fMode = mode;
        this.fDoDoubleBackslash = doubleBackslash;
    }

    public void initialize(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuDebuggerCommandsService.initialize()");
        }
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GnuMcuDebuggerCommandsService.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuDebuggerCommandsService.doInitialize()");
        }
        this.register(new String[]{IGnuMcuDebuggerCommandsService.class.getName(), this.getClass().getName()}, new Hashtable());
        if (Activator.getInstance().isDebugging()) {
            System.out.println(String.valueOf(this.getClass().getName()) + " registered ");
        }
        this.fTracker = new DsfServicesTracker(Activator.getInstance().getBundle().getBundleContext(), this.fSession.getId());
        this.fGdbBackend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        if (this.fGdbBackend == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", -1, "Cannot obtain GDBBackend service", null));
            rm.done();
            return;
        }
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuDebuggerCommandsService.shutdown()");
        }
        this.unregister();
        super.shutdown(rm);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.fAttributes = attributes;
    }

    @Override
    public IStatus addGnuMcuSelectRemoteCommands(List<String> commandsList) {
        String remoteTcpHost = DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "unspecified-ip-address");
        Integer remoteTcpPort = DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
        commandsList.add("-target-select remote " + remoteTcpHost + ":" + remoteTcpPort);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addGnuMcuRestartCommands(List<String> commandsList) {
        return this.addStartRestartCommands(true, commandsList);
    }

    protected String escapeSpaces(String file) {
        if (file.indexOf(32) >= 0) {
            return String.valueOf('\"') + file + '\"';
        }
        return file;
    }

    @Override
    public IStatus addLoadSymbolsCommands(List<String> commandsList) {
        IPath programPath = this.fGdbBackend.getProgramPath();
        if (!DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true).booleanValue()) {
            return Status.OK_STATUS;
        }
        String symbolsFileName = null;
        if (this.fAttributes.containsKey("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols") && DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true).booleanValue()) {
            if (programPath != null) {
                symbolsFileName = programPath.toOSString();
            }
        } else {
            symbolsFileName = DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", "");
            symbolsFileName = !symbolsFileName.isEmpty() ? DebugUtils.resolveAll(symbolsFileName, this.fAttributes) : null;
        }
        if (symbolsFileName == null) {
            return new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", -1, Messages.getString((String)"GDBJtagDebugger.err_no_img_file"), null);
        }
        if (EclipseUtils.isWindows()) {
            symbolsFileName = StringUtils.duplicateBackslashes((String)symbolsFileName);
        }
        String file = this.escapeSpaces(symbolsFileName);
        String symbolsOffset = DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", "");
        if (!symbolsOffset.isEmpty()) {
            symbolsOffset = "0x" + symbolsOffset;
            commandsList.add("add-symbol-file " + file + " " + symbolsOffset);
        } else {
            commandsList.add("symbol-file " + file);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addLoadImageCommands(List<String> commandsList) {
        String imageOffset;
        IPath programPath = this.fGdbBackend.getProgramPath();
        String imageFileName = null;
        if (this.fAttributes.containsKey("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage") && DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true).booleanValue()) {
            if (programPath != null) {
                imageFileName = programPath.toOSString();
            }
        } else {
            imageFileName = DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.imageFileName", "");
            imageFileName = !imageFileName.isEmpty() ? DebugUtils.resolveAll(imageFileName, this.fAttributes) : null;
        }
        if (imageFileName == null) {
            return new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", -1, Messages.getString((String)"GDBJtagDebugger.err_no_img_file"), null);
        }
        imageFileName = DebugUtils.resolveAll(imageFileName, this.fAttributes);
        if (EclipseUtils.isWindows()) {
            imageFileName = StringUtils.duplicateBackslashes((String)imageFileName);
        }
        if (!(imageOffset = ((String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"")).trim()).isEmpty()) {
            imageOffset = imageFileName.endsWith(".elf") ? "" : "0x" + DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
        }
        String file = this.escapeSpaces(imageFileName);
        commandsList.add("load " + file + ' ' + imageOffset);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addSetPcCommands(List<String> commandsList) {
        String pcRegister;
        if (DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false).booleanValue() && !(pcRegister = ((String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.pcRegister", (Object)DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.imageOffset", ""))).trim()).isEmpty()) {
            commandsList.add("set $pc=0x" + pcRegister);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addStopAtCommands(List<String> commandsList) {
        String stopAt;
        if (this.fMode.equals("debug") && DebugUtils.getAttribute(this.fAttributes, "org.eclipse.cdt.debug.gdbjtag.core.setStopAt", false).booleanValue() && !(stopAt = ((String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.stopAt", (Object)"")).trim()).isEmpty()) {
            commandsList.add("tbreak " + stopAt);
        }
        return Status.OK_STATUS;
    }
}

