/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.dsf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.gdbjtag.core.GDBJtagDSFFinalLaunchSequence;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.DefaultGDBJtagDeviceImpl;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.embedcdt.debug.gdbjtag.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.dsf.GnuMcuDebuggerCommandsService;
import org.eclipse.embedcdt.debug.gdbjtag.services.IGnuMcuDebuggerCommandsService;
import org.eclipse.embedcdt.debug.gdbjtag.services.IPeripheralMemoryService;
import org.eclipse.embedcdt.debug.gdbjtag.services.IPeripheralsService;

public class GnuMcuFinalLaunchSequence
extends GDBJtagDSFFinalLaunchSequence {
    private Map<String, Object> fAttributes;
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private IGDBBackend fGdbBackend;
    private IGDBControl fCommandControl;
    private IMIProcesses fProcService;
    private IGDBJtagDevice fGdbJtagDevice;
    private String fMode;
    private IGnuMcuDebuggerCommandsService fDebuggerCommands;
    private String[] topPreInitSteps = new String[]{"stepCreatePeripheralService", "stepCreatePeripheralMemoryService", "stepCreateDebuggerCommandsService"};
    private String[] topToRemove = new String[]{"stepRemoteConnection", "stepAttachToProcess"};
    private String[] jtagPreInitSteps = new String[0];
    private String[] jtagResetStep = new String[]{"stepGnuMcuReset"};
    private String[] jtagStartStep = new String[]{"stepGnuMcuStart"};
    private String[] jtagToRemove = new String[]{"stepLoadSymbols", "stepResetBoard", "stepDelayStartup", "stepHaltBoard", "stepUserInitCommands", "stepLoadImage", "stepSetProgramCounter", "stepStopScript", "stepResumeScript", "stepUserDebugCommands"};

    public GnuMcuFinalLaunchSequence(DsfSession session, Map<String, Object> attributes, String mode, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        this.fAttributes = attributes;
        this.fSession = session;
        this.fMode = mode;
    }

    protected String[] getExecutionOrder(String group) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuFinalLaunchSequence.getExecutionOrder(" + group + ")");
        }
        ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder(group)));
        if ("GROUP_TOP_LEVEL".equals(group)) {
            int i = 0;
            while (i < this.topToRemove.length) {
                int ix = orderList.indexOf(this.jtagToRemove[i]);
                if (ix >= 0) {
                    orderList.remove(ix);
                }
                ++i;
            }
            orderList.addAll(0, Arrays.asList(this.topPreInitSteps));
        } else if ("GROUP_JTAG".equals(group)) {
            int i = 0;
            while (i < this.jtagToRemove.length) {
                int ix = orderList.indexOf(this.jtagToRemove[i]);
                if (ix >= 0) {
                    orderList.remove(ix);
                }
                ++i;
            }
            orderList.addAll(0, Arrays.asList(this.jtagPreInitSteps));
            orderList.addAll(orderList.indexOf("stepConnectToTarget") + 1, Arrays.asList(this.jtagResetStep));
            orderList.addAll(orderList.indexOf("stepJTAGCleanup"), Arrays.asList(this.jtagStartStep));
        }
        return orderList.toArray(new String[orderList.size()]);
    }

    @ReflectionSequence.Execute
    public void stepCreatePeripheralService(RequestMonitor rm) {
        GdbLaunch launch = (GdbLaunch)this.fSession.getModelAdapter(ILaunch.class);
        IPeripheralsService service = (IPeripheralsService)launch.getServiceFactory().createService(IPeripheralsService.class, launch.getSession(), new Object[0]);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuFinalLaunchSequence.stepCreatePeripheralService() " + service);
        }
        if (service != null) {
            service.initialize(rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", "Unable to start PeripheralService"));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepCreatePeripheralMemoryService(RequestMonitor rm) {
        GdbLaunch launch = (GdbLaunch)this.fSession.getModelAdapter(ILaunch.class);
        IPeripheralMemoryService service = (IPeripheralMemoryService)launch.getServiceFactory().createService(IPeripheralMemoryService.class, launch.getSession(), new Object[]{launch.getLaunchConfiguration()});
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuFinalLaunchSequence.stepCreatePeripheralMemoryService() " + service);
        }
        if (service != null) {
            service.initialize(rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", "Unable to start PeripheralMemoryService"));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepCreateDebuggerCommandsService(RequestMonitor rm) {
        GdbLaunch launch = (GdbLaunch)this.fSession.getModelAdapter(ILaunch.class);
        GnuMcuDebuggerCommandsService service = (GnuMcuDebuggerCommandsService)launch.getServiceFactory().createService(IGnuMcuDebuggerCommandsService.class, launch.getSession(), new Object[]{launch.getLaunchConfiguration()});
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuFinalLaunchSequence.stepCreateDebuggerCommandsService() " + service);
        }
        if (service != null) {
            service.initialize(rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", "Unable to start GnuMcuDebuggerCommandsService"));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepInitializeFinalLaunchSequence(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuFinalLaunchSequence.stepInitializeFinalLaunchSequence()");
        }
        this.fTracker = new DsfServicesTracker(Activator.getInstance().getBundle().getBundleContext(), this.fSession.getId());
        this.fGdbBackend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        if (this.fGdbBackend == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", -1, "Cannot obtain GDBBackend service", null));
            rm.done();
            return;
        }
        this.fCommandControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        if (this.fCommandControl == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", -1, "Cannot obtain control service", null));
            rm.done();
            return;
        }
        this.fCommandControl.getCommandFactory();
        this.fProcService = (IMIProcesses)this.fTracker.getService(IMIProcesses.class);
        if (this.fProcService == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", -1, "Cannot obtain process service", null));
            rm.done();
            return;
        }
        this.fDebuggerCommands = (IGnuMcuDebuggerCommandsService)this.fTracker.getService(IGnuMcuDebuggerCommandsService.class);
        if (this.fDebuggerCommands == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", -1, "Cannot obtain debugger commands service", null));
            rm.done();
            return;
        }
        this.fDebuggerCommands.setAttributes(this.fAttributes);
        super.stepInitializeFinalLaunchSequence(rm);
    }

    @ReflectionSequence.Execute
    public void stepInitializeJTAGFinalLaunchSequence(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuFinalLaunchSequence.stepInitializeJTAGFinalLaunchSequence()");
        }
        super.stepInitializeJTAGFinalLaunchSequence(rm);
    }

    private void queueCommands(List<String> commands, RequestMonitor rm) {
        DebugUtils.queueCommands(commands, rm, this.fCommandControl, this.getExecutor());
    }

    @ReflectionSequence.Execute
    public void stepSourceGDBInitFile(final RequestMonitor rm) {
        final ArrayList<String> commandsList = new ArrayList<String>();
        IStatus status = this.fDebuggerCommands.addGdbInitCommandsCommands(commandsList);
        if (!status.isOK()) {
            rm.setStatus(status);
            rm.done();
            return;
        }
        super.stepSourceGDBInitFile(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GnuMcuFinalLaunchSequence.this.queueCommands(commandsList, rm);
            }
        });
    }

    @ReflectionSequence.Execute
    public void stepRetrieveJTAGDevice(RequestMonitor rm) {
        NullPointerException exception = null;
        try {
            this.fGdbJtagDevice = new DefaultGDBJtagDeviceImpl();
        }
        catch (NullPointerException e) {
            exception = e;
        }
        if (this.fGdbJtagDevice == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag", -1, "Cannot get JTAG device", (Throwable)exception));
            rm.done();
        } else {
            super.stepRetrieveJTAGDevice(rm);
        }
    }

    @ReflectionSequence.Execute
    public void stepConnectToTarget(RequestMonitor rm) {
        ArrayList<String> commandsList = new ArrayList<String>();
        IStatus status = this.fDebuggerCommands.addGnuMcuSelectRemoteCommands(commandsList);
        if (!status.isOK()) {
            rm.setStatus(status);
            rm.done();
            return;
        }
        this.queueCommands(commandsList, rm);
    }

    @ReflectionSequence.Execute
    public void stepGnuMcuReset(RequestMonitor rm) {
        ArrayList<String> commandsList = new ArrayList<String>();
        IStatus status = this.fDebuggerCommands.addGnuMcuResetCommands(commandsList);
        if (!status.isOK()) {
            rm.setStatus(status);
            rm.done();
            return;
        }
        this.queueCommands(commandsList, rm);
    }

    @ReflectionSequence.Execute
    public void stepGnuMcuStart(RequestMonitor rm) {
        ArrayList<String> commandsList = new ArrayList<String>();
        IStatus status = this.fDebuggerCommands.addGnuMcuStartCommands(commandsList);
        if (!status.isOK()) {
            rm.setStatus(status);
            rm.done();
            return;
        }
        this.queueCommands(commandsList, rm);
    }

    @ReflectionSequence.Execute
    public void stepStartTrackingBreakpoints(RequestMonitor rm) {
        if (this.fMode.equals("debug")) {
            super.stepStartTrackingBreakpoints(rm);
        } else {
            rm.done();
        }
    }
}

