/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.ui;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class DirectoryNotStrictFieldEditor
extends DirectoryFieldEditor {
    private boolean fIsStrict;

    public DirectoryNotStrictFieldEditor(String buildToolsPathKey, String toolsPaths_label, Composite fieldEditorParent, boolean isStrict) {
        super(buildToolsPathKey, toolsPaths_label, fieldEditorParent);
        this.fIsStrict = isStrict;
    }

    protected boolean doCheckState() {
        if (this.fIsStrict) {
            String substitutedFileName;
            String fileName = this.getTextControl().getText();
            if ((fileName = fileName.trim()).isEmpty() && this.isEmptyStringAllowed()) {
                return true;
            }
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                substitutedFileName = manager.performStringSubstitution(fileName);
            }
            catch (CoreException e) {
                return false;
            }
            File file = new File(substitutedFileName);
            return file.isDirectory();
        }
        return true;
    }
}

