/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.packs.jobs;

import ilg.gnumcueclipse.packs.core.ConsoleStream;
import ilg.gnumcueclipse.packs.core.Utils;
import ilg.gnumcueclipse.packs.core.data.PacksStorage;
import ilg.gnumcueclipse.packs.core.tree.Node;
import ilg.gnumcueclipse.packs.data.DataManager;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.console.MessageConsoleStream;

public class RemoveJob
extends Job {
    private static boolean fgRunning = false;
    private MessageConsoleStream fOut = ConsoleStream.getConsoleOut();
    private TreeSelection fSelection;
    private IProgressMonitor fMonitor;
    private DataManager fDataManager;

    public RemoveJob(String name, TreeSelection selection) {
        super(name);
        this.fSelection = selection;
        this.fDataManager = DataManager.getInstance();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status;
        if (fgRunning) {
            return Status.CANCEL_STATUS;
        }
        fgRunning = true;
        this.fMonitor = monitor;
        long beginTime = System.currentTimeMillis();
        this.fOut.println();
        this.fOut.println(Utils.getCurrentDateTime());
        this.fOut.println("Removing packs...");
        LinkedList<Node> packsToRemove = new LinkedList<Node>();
        Object[] objectArray = this.fSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Node node = (Node)obj;
            if (node.isType("version") & node.isBooleanProperty("installed")) {
                packsToRemove.add(node);
            }
            ++n2;
        }
        int workUnits = packsToRemove.size();
        monitor.beginTask("Remove packs", workUnits);
        LinkedList<Node> removedPacksList = new LinkedList<Node>();
        for (Node versionNode : packsToRemove) {
            if (monitor.isCanceled()) break;
            String packFullName = versionNode.getProperty("archive.name");
            monitor.subTask(packFullName);
            this.fOut.println("Remove \"" + packFullName + "\".");
            try {
                String dest = versionNode.getProperty("dest.folder");
                IPath versionFolderPath = PacksStorage.getFolderPath().append(dest);
                this.fOut.println("Recursive erase \"" + versionFolderPath + "\".");
                ilg.gnumcueclipse.packs.data.Utils.deleteFolderRecursive((File)versionFolderPath.toFile());
                this.fMonitor.worked(1);
                versionNode.setBooleanProperty("installed", false);
                removedPacksList.add(versionNode);
                ilg.gnumcueclipse.packs.data.Utils.reportInfo((String)("Pack " + packFullName + " removed."));
            }
            catch (IOException e) {
                this.fOut.println(ilg.gnumcueclipse.packs.data.Utils.reportError((String)e.getMessage()));
                break;
            }
        }
        int count = removedPacksList.size();
        if (count > 0) {
            this.fDataManager.notifyUpdateView("update.versions", removedPacksList);
            this.fDataManager.notifyInstallRemove();
        }
        if (monitor.isCanceled()) {
            this.fOut.println("Job cancelled.");
            status = Status.CANCEL_STATUS;
        } else {
            long endTime = System.currentTimeMillis();
            long duration = endTime - beginTime;
            if (duration == 0L) {
                duration = 1L;
            }
            if (count == 1) {
                this.fOut.println("1 pack removed.");
            } else {
                this.fOut.println(String.valueOf(count) + " packs removed.");
            }
            this.fOut.print("Remove completed in ");
            this.fOut.println(String.valueOf(duration) + "ms.");
            status = Status.OK_STATUS;
        }
        fgRunning = false;
        return status;
    }
}

