/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.dsf;

import ilg.gnumcueclipse.debug.gdbjtag.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.dsf.GdbMcuMemoryBlockRetrievalManager;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.cdt.dsf.debug.internal.provisional.model.IMemoryBlockRetrievalManager;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.AbstractCLIProcess;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;

public class GnuMcuLaunch
extends GdbLaunch {
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private DefaultDsfExecutor fExecutor = (DefaultDsfExecutor)this.getDsfExecutor();
    private IMemoryBlockRetrievalManager fMemRetrievalManager;

    public GnuMcuLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
        this.fSession = this.getSession();
    }

    private DsfServicesTracker getTracker() {
        if (this.fTracker == null) {
            this.fTracker = new DsfServicesTracker(Activator.getInstance().getBundle().getBundleContext(), this.fSession.getId());
        }
        return this.fTracker;
    }

    public void initialize() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuLaunch.initialize() " + (Object)((Object)this));
        }
        try {
            ILaunchConfigurationWorkingCopy config = this.getLaunchConfiguration().getWorkingCopy();
            this.provideDefaults(config);
            config.doSave();
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
        try {
            super.initialize();
            DsfRunnable initRunnable = new DsfRunnable(){

                public void run() {
                    GnuMcuLaunch.this.fTracker = new DsfServicesTracker(Activator.getInstance().getBundle().getBundleContext(), GnuMcuLaunch.this.fSession.getId());
                }
            };
            this.fExecutor.submit((Runnable)initRunnable).get();
        }
        catch (Exception e) {
            Activator.log((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag", 10005, "Error initializing launch", (Throwable)e));
        }
    }

    protected void provideDefaults(ILaunchConfigurationWorkingCopy config) throws CoreException {
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true);
        }
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true);
        }
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        }
    }

    public void shutdownSession(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuLaunch.shutdownSession() " + (Object)((Object)this));
        }
        super.shutdownSession(rm);
    }

    public void initializeControl() throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuLaunch.initializeControl()");
        }
        try {
            this.fExecutor.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws CoreException {
                    GnuMcuLaunch.this.fMemRetrievalManager = (IMemoryBlockRetrievalManager)new GdbMcuMemoryBlockRetrievalManager("org.eclipse.cdt.dsf.gdb", GnuMcuLaunch.this.getLaunchConfiguration(), GnuMcuLaunch.this.fSession);
                    GnuMcuLaunch.this.fSession.registerModelAdapter(IMemoryBlockRetrievalManager.class, (Object)GnuMcuLaunch.this.fMemRetrievalManager);
                    GnuMcuLaunch.this.fSession.addServiceEventListener((Object)GnuMcuLaunch.this.fMemRetrievalManager, null);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    @ThreadSafeAndProhibitedFromDsfExecutor(value="getDsfExecutor()")
    public IProcess addClientProcess(String label) throws CoreException {
        IProcess newProcess = null;
        try {
            AbstractCLIProcess cliProc = (AbstractCLIProcess)this.getDsfExecutor().submit((Callable)new Callable<AbstractCLIProcess>(){

                @Override
                public AbstractCLIProcess call() throws CoreException {
                    IGDBControl gdb = (IGDBControl)GnuMcuLaunch.this.fTracker.getService(IGDBControl.class);
                    if (gdb != null) {
                        return gdb.getCLIProcess();
                    }
                    return null;
                }
            }).get();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.gdbProcess");
            newProcess = DebugPlugin.newProcess((ILaunch)this, (Process)cliProc, (String)label, attributes);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
        return newProcess;
    }
}

