/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.jlink.dsf;

import ilg.gnumcueclipse.core.StringUtils;
import ilg.gnumcueclipse.debug.gdbjtag.dsf.GnuMcuGdbServerBackend;
import ilg.gnumcueclipse.debug.gdbjtag.jlink.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.jlink.Configuration;
import ilg.gnumcueclipse.debug.gdbjtag.jlink.SemihostingProcess;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class GdbServerBackend
extends GnuMcuGdbServerBackend {
    protected boolean fDoStartSemihostingConsole = false;
    protected Process fSemihostingProcess;
    protected SemihostingMonitorJob fSemihostingMonitorJob;
    protected IMIBackend.State fSemihostingBackendState = IMIBackend.State.NOT_INITIALIZED;
    protected int fSemihostingExitValue = 0;
    protected int fGdbServerLaunchTimeout = 15;

    public GdbServerBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.GdbServerBackend(" + session + "," + lc.getName() + ")");
        }
    }

    public void initialize(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.GdbServerBackend.initialize()");
        }
        try {
            this.fDoStartGdbServer = Configuration.getDoStartGdbServer(this.fLaunchConfiguration);
            this.fDoStartSemihostingConsole = Configuration.getDoAddSemihostingConsole(this.fLaunchConfiguration);
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag.jlink", -1, "Cannot get configuration", (Throwable)e));
            rm.done();
            return;
        }
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GdbServerBackend.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.GdbServerBackend.doInitialize()");
        }
        if (this.fDoStartGdbServer && this.fDoStartSemihostingConsole) {
            final Sequence.Step[] initializeSteps = new Sequence.Step[]{new SemihostingStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new SemihostingMonitorStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)};
            Sequence startupSequence = new Sequence(this.getExecutor(), rm){

                public Sequence.Step[] getSteps() {
                    return initializeSteps;
                }
            };
            this.getExecutor().execute((Runnable)startupSequence);
        } else {
            rm.done();
        }
    }

    public void shutdown(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.GdbServerBackend.shutdown()");
        }
        if (this.fDoStartGdbServer && this.fDoStartSemihostingConsole) {
            final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new SemihostingMonitorStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new SemihostingStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN)};
            Sequence startupSequence = new Sequence(this.getExecutor(), (RequestMonitor)new ImmediateRequestMonitor(rm){

                protected void handleSuccess() {
                    GdbServerBackend.super.shutdown(rm);
                }
            }){

                public Sequence.Step[] getSteps() {
                    return shutdownSteps;
                }
            };
            this.getExecutor().execute((Runnable)startupSequence);
        } else {
            super.shutdown(rm);
        }
    }

    public void destroy() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.GdbServerBackend.destroy() " + Thread.currentThread());
        }
        if (this.fSemihostingProcess != null && this.fSemihostingBackendState == IMIBackend.State.STARTED) {
            this.fSemihostingProcess.destroy();
        }
        super.destroy();
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    public String[] getServerCommandLineArray() {
        String[] commandLineArray = Configuration.getGdbServerCommandLineArray(this.fLaunchConfiguration);
        return commandLineArray;
    }

    public String getServerCommandName() {
        String[] commandLineArray = this.getServerCommandLineArray();
        if (commandLineArray == null) {
            return null;
        }
        String fullCommand = commandLineArray[0];
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public int getServerLaunchTimeoutSeconds() {
        return this.fGdbServerLaunchTimeout;
    }

    public String getServerName() {
        return "J-Link GDB Server";
    }

    public String getSemihostingName() {
        return "J-Link GDB";
    }

    public String getStartingSemihostingJobName() {
        return "Starting " + this.getSemihostingName() + " Semihosting Process";
    }

    public String getTerminatingSemihostingJobName() {
        return "Terminating " + this.getSemihostingName() + " Semihosting Process";
    }

    public boolean matchStdOutExpectedPattern(String line) {
        return line.indexOf("Waiting for GDB connection") >= 0;
    }

    public String prepareMessageBoxText(int exitCode) {
        String name;
        String body = "";
        if (exitCode == -1) {
            body = "Unknown error. Please use J-Link software v4.96f or later.";
        } else if (exitCode == -2) {
            body = "Could not listen on tcp port. Please check if another version of the server is running.";
        } else if (exitCode == -3) {
            body = "Could not connect to target. Please check if target is powered and if ribbon cable is plugged properly.";
        } else if (exitCode == -4) {
            body = "Failed to accept a connection from GDB client.";
        } else if (exitCode == -5) {
            body = "Failed to parse the command line. Please check the command line parameters.";
        } else if (exitCode == -6) {
            try {
                name = Configuration.getGdbServerDeviceName(this.fLaunchConfiguration);
                body = "Device name '" + name + "' not recognised. Please check http://www.segger.com/supported-devices.html for the supported device names.";
            }
            catch (CoreException e) {
                Activator.log((Throwable)e);
            }
        } else if (exitCode == -7) {
            body = "Could not connect to J-Link. Please check if plugged into USB port or Ethernet switch.";
        }
        name = this.getServerCommandName();
        if (name == null) {
            name = "GDB Server";
        }
        String tail = "\n\nFor more details, see the " + name + " console.";
        if (body.isEmpty()) {
            return String.valueOf(this.getServerName()) + " failed with code (" + exitCode + ")." + tail;
        }
        return String.valueOf(this.getServerName()) + " failed: \n" + body + tail;
    }

    public Process getSemihostingProcess() {
        return this.fSemihostingProcess;
    }

    private class SemihostingMonitorJob
    extends Job {
        boolean fMonitorExited;
        DsfRunnable fMonitorStarted;
        Process fProcess;

        SemihostingMonitorJob(Process process, DsfRunnable monitorStarted) {
            super("Semihosting process monitor job.");
            this.fMonitorExited = false;
            this.fProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Process process = this.fProcess;
            synchronized (process) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("jlink.SemihostingMonitorJob.run() submit " + this.fMonitorStarted + " thread " + this.getThread());
                }
                GdbServerBackend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                try {
                    this.fProcess.waitFor();
                    GdbServerBackend.this.fSemihostingExitValue = this.fProcess.exitValue();
                    GdbServerBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                        public void run() {
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("jlink.SemihostingMonitorJob.run() run() thread " + SemihostingMonitorJob.this.getThread());
                            }
                            GdbServerBackend.this.destroy();
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("jlink.SemihostingMonitorJob.run() run() State.TERMINATED");
                            }
                            ((SemihostingMonitorJob)SemihostingMonitorJob.this).GdbServerBackend.this.fSemihostingBackendState = IMIBackend.State.TERMINATED;
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("jlink.SemihostingMonitorJob.run() fMonitorExited = true thread " + this.getThread());
                }
                this.fMonitorExited = true;
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fProcess;
            synchronized (process) {
                if (!this.fMonitorExited) {
                    Thread thread = this.getThread();
                    if (thread != null) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("jlink.SemihostingMonitorJob.kill() interrupt " + thread.toString());
                        }
                        thread.interrupt();
                    } else {
                        Activator.log((String)"jlink.SemihostingMonitorJob.kill() null thread");
                    }
                }
            }
        }
    }

    protected class SemihostingMonitorStep
    extends GDBControl.InitializationShutdownStep {
        SemihostingMonitorStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingMonitorStep.initialize()");
            }
            if (GdbServerBackend.this.fServerBackendState != IMIBackend.State.STARTED) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("jlink.SemihostingMonitorStep.initialise() skipped");
                }
                rm.done();
                return;
            }
            GdbServerBackend.this.fSemihostingMonitorJob = new SemihostingMonitorJob(GdbServerBackend.this.fSemihostingProcess, new DsfRunnable(){

                public void run() {
                    rm.done();
                }
            });
            GdbServerBackend.this.fSemihostingMonitorJob.schedule();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingMonitorStep.shutdown()");
            }
            if (GdbServerBackend.this.fSemihostingMonitorJob != null) {
                GdbServerBackend.this.fSemihostingMonitorJob.kill();
            }
            requestMonitor.done();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingMonitorStep.shutdown() return");
            }
        }
    }

    protected class SemihostingStep
    extends GDBControl.InitializationShutdownStep {
        SemihostingStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingStep.initialise()");
            }
            if (GdbServerBackend.this.fServerBackendState != IMIBackend.State.STARTED) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("jlink.SemihostingStep.initialise() skipped");
                }
                rm.done();
                return;
            }
            class SemihostingLaunchMonitor {
                boolean fLaunched = false;
                boolean fTimedOut = false;

                SemihostingLaunchMonitor() {
                }
            }
            final SemihostingLaunchMonitor fSemihostingLaunchMonitor = new SemihostingLaunchMonitor();
            final RequestMonitor fTmpLaunchRequestMonitor = new RequestMonitor((Executor)GdbServerBackend.this.getExecutor(), rm){
                {
                    super($anonymous0, $anonymous1);
                }

                protected void handleCompleted() {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("jlink.SemihostingStep.initialise() handleCompleted()");
                    }
                    if (!fSemihostingLaunchMonitor.fTimedOut) {
                        fSemihostingLaunchMonitor.fLaunched = true;
                        if (!this.isSuccess()) {
                            rm.setStatus(this.getStatus());
                        }
                        rm.done();
                    }
                }
            };
            final Job startSemihostingJob = new Job(GdbServerBackend.this.getStartingSemihostingJobName()){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (fTmpLaunchRequestMonitor.isCanceled()) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("jlink.SemihostingStep startSemihostingJob run cancel");
                        }
                        fTmpLaunchRequestMonitor.setStatus((IStatus)new Status(8, "ilg.gnumcueclipse.debug.gdbjtag.jlink", -1, String.valueOf(GdbServerBackend.this.getStartingSemihostingJobName()) + " cancelled.", null));
                        fTmpLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    try {
                        String host = "localhost";
                        int port = GdbServerBackend.this.fLaunchConfiguration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerTelnetPortNumber", 2333);
                        ((SemihostingStep)SemihostingStep.this).GdbServerBackend.this.fSemihostingProcess = SemihostingStep.this.launchSemihostingProcess(host, port);
                        GdbServerBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                if (Activator.getInstance().isDebugging()) {
                                    System.out.println("jlink.SemihostingStep startSemihostingJob run State.STARTED");
                                }
                                ((SemihostingStep)(this).SemihostingStep.this).GdbServerBackend.this.fSemihostingBackendState = IMIBackend.State.STARTED;
                            }
                        });
                    }
                    catch (CoreException e) {
                        fTmpLaunchRequestMonitor.setStatus((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag.jlink", -1, e.getMessage(), (Throwable)e));
                        fTmpLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    fTmpLaunchRequestMonitor.done();
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("jlink.SemihostingStep startSemihostingJob run completed");
                    }
                    return Status.OK_STATUS;
                }
            };
            startSemihostingJob.schedule();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingStep.initialise() after job schedule");
            }
            GdbServerBackend.this.getExecutor().schedule(new Runnable(){
                {
                }

                @Override
                public void run() {
                    if (!fSemihostingLaunchMonitor.fLaunched) {
                        fSemihostingLaunchMonitor.fTimedOut = true;
                        Thread jobThread = startSemihostingJob.getThread();
                        if (jobThread != null) {
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("jlink.SemihostingStep interrupt thread " + jobThread);
                            }
                            jobThread.interrupt();
                        }
                        rm.setStatus((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag.jlink", 5010, String.valueOf(GdbServerBackend.this.getStartingSemihostingJobName()) + " timed out.", null));
                        rm.done();
                    }
                }
            }, (long)GdbServerBackend.this.getServerLaunchTimeoutSeconds(), TimeUnit.SECONDS);
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingStep.initialise() return");
            }
        }

        protected void shutdown(final RequestMonitor requestMonitor) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingStep.shutdown()");
            }
            if (GdbServerBackend.this.fSemihostingBackendState != IMIBackend.State.STARTED) {
                requestMonitor.done();
                return;
            }
            new Job(GdbServerBackend.this.getTerminatingSemihostingJobName()){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("jlink.SemihostingStep.shutdown() run()");
                        }
                        GdbServerBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                if (Activator.getInstance().isDebugging()) {
                                    System.out.println("jlink.SemihostingStep.shutdown() run() run()");
                                }
                                GdbServerBackend.this.destroy();
                                if (((SemihostingStep)(this).SemihostingStep.this).GdbServerBackend.this.fSemihostingMonitorJob.fMonitorExited) {
                                    if (Activator.getInstance().isDebugging()) {
                                        System.out.println("jlink.SemihostingStep.shutdown() run() run() State.TERMINATED");
                                    }
                                    ((SemihostingStep)(this).SemihostingStep.this).GdbServerBackend.this.fSemihostingBackendState = IMIBackend.State.TERMINATED;
                                }
                            }
                        }).get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {}
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("jlink.SemihostingStep.shutdown() run() before getting exitValue");
                    }
                    int attempts = 0;
                    while (attempts < 10) {
                        try {
                            ((SemihostingStep)SemihostingStep.this).GdbServerBackend.this.fSemihostingExitValue = ((SemihostingStep)SemihostingStep.this).GdbServerBackend.this.fSemihostingProcess.exitValue();
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("jlink.SemihostingStep.shutdown() run() return");
                            }
                            requestMonitor.done();
                            return Status.OK_STATUS;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++attempts;
                        }
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("jlink.SemihostingStep.shutdown() run() REQUEST_FAILED");
                    }
                    requestMonitor.setStatus((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag.jlink", 10004, "GDB semihosting terminate failed", null));
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingStep.shutdown() return");
            }
        }

        protected Process launchSemihostingProcess(String host, int port) throws CoreException {
            SemihostingProcess proc = new SemihostingProcess(host, port);
            proc.submit();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingStep.launchSemihostingProcess() return " + proc);
            }
            return proc;
        }
    }
}

