/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.packs.core.data;

import ilg.gnumcueclipse.core.Xml;
import ilg.gnumcueclipse.packs.core.tree.Leaf;
import ilg.gnumcueclipse.packs.core.tree.Node;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlGenericParser {
    public boolean isProperty(String name, Leaf node) {
        return false;
    }

    public Node parse(Document document) {
        Element packageElement = document.getDocumentElement();
        Node tree = new Node("root");
        tree.setPackType(Leaf.PACK_TYPE_CMSIS);
        this.parseRecusive(packageElement, tree);
        return tree;
    }

    private void parseRecusive(Element el, Node parent) {
        String type = el.getNodeName();
        Leaf node = null;
        List children = Xml.getChildrenElementsList((Element)el);
        if (!children.isEmpty()) {
            node = Node.addNewChild(parent, type);
            node.setPackType(Leaf.PACK_TYPE_CMSIS);
            for (Element child : children) {
                String childName = child.getNodeName();
                if (this.isProperty(childName, node)) {
                    String content = Xml.getElementContent((Element)child);
                    node.putNonEmptyProperty(childName, content);
                    continue;
                }
                this.parseRecusive(child, (Node)node);
            }
        } else {
            String content = Xml.getElementContent((Element)el);
            NamedNodeMap attributes = el.getAttributes();
            if (attributes == null || attributes.getLength() == 0) {
                if ("description".equals(type)) {
                    parent.setDescription(content);
                } else if ("name".equals(type)) {
                    parent.setName(content);
                    parent.putProperty("name", content);
                } else {
                    parent.putNonEmptyProperty(type, content);
                }
                return;
            }
            node = Leaf.addNewChild(parent, type);
            node.setPackType(Leaf.PACK_TYPE_CMSIS);
            node.putNonEmptyProperty("xml.content", content);
        }
        NamedNodeMap attributes = el.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String name = attributes.item(i).getNodeName();
                node.putProperty(name, el.getAttribute(name));
                ++i;
            }
        }
    }
}

