/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.packs.data;

import ilg.gnumcueclipse.core.Xml;
import ilg.gnumcueclipse.packs.core.ConsoleStream;
import ilg.gnumcueclipse.packs.core.data.PacksStorage;
import ilg.gnumcueclipse.packs.core.tree.Leaf;
import ilg.gnumcueclipse.packs.core.tree.Node;
import ilg.gnumcueclipse.packs.core.tree.PackNode;
import ilg.gnumcueclipse.packs.data.Activator;
import ilg.gnumcueclipse.packs.data.UsingDefaultFileException;
import ilg.gnumcueclipse.packs.xcdl.ContentParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ui.console.MessageConsoleStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Repos {
    public static final String REPOS_FILE_NAME = ".repos.xml";
    public static final String CMSIS_PACK_TYPE = "CMSIS Pack";
    public static final String XCDL_CMSIS_PACK_TYPE = "XCDL/CMSIS Pack";
    public static final String UNUSED_PACK_TYPE = "Unused";
    public static final String[] TYPES = new String[]{"CMSIS Pack", "XCDL/CMSIS Pack", "Unused"};
    private static final Repos fgInstance = new Repos();
    private List<Map<String, Object>> fList = null;
    private MessageConsoleStream fOut = ConsoleStream.getConsoleOut();

    public static Repos getInstance() {
        return fgInstance;
    }

    public List<Map<String, Object>> getDefaultList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", CMSIS_PACK_TYPE);
        map.put("name", "Keil");
        map.put("url", "https://www.keil.com/pack/index.pidx");
        list.add(map);
        this.fList = list;
        return list;
    }

    public String[] convertToArray(Map<String, Object> map) {
        String[] sa = new String[map.size()];
        sa[0] = (String)map.get("type");
        sa[1] = (String)map.get("name");
        sa[2] = (String)map.get("url");
        return sa;
    }

    public Map<String, Object> convertToMap(String[] sa) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", sa[0]);
        map.put("name", sa[1]);
        map.put("url", sa[2]);
        return map;
    }

    public void updateList() {
        this.fList = null;
        this.getList();
    }

    public List<Map<String, Object>> getList() {
        if (this.fList != null) {
            return this.fList;
        }
        boolean useDefaults = false;
        try {
            List<Map<String, Object>> list = this.parseFile();
            this.fList = list;
            return list;
        }
        catch (UsingDefaultFileException e) {
            Activator.log((String)e.getMessage());
            useDefaults = true;
        }
        catch (Exception e) {
            Activator.log((Throwable)e);
        }
        List<Map<String, Object>> list = this.getDefaultList();
        if (useDefaults) {
            try {
                this.putList(list);
            }
            catch (IOException iOException) {}
        }
        this.fList = list;
        return list;
    }

    private List<Map<String, Object>> parseFile() throws IOException, ParserConfigurationException, SAXException {
        File file = PacksStorage.getFileObject((String)REPOS_FILE_NAME);
        if (!file.exists()) {
            throw new UsingDefaultFileException("File .repos.xml does not exist, using defaults.");
        }
        InputSource inputSource = new InputSource(new FileInputStream(file));
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = parser.parse(inputSource);
        Element repositoriesElement = document.getDocumentElement();
        if (!"repositories".equals(repositoriesElement.getNodeName())) {
            throw new IOException("Missing <repositories>.");
        }
        ArrayList<Map<String, Object>> sitesList = new ArrayList<Map<String, Object>>();
        List repositoryElements = Xml.getChildrenElementsList((Element)repositoriesElement, (String)"repository");
        for (Element repositoryElement : repositoryElements) {
            String type = "(unknown)";
            String url = "(unknown)";
            String name = "";
            List childElements = Xml.getChildrenElementsList((Element)repositoryElement);
            for (Element childElement : childElements) {
                String elementName = childElement.getNodeName();
                String elementContent = Xml.getElementContent((Element)childElement);
                if ("type".equals(elementName)) {
                    type = elementContent;
                    continue;
                }
                if ("name".equals(elementName)) {
                    name = elementContent;
                    continue;
                }
                if (!"url".equals(elementName)) continue;
                url = elementContent;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", type);
            if (name.length() == 0) {
                name = Repos.getDomaninNameFromUrl(url);
            }
            map.put("name", name);
            map.put("url", url);
            sitesList.add(map);
        }
        return sitesList;
    }

    public void putList(List<Map<String, Object>> sitesList) throws IOException {
        File file = PacksStorage.getFileObject((String)REPOS_FILE_NAME);
        if (!file.exists()) {
            file.createNewFile();
        }
        if (file.exists()) {
            PrintWriter writer = new PrintWriter(file, "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<repositories>");
            for (Map<String, Object> site : sitesList) {
                writer.println("  <repository>");
                writer.println("    <type>" + Xml.xmlEscape((String)((String)site.get("type"))) + "</type>");
                writer.println("    <name>" + Xml.xmlEscape((String)((String)site.get("name"))) + "</name>");
                writer.println("    <url>" + Xml.xmlEscape((String)((String)site.get("url"))) + "</url>");
                writer.println("  </repository>");
            }
            writer.println("</repositories>");
            writer.close();
        }
    }

    public static String getDomaninNameFromUrl(String url) {
        String s = url;
        if (s.startsWith("http://")) {
            s = s.substring(7);
        } else if (s.startsWith("file://")) {
            s = s.substring(7);
        }
        int ix = s.indexOf(47);
        if (ix > 0) {
            s = s.substring(0, ix);
        }
        if ((ix = s.lastIndexOf(46)) > 0) {
            s = s.substring(0, ix);
        }
        if ((ix = s.lastIndexOf(46)) > 0) {
            s = s.substring(ix + 1);
        }
        return s;
    }

    public String getFileNamePrefixFromUrl(String url) {
        String s = url;
        if (s.startsWith("http://")) {
            s = s.substring(7);
        } else if (s.startsWith("file:///")) {
            s = s.substring(8);
        }
        s = s.replace('/', '_');
        s = s.replace('?', '_');
        s = s.replace(':', '_');
        s = s.replace('|', '_');
        s = s.replace(' ', '_');
        String[] stringArray = new String[]{"content.xml", "index.idx", "index.xml", ".xml", ".idx"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            int ix = s.lastIndexOf(suffix);
            if (ix > 0) {
                s = s.substring(0, ix);
            }
            ++n2;
        }
        if ((s = s.replace('.', '_')).endsWith("_")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String getRepoContentXmlFromName(String name) {
        for (Map<String, Object> repo : this.fList) {
            if (!name.equals(repo.get("name"))) continue;
            return this.getRepoContentXmlFromUrl((String)repo.get("url"));
        }
        return null;
    }

    public String getRepoContentXmlFromUrl(String url) {
        String fileName = ".cache/.content_" + this.getFileNamePrefixFromUrl(url) + ".xml";
        return fileName;
    }

    public List<PackNode> loadCachedReposContent(Node parent) {
        this.fOut.println("Loading repos summaries...");
        List<Map<String, Object>> reposList = this.getList();
        LinkedList<PackNode> packsVersionsList = new LinkedList<PackNode>();
        for (Map<String, Object> map : reposList) {
            String type = (String)map.get("type");
            String url = (String)map.get("url");
            if (!CMSIS_PACK_TYPE.equals(type) && !XCDL_CMSIS_PACK_TYPE.equals(type)) continue;
            String fileName = this.getRepoContentXmlFromUrl(url);
            try {
                File file = PacksStorage.getFileObject((String)fileName);
                Node node = this.parseContentFile(file);
                if (!node.hasChildren()) continue;
                assert (node.getChildren().size() == 1);
                Leaf repositoryNode = node.getFirstChild();
                map.put("content", repositoryNode);
                this.getVersionsRecursive(repositoryNode, packsVersionsList);
                if (parent == null) continue;
                repositoryNode.moveTo(parent);
            }
            catch (IOException e) {
                this.fOut.println(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                this.fOut.println(e.toString());
            }
            catch (SAXParseException e) {
                String msg = String.valueOf(e.getMessage()) + ", file: " + fileName + ", line: " + e.getLineNumber() + ", column: " + e.getColumnNumber();
                this.fOut.println("Error: " + msg);
            }
            catch (SAXException e) {
                this.fOut.println(e.toString());
            }
        }
        return packsVersionsList;
    }

    private void getVersionsRecursive(Leaf node, List<PackNode> list) {
        if (node.isType("version")) {
            list.add((PackNode)node);
        } else if (node.hasChildren()) {
            for (Leaf child : ((Node)node).getChildren()) {
                this.getVersionsRecursive(child, list);
            }
        }
    }

    private Node parseContentFile(File file) throws IOException, ParserConfigurationException, SAXException {
        long beginTime = System.currentTimeMillis();
        this.fOut.println("Parsing cached content file \"" + file.getCanonicalPath() + "\"...");
        if (!file.exists()) {
            throw new IOException("File does not exist, ignored.");
        }
        Document document = Xml.parseFile((File)file);
        ContentParser parser = new ContentParser();
        Node node = parser.parse(document);
        long endTime = System.currentTimeMillis();
        long duration = endTime - beginTime;
        if (duration == 0L) {
            duration = 1L;
        }
        this.fOut.println("File parsed in " + duration + "ms.");
        return node;
    }
}

