/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.render.peripheral;

import ilg.gnumcueclipse.debug.gdbjtag.render.peripheral.PeripheralEnumerationCellEditor;
import ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralGroupVMNode;
import ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterFieldVMNode;
import ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterVMNode;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class PeripheralEditingSupport
extends EditingSupport {
    private Tree fEditorParent;
    private CellEditor fTextCellEditor;
    private PeripheralEnumerationCellEditor fEnumerationCellEditor;

    public PeripheralEditingSupport(TreeViewer viewer) {
        super((ColumnViewer)viewer);
        this.fEditorParent = viewer.getTree();
        this.fTextCellEditor = new TextCellEditor((Composite)this.fEditorParent);
        this.fEnumerationCellEditor = null;
    }

    protected CellEditor getCellEditor(Object element) {
        PeripheralRegisterVMNode peripheralRegister;
        PeripheralRegisterFieldVMNode peripheralRegisterField;
        if (element instanceof PeripheralGroupVMNode) {
            return null;
        }
        if (element instanceof PeripheralRegisterFieldVMNode && (peripheralRegisterField = (PeripheralRegisterFieldVMNode)element).supportsValueModification()) {
            if (peripheralRegisterField.isEnumeration()) {
                this.fEnumerationCellEditor = new PeripheralEnumerationCellEditor((Composite)this.fEditorParent, peripheralRegisterField);
                return this.fEnumerationCellEditor;
            }
            return this.fTextCellEditor;
        }
        if (element instanceof PeripheralRegisterVMNode && (peripheralRegister = (PeripheralRegisterVMNode)element).supportsValueModification()) {
            return this.fTextCellEditor;
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        PeripheralRegisterVMNode peripheralRegister;
        if (element instanceof PeripheralGroupVMNode) {
            return false;
        }
        return element instanceof PeripheralRegisterVMNode && (peripheralRegister = (PeripheralRegisterVMNode)element).supportsValueModification();
    }

    protected Object getValue(Object element) {
        if (element instanceof PeripheralGroupVMNode) {
            return null;
        }
        if (element instanceof PeripheralRegisterVMNode) {
            PeripheralRegisterVMNode peripheralRegister = (PeripheralRegisterVMNode)element;
            return this.getValueForCellEditor(peripheralRegister);
        }
        return null;
    }

    private Object getValueForCellEditor(PeripheralRegisterVMNode peripheralRegister) {
        PeripheralRegisterFieldVMNode field;
        String value = peripheralRegister.getValueString();
        if (peripheralRegister instanceof PeripheralRegisterFieldVMNode && (field = (PeripheralRegisterFieldVMNode)peripheralRegister).isEnumeration()) {
            Integer index = field.getEnumerationComboIndex();
            if (index != null) {
                return index;
            }
            return new Integer(0);
        }
        return value;
    }

    protected void setValue(Object element, Object value) {
        boolean doNeedRefresh = false;
        if (element instanceof PeripheralRegisterFieldVMNode) {
            PeripheralRegisterFieldVMNode peripheralRegisterField = (PeripheralRegisterFieldVMNode)element;
            if (value instanceof String) {
                doNeedRefresh = peripheralRegisterField.setNumericValue((String)value);
            } else if (value instanceof Integer) {
                Control control = this.fEnumerationCellEditor.getControl();
                String str = ((CCombo)control).getText();
                if ((Integer)value != -1 || str.indexOf(":") >= 0) {
                    String[] as = str.split(":");
                    str = as[0];
                }
                doNeedRefresh = peripheralRegisterField.setNumericValue(str);
            }
        } else if (element instanceof PeripheralRegisterVMNode) {
            PeripheralRegisterVMNode peripheralRegister = (PeripheralRegisterVMNode)element;
            doNeedRefresh = peripheralRegister.setNumericValue((String)value);
        }
        if (doNeedRefresh) {
            this.getViewer().refresh();
        } else {
            this.getViewer().update(element, null);
        }
        this.getViewer().setSelection(null);
    }
}

