/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.pyocd;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.core.StringUtils;
import ilg.gnumcueclipse.debug.gdbjtag.DebugUtils;
import ilg.gnumcueclipse.debug.gdbjtag.pyocd.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.pyocd.DynamicVariableResolver;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;

public class Configuration {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getGdbServerCommand(ILaunchConfiguration configuration, String executable) {
        block3: {
            try {
                if (executable != null) return Configuration.resolveAll(executable, configuration);
                if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", true)) break block3;
                return null;
            }
            catch (CoreException e) {
                Activator.log((Throwable)e);
                return null;
            }
        }
        executable = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerExecutable", "${pyocd_path}/${pyocd_executable}");
        return Configuration.resolveAll(executable, configuration);
    }

    public static String getGdbServerCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbServerCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String[] getGdbServerCommandLineArray(ILaunchConfiguration configuration) {
        String executable;
        ArrayList<String> lst;
        block18: {
            block17: {
                lst = new ArrayList<String>();
                try {
                    if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", true)) break block17;
                    return null;
                }
                catch (CoreException e) {
                    Activator.log((Throwable)e);
                    return null;
                }
            }
            executable = Configuration.getGdbServerCommand(configuration, null);
            if (executable != null && executable.length() != 0) break block18;
            return null;
        }
        lst.add(executable);
        lst.add("--port");
        lst.add(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerGdbPortNumber", 3333)));
        lst.add("--telnet-port");
        lst.add(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTelnetPortNumber", 4444)));
        String boardId = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBoardId", "");
        if (!boardId.isEmpty()) {
            lst.add("--board");
            lst.add(boardId);
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOverrideTarget", false)) {
            lst.add("--target");
            lst.add(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTargetName", ""));
        }
        lst.add("--frequency");
        lst.add(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBusSpeed", 1000000)));
        if (!configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerHaltAtHardFault", true)) {
            lst.add("--nobreak");
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerStepIntoInterrutps", false)) {
            lst.add("--step-int");
        }
        int flashMode = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashMode", 0);
        switch (flashMode) {
            case 0: {
                break;
            }
            case 1: {
                lst.add("--chip_erase");
                break;
            }
            case 2: {
                lst.add("--sector_erase");
            }
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashFastVerify", false)) {
            lst.add("--fast_program");
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerEnableSemihosting", true)) {
            lst.add("--semihosting");
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerUseGdbSyscalls", false)) {
            lst.add("--gdb-syscall");
        }
        String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOther", "").trim();
        if (!(other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes())).isEmpty()) {
            lst.addAll(StringUtils.splitCommandLineOptions((String)other));
        }
        lst.add("-c");
        lst.add("echo \"Started by GNU MCU Eclipse\"");
        return lst.toArray(new String[0]);
    }

    public static String getGdbServerCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbServerCommand(config, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String getGdbServerOtherConfig(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOther", "").trim();
    }

    public static String getGdbClientCommand(ILaunchConfiguration configuration, String executable) {
        try {
            if (executable == null) {
                String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
                executable = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            }
            executable = DebugUtils.resolveAll((String)executable, (Map)configuration.getAttributes());
            executable = Configuration.resolveAll(executable, configuration);
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return null;
        }
        return executable;
    }

    public static String[] getGdbClientCommandLineArray(ILaunchConfiguration configuration) {
        ArrayList<String> lst = new ArrayList<String>();
        String executable = Configuration.getGdbClientCommand(configuration, null);
        if (executable == null || executable.length() == 0) {
            return null;
        }
        lst.add(executable);
        lst.add("--interpreter=mi2");
        lst.add("--nx");
        try {
            String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherOptions", "").trim();
            other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes());
            if (!other.isEmpty()) {
                lst.addAll(StringUtils.splitCommandLineOptions((String)other));
            }
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbClientCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbClientCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String getGdbClientCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbClientCommand(config, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String resolveAll(String str, ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String value = str;
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        if (value.indexOf("${") >= 0 && (project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)configuration)) != null) {
            value = DynamicVariableResolver.resolveAll(value, project);
        }
        if (value.indexOf("${") >= 0) {
            value = DebugUtils.resolveAll((String)value, (Map)configuration.getAttributes());
            ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
            if (buildConfig != null) {
                value = DebugUtils.resolveAll((String)value, (ICConfigurationDescription)buildConfig);
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.resolveAll(\"" + str + "\") = \"" + value + "\"");
        }
        return value;
    }

    public static boolean getDoStartGdbServer(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", true);
    }

    public static boolean getDoAddServerConsole(ILaunchConfiguration config) throws CoreException {
        return Configuration.getDoStartGdbServer(config) && config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateConsole", true);
    }

    public static boolean getDoAddSemihostingConsole(ILaunchConfiguration config) throws CoreException {
        return Configuration.getDoStartGdbServer(config) && config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateSemihostingConsole", true);
    }
}

