/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.qemu.ui;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.debug.gdbjtag.data.CProjectAttributes;
import ilg.gnumcueclipse.debug.gdbjtag.qemu.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.qemu.Configuration;
import ilg.gnumcueclipse.debug.gdbjtag.qemu.preferences.DefaultPreferences;
import ilg.gnumcueclipse.debug.gdbjtag.qemu.preferences.PersistentPreferences;
import ilg.gnumcueclipse.debug.gdbjtag.qemu.ui.Messages;
import ilg.gnumcueclipse.debug.gdbjtag.qemu.ui.TabStartup;
import java.io.File;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TabDebugger
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "ilg.gnumcueclipse.debug.gdbjtag.qemu.ui.debuggertab";
    private ILaunchConfiguration fConfiguration;
    private Text fGdbClientPathLabel;
    private Text fGdbClientExecutable;
    private Text fGdbClientOtherOptions;
    private Text fGdbClientOtherCommands;
    private Button fDoStartGdbServer;
    private Text fGdbServerPathLabel;
    private Link fLink;
    private Button fEnableSemihosting;
    private Text fSemihostingCmdline;
    private Button fDisableGraphics;
    private Text fTargetIpAddress;
    private Text fTargetPortNumber;
    private Text fQemuBoardName;
    private Text fQemuDeviceName;
    private Button fIsQemuVerbose;
    private Text fGdbServerGdbPort;
    private Text fGdbServerExecutable;
    private Button fGdbServerBrowseButton;
    private Button fGdbServerVariablesButton;
    private Text fGdbServerOtherOptions;
    private Button fDoGdbServerAllocateConsole;
    protected Button fUpdateThreadlistOnSuspend;
    protected String fSavedCmsisDeviceName = null;
    protected String fSavedCmsisBoardName = null;
    protected String fProjectName;
    private DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
    private PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();

    protected TabDebugger(TabStartup tabStartup) {
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    public void createControl(Composite parent) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.createControl() ");
        }
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createGdbServerGroup(comp);
        this.createGdbClientControls(comp);
        this.createRemoteControl(comp);
        this.fUpdateThreadlistOnSuspend = new Button(comp, 32);
        this.fUpdateThreadlistOnSuspend.setText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_Text"));
        this.fUpdateThreadlistOnSuspend.setToolTipText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_ToolTipText"));
        Link restoreDefaults = new Link(comp, 0);
        restoreDefaults.setText(Messages.getString("DebuggerTab.restoreDefaults_Link"));
        restoreDefaults.setToolTipText(Messages.getString("DebuggerTab.restoreDefaults_ToolTipText"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        restoreDefaults.setLayoutData((Object)gd);
        this.fUpdateThreadlistOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
        restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabDebugger.this.initializeFromDefaults();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    private void createOptionsControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.interfaceGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 1;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
    }

    private void createGdbServerGroup(final Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("DebuggerTab.gdbServerGroup_Text"));
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        this.fDoStartGdbServer = new Button(comp, 32);
        this.fDoStartGdbServer.setText(Messages.getString("DebuggerTab.doStartGdbServer_Text"));
        this.fDoStartGdbServer.setToolTipText(Messages.getString("DebuggerTab.doStartGdbServer_ToolTipText"));
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.fDoStartGdbServer.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerExecutable_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerExecutable_ToolTipText"));
        Composite local = new Composite(comp, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 3;
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        local.setLayout((Layout)layout3);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd3);
        this.fGdbServerExecutable = new Text(local, 2052);
        gd3 = new GridData(768);
        this.fGdbServerExecutable.setLayoutData((Object)gd3);
        this.fGdbServerBrowseButton = new Button(local, 0);
        this.fGdbServerBrowseButton.setText(Messages.getString("DebuggerTab.gdbServerExecutableBrowse"));
        this.fGdbServerVariablesButton = new Button(local, 0);
        this.fGdbServerVariablesButton.setText(Messages.getString("DebuggerTab.gdbServerExecutableVariable"));
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerActualPath_Label"));
        this.fGdbServerPathLabel = new Text(comp, 2052);
        gd2 = new GridData(4, 0, true, false);
        gd2.horizontalSpan = 4;
        this.fGdbServerPathLabel.setLayoutData((Object)gd2);
        this.fGdbServerPathLabel.setEnabled(true);
        this.fGdbServerPathLabel.setEditable(false);
        label = new Label(comp, 0);
        label.setText("");
        this.fLink = new Link(comp, 0);
        this.fLink.setText(Messages.getString("DebuggerTab.gdbServerActualPath_link"));
        gd2 = new GridData();
        gd2.horizontalSpan = 4;
        this.fLink.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerBoard_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerBoard_ToolTipText"));
        this.fQemuBoardName = new Text(comp, 2052);
        this.fQemuBoardName.setToolTipText(Messages.getString("DebuggerTab.gdbServerBoard_ToolTipText"));
        gd2 = new GridData();
        gd2.widthHint = 200;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fQemuBoardName.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerDevice_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerDevice_ToolTipText"));
        this.fQemuDeviceName = new Text(comp, 2052);
        this.fQemuDeviceName.setToolTipText(Messages.getString("DebuggerTab.gdbServerDevice_ToolTipText"));
        gd2 = new GridData();
        gd2.widthHint = 200;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fQemuDeviceName.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerGdbPort_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerGdbPort_ToolTipText"));
        this.fGdbServerGdbPort = new Text(comp, 2052);
        this.fGdbServerGdbPort.setToolTipText(Messages.getString("DebuggerTab.gdbServerGdbPort_ToolTipText"));
        gd2 = new GridData();
        gd2.widthHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerGdbPort.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerOther_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerOther_ToolTipText"));
        gd2 = new GridData();
        gd2.verticalAlignment = 128;
        label.setLayoutData((Object)gd2);
        this.fGdbServerOtherOptions = new Text(comp, 2626);
        this.fGdbServerOtherOptions.setToolTipText(Messages.getString("DebuggerTab.gdbServerOther_ToolTipText"));
        gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerOtherOptions.setLayoutData((Object)gd2);
        Composite local2 = new Composite(comp, 0);
        GridLayout layout4 = new GridLayout();
        layout4.numColumns = 2;
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        layout4.makeColumnsEqualWidth = true;
        local2.setLayout((Layout)layout4);
        GridData gd4 = new GridData(768);
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        local2.setLayoutData((Object)gd4);
        this.fEnableSemihosting = new Button(local2, 32);
        this.fEnableSemihosting.setText(Messages.getString("DebuggerTab.enableSemihosting_Text"));
        this.fEnableSemihosting.setToolTipText(Messages.getString("DebuggerTab.enableSemihosting_ToolTipText"));
        gd4 = new GridData(768);
        this.fEnableSemihosting.setLayoutData((Object)gd4);
        this.fDisableGraphics = new Button(local2, 32);
        this.fDisableGraphics.setText(Messages.getString("DebuggerTab.disableGraphics_Text"));
        this.fDisableGraphics.setToolTipText(Messages.getString("DebuggerTab.disableGraphics_ToolTipText"));
        gd4 = new GridData(768);
        this.fDisableGraphics.setLayoutData((Object)gd4);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbSemihostingCmdline_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbSemihostingCmdline_ToolTipText"));
        gd2 = new GridData();
        gd2.verticalAlignment = 128;
        label.setLayoutData((Object)gd2);
        this.fSemihostingCmdline = new Text(comp, 2052);
        this.fSemihostingCmdline.setToolTipText(Messages.getString("DebuggerTab.gdbSemihostingCmdline_ToolTipText"));
        gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fSemihostingCmdline.setLayoutData((Object)gd2);
        local2 = new Composite(comp, 0);
        layout4 = new GridLayout();
        layout4.numColumns = 2;
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        layout4.makeColumnsEqualWidth = true;
        local2.setLayout((Layout)layout4);
        gd4 = new GridData(768);
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        local2.setLayoutData((Object)gd4);
        this.fDoGdbServerAllocateConsole = new Button(local2, 32);
        this.fDoGdbServerAllocateConsole.setText(Messages.getString("DebuggerTab.gdbServerAllocateConsole_Label"));
        this.fDoGdbServerAllocateConsole.setToolTipText(Messages.getString("DebuggerTab.gdbServerAllocateConsole_ToolTipText"));
        gd4 = new GridData(768);
        this.fDoGdbServerAllocateConsole.setLayoutData((Object)gd4);
        this.fIsQemuVerbose = new Button(local2, 32);
        this.fIsQemuVerbose.setText(Messages.getString("DebuggerTab.gdbServerVerbose_Label"));
        this.fIsQemuVerbose.setToolTipText(Messages.getString("DebuggerTab.gdbServerVerbose_ToolTipText"));
        gd4 = new GridData(768);
        this.fIsQemuVerbose.setLayoutData((Object)gd4);
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        SelectionAdapter scheduleUpdateJobSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        this.fDoStartGdbServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.doStartGdbServerChanged();
                if (TabDebugger.this.fDoStartGdbServer.getSelection()) {
                    TabDebugger.this.fTargetIpAddress.setText("localhost");
                }
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fEnableSemihosting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.doEnableSemihostingChanged();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fDisableGraphics.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
                TabDebugger.this.updateGdbServerActualPath();
            }
        });
        this.fGdbServerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbServerExecutableBrowse_Title"), TabDebugger.this.fGdbServerExecutable);
            }
        });
        this.fGdbServerVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbServerExecutable);
            }
        });
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = e.text;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(text);
                }
                int ret = -1;
                if ("global".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.globalPreferencePage", null, null).open();
                } else if ("workspace".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.workspacePreferencePage", null, null).open();
                } else if ("project".equals(text)) {
                    if (!$assertionsDisabled && TabDebugger.this.fConfiguration == null) {
                        throw new AssertionError();
                    }
                    IProject project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)TabDebugger.this.fConfiguration);
                    ret = PreferencesUtil.createPropertyDialogOn((Shell)parent.getShell(), (IAdaptable)project, (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.projectPropertiesPage", null, null, (int)0).open();
                }
                if (ret == 0) {
                    TabDebugger.this.updateGdbServerActualPath();
                }
            }
        });
        this.fQemuBoardName.addModifyListener(scheduleUpdateJobModifyListener);
        this.fQemuDeviceName.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerGdbPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.fTargetPortNumber.setText(TabDebugger.this.fGdbServerGdbPort.getText());
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerOtherOptions.addModifyListener(scheduleUpdateJobModifyListener);
        this.fSemihostingCmdline.addModifyListener(scheduleUpdateJobModifyListener);
        this.fDoGdbServerAllocateConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fIsQemuVerbose.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
    }

    private void createGdbClientControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.gdbSetupGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbCommand_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbCommand_ToolTipText"));
        Composite local = new Composite(comp, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 3;
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        local.setLayout((Layout)layout3);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd3);
        this.fGdbClientExecutable = new Text(local, 2052);
        gd3 = new GridData(768);
        this.fGdbClientExecutable.setLayoutData((Object)gd3);
        Button browseButton = new Button(local, 0);
        browseButton.setText(Messages.getString("DebuggerTab.gdbCommandBrowse"));
        Button variableButton = new Button(local, 0);
        variableButton.setText(Messages.getString("DebuggerTab.gdbCommandVariable"));
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbCommandActualPath_Label"));
        this.fGdbClientPathLabel = new Text(comp, 2052);
        GridData gd4 = new GridData(4, 0, true, false);
        gd4.horizontalSpan = 4;
        this.fGdbClientPathLabel.setLayoutData((Object)gd4);
        this.fGdbClientPathLabel.setEnabled(true);
        this.fGdbClientPathLabel.setEditable(false);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbOtherOptions_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbOtherOptions_ToolTipText"));
        gd4 = new GridData();
        label.setLayoutData((Object)gd4);
        this.fGdbClientOtherOptions = new Text(comp, 2052);
        gd4 = new GridData(768);
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientOtherOptions.setLayoutData((Object)gd4);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbOtherCommands_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbOtherCommands_ToolTipText"));
        gd4 = new GridData();
        gd4.verticalAlignment = 128;
        label.setLayoutData((Object)gd4);
        this.fGdbClientOtherCommands = new Text(comp, 2626);
        gd4 = new GridData(4, 4, true, true);
        gd4.heightHint = 60;
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientOtherCommands.setLayoutData((Object)gd4);
        this.fGdbClientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
                TabDebugger.this.updateGdbClientActualPath();
            }
        });
        this.fGdbClientOtherOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbClientOtherCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbCommandBrowse_Title"), TabDebugger.this.fGdbClientExecutable);
            }
        });
        variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbClientExecutable);
            }
        });
    }

    private void createRemoteControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.remoteGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ipAddressLabel"));
        this.fTargetIpAddress = new Text(comp, 2048);
        gd2 = new GridData();
        gd2.widthHint = 125;
        this.fTargetIpAddress.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.portNumberLabel"));
        this.fTargetPortNumber = new Text(comp, 2048);
        gd2 = new GridData();
        gd2.widthHint = 125;
        this.fTargetPortNumber.setLayoutData((Object)gd2);
        this.fTargetIpAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fTargetPortNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        this.fTargetPortNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void updateGdbServerActualPath() {
        assert (this.fConfiguration != null);
        String fullCommand = Configuration.getGdbServerCommand(this.fConfiguration, this.fGdbServerExecutable.getText());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.updateActualpath() \"" + fullCommand + "\"");
        }
        this.fGdbServerPathLabel.setText(fullCommand);
    }

    private void updateGdbClientActualPath() {
        assert (this.fConfiguration != null);
        String fullCommand = Configuration.getGdbClientCommand(this.fConfiguration, this.fGdbClientExecutable.getText());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.updateGdbClientActualPath() \"" + fullCommand + "\"");
        }
        this.fGdbClientPathLabel.setText(fullCommand);
    }

    private void doStartGdbServerChanged() {
        boolean enabled = this.fDoStartGdbServer.getSelection();
        this.fGdbServerExecutable.setEnabled(enabled);
        this.fGdbServerBrowseButton.setEnabled(enabled);
        this.fGdbServerVariablesButton.setEnabled(enabled);
        this.fGdbServerOtherOptions.setEnabled(enabled);
        this.fGdbServerGdbPort.setEnabled(enabled);
        this.fEnableSemihosting.setEnabled(enabled);
        this.fSemihostingCmdline.setEnabled(enabled && this.fEnableSemihosting.getSelection());
        this.fDoGdbServerAllocateConsole.setEnabled(enabled);
        this.fDisableGraphics.setEnabled(enabled);
        this.fQemuBoardName.setEnabled(enabled);
        this.fIsQemuVerbose.setEnabled(enabled);
        this.fTargetIpAddress.setEnabled(!enabled);
        this.fTargetPortNumber.setEnabled(!enabled);
        this.fGdbServerPathLabel.setEnabled(enabled);
        this.fLink.setEnabled(enabled);
    }

    private void doEnableSemihostingChanged() {
        boolean enabled = this.fEnableSemihosting.getSelection();
        this.fSemihostingCmdline.setEnabled(enabled);
    }

    private String getProjectName(ILaunchConfiguration configuration) {
        if (configuration != null) {
            try {
                String str = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
                this.fProjectName = str.replace(' ', '_');
            }
            catch (CoreException coreException) {}
        }
        if (this.fProjectName == null) {
            this.fProjectName = "";
        }
        return this.fProjectName;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.initializeFrom() " + configuration.getName());
        }
        this.fConfiguration = configuration;
        try {
            String deviceName;
            String boardName;
            Boolean booleanDefault = this.fPersistentPreferences.getGdbServerDoStart();
            this.fDoStartGdbServer.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doStartGdbServer", booleanDefault.booleanValue()));
            String stringDefault = this.fPersistentPreferences.getGdbServerExecutable();
            this.fGdbServerExecutable.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerExecutable", stringDefault));
            this.fSavedCmsisBoardName = boardName = CProjectAttributes.getCmsisBoardName((ILaunchConfiguration)configuration);
            this.fSavedCmsisDeviceName = deviceName = CProjectAttributes.getCmsisDeviceName((ILaunchConfiguration)configuration);
            if ((boardName == null || boardName.isEmpty()) && (deviceName == null || deviceName.isEmpty())) {
                boardName = this.fPersistentPreferences.getQemuBoardName();
                deviceName = this.fPersistentPreferences.getQemuDeviceName();
            }
            this.fQemuBoardName.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerBoardName", boardName == null ? "" : boardName));
            this.fQemuDeviceName.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerDeviceName", deviceName == null ? "" : deviceName));
            this.fGdbServerGdbPort.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerGdbPortNumber", 1234)));
            stringDefault = this.fPersistentPreferences.getGdbServerOtherOptions();
            this.fGdbServerOtherOptions.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerOther", stringDefault));
            booleanDefault = this.fPersistentPreferences.getQemuEnableSemihosting();
            this.fEnableSemihosting.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.enableSemihosting", booleanDefault.booleanValue()));
            stringDefault = this.getProjectName(configuration);
            this.fSemihostingCmdline.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.semihosting.cmdline", stringDefault));
            booleanDefault = this.fPersistentPreferences.getQemuDisableGraphics();
            this.fDisableGraphics.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.disableGraphics", booleanDefault.booleanValue()));
            if (EclipseUtils.isWindows()) {
                this.fDoGdbServerAllocateConsole.setSelection(true);
            } else {
                this.fDoGdbServerAllocateConsole.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doGdbServerAllocateConsole", true));
            }
            booleanDefault = this.fPersistentPreferences.getQemuIsVerbose();
            this.fIsQemuVerbose.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.isGdbServerVerbose", booleanDefault.booleanValue()));
            stringDefault = this.fPersistentPreferences.getGdbClientExecutable();
            String gdbCommandAttr = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringDefault);
            this.fGdbClientExecutable.setText(gdbCommandAttr);
            stringDefault = this.fPersistentPreferences.getGdbClientOtherOptions();
            this.fGdbClientOtherOptions.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbClientOtherOptions", stringDefault));
            stringDefault = this.fPersistentPreferences.getGdbClientCommands();
            this.fGdbClientOtherCommands.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbClientOtherCommands", stringDefault));
            this.fTargetIpAddress.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost"));
            int storedPort = 0;
            storedPort = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
            if (storedPort <= 0 || 65535 < storedPort) {
                storedPort = 1234;
            }
            String portString = Integer.toString(storedPort);
            this.fTargetPortNumber.setText(portString);
            this.doStartGdbServerChanged();
            boolean updateThreadsOnSuspend = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
            this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.initializeFrom() completed " + configuration.getName());
        }
    }

    public void initializeFromDefaults() {
        String deviceName;
        String boardName;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.initializeFromDefaults()");
        }
        boolean booleanDefault = this.fDefaultPreferences.getGdbServerDoStart();
        this.fDoStartGdbServer.setSelection(booleanDefault);
        String stringDefault = this.fDefaultPreferences.getGdbServerExecutable();
        this.fGdbServerExecutable.setText(stringDefault);
        if (this.fSavedCmsisBoardName != null || this.fSavedCmsisDeviceName != null) {
            boardName = this.fSavedCmsisBoardName != null ? this.fSavedCmsisBoardName : "";
            deviceName = this.fSavedCmsisDeviceName != null ? this.fSavedCmsisDeviceName : "";
        } else {
            boardName = "?";
            deviceName = "?";
        }
        this.fQemuBoardName.setText(boardName);
        this.fQemuDeviceName.setText(deviceName);
        this.fGdbServerGdbPort.setText(Integer.toString(1234));
        stringDefault = this.fDefaultPreferences.getGdbServerOtherOptions();
        this.fGdbServerOtherOptions.setText(stringDefault);
        booleanDefault = this.fDefaultPreferences.getQemuEnableSemihosting();
        this.fEnableSemihosting.setSelection(booleanDefault);
        this.fSemihostingCmdline.setText(this.getProjectName(null));
        booleanDefault = this.fDefaultPreferences.getQemuDisableGraphics();
        this.fDisableGraphics.setSelection(booleanDefault);
        if (EclipseUtils.isWindows()) {
            this.fDoGdbServerAllocateConsole.setSelection(true);
        } else {
            this.fDoGdbServerAllocateConsole.setSelection(true);
        }
        this.fIsQemuVerbose.setSelection(false);
        stringDefault = this.fDefaultPreferences.getGdbClientExecutable();
        this.fGdbClientExecutable.setText(stringDefault);
        stringDefault = this.fDefaultPreferences.getGdbClientOtherOptions();
        this.fGdbClientOtherOptions.setText(stringDefault);
        stringDefault = this.fDefaultPreferences.getGdbClientCommands();
        this.fGdbClientOtherCommands.setText(stringDefault);
        this.fTargetIpAddress.setText("localhost");
        String portString = Integer.toString(1234);
        this.fTargetPortNumber.setText(portString);
    }

    public String getId() {
        return TAB_ID;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.activated() " + workingCopy.getName());
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.deactivated() " + workingCopy.getName());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.isValid() " + launchConfig.getName());
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean result = true;
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            if (this.fGdbServerExecutable != null && this.fGdbServerExecutable.getText().trim().isEmpty()) {
                this.setErrorMessage("GDB server executable path?");
                result = false;
            }
            if (this.fGdbServerGdbPort != null && this.fGdbServerGdbPort.getText().trim().isEmpty()) {
                this.setErrorMessage("GDB port?");
                result = false;
            }
            if (this.fQemuBoardName != null && this.fQemuBoardName.getText().trim().isEmpty()) {
                this.setErrorMessage("Board name?");
                result = false;
            }
        }
        if (this.fGdbClientExecutable != null && this.fGdbClientExecutable.getText().trim().isEmpty()) {
            this.setErrorMessage("GDB client executable name?");
            result = false;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.isValid() " + launchConfig.getName() + " = " + result);
        }
        return result;
    }

    public boolean canSave() {
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            if (this.fGdbServerExecutable != null && this.fGdbServerExecutable.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fQemuBoardName != null && this.fQemuBoardName.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerGdbPort != null && this.fGdbServerGdbPort.getText().trim().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.performApply() " + configuration.getName());
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU QEMU");
        boolean booleanValue = this.fDoStartGdbServer.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doStartGdbServer", booleanValue);
        this.fPersistentPreferences.putGdbServerDoStart(booleanValue);
        String stringValue = this.fGdbServerExecutable.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerExecutable", stringValue);
        this.fPersistentPreferences.putGdbServerExecutable(stringValue);
        if (!this.fGdbServerGdbPort.getText().trim().isEmpty()) {
            int port = Integer.parseInt(this.fGdbServerGdbPort.getText().trim());
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerGdbPortNumber", port);
        } else {
            Activator.log((String)"empty fGdbServerGdbPort");
        }
        stringValue = this.fQemuBoardName.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerBoardName", stringValue);
        this.fPersistentPreferences.putQemuBoardName(stringValue);
        stringValue = this.fQemuDeviceName.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerDeviceName", stringValue);
        this.fPersistentPreferences.putQemuDeviceName(stringValue);
        stringValue = this.fGdbServerOtherOptions.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerOther", stringValue);
        this.fPersistentPreferences.putGdbServerOtherOptions(stringValue);
        booleanValue = this.fEnableSemihosting.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.enableSemihosting", booleanValue);
        this.fPersistentPreferences.putQemuEnableSemihosting(booleanValue);
        stringValue = this.fSemihostingCmdline.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.semihosting.cmdline", stringValue);
        booleanValue = this.fDisableGraphics.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.disableGraphics", booleanValue);
        this.fPersistentPreferences.putQemuDisableGraphics(booleanValue);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doGdbServerAllocateConsole", this.fDoGdbServerAllocateConsole.getSelection());
        booleanValue = this.fIsQemuVerbose.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.isGdbServerVerbose", booleanValue);
        this.fPersistentPreferences.putQemuIsVerbose(booleanValue);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        stringValue = this.fGdbClientExecutable.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringValue);
        this.fPersistentPreferences.putGdbClientExecutable(stringValue);
        stringValue = this.fGdbClientOtherOptions.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbClientOtherOptions", stringValue);
        this.fPersistentPreferences.putGdbClientOtherOptions(stringValue);
        stringValue = this.fGdbClientOtherCommands.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbClientOtherCommands", stringValue);
        this.fPersistentPreferences.putGdbClientCommands(stringValue);
        if (this.fDoStartGdbServer.getSelection()) {
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost");
            String str = this.fGdbServerGdbPort.getText().trim();
            if (!str.isEmpty()) {
                try {
                    int port = Integer.parseInt(str);
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port);
                }
                catch (NumberFormatException e) {
                    Activator.log((Throwable)e);
                }
            }
        } else {
            String ip = this.fTargetIpAddress.getText().trim();
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", ip);
            String str = this.fTargetPortNumber.getText().trim();
            if (!str.isEmpty()) {
                try {
                    int port = Integer.valueOf(str);
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port);
                }
                catch (NumberFormatException e) {
                    Activator.log((Throwable)e);
                }
            }
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        this.fPersistentPreferences.flush();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.performApply() completed " + configuration.getName() + ", dirty=" + this.isDirty());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabDebugger.setDefaults() " + configuration.getName());
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU QEMU");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        boolean defaultBoolean = this.fPersistentPreferences.getGdbServerDoStart();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doStartGdbServer", defaultBoolean);
        String defaultString = this.fPersistentPreferences.getGdbServerExecutable();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerExecutable", defaultString);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerGdbPortNumber", 1234);
        String boardName = CProjectAttributes.getCmsisBoardName((ILaunchConfiguration)configuration);
        String deviceName = CProjectAttributes.getCmsisDeviceName((ILaunchConfiguration)configuration);
        if ((boardName == null || boardName.isEmpty()) && (deviceName == null || deviceName.isEmpty())) {
            boardName = this.fPersistentPreferences.getQemuBoardName();
            deviceName = this.fPersistentPreferences.getQemuDeviceName();
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerBoardName", boardName == null ? "" : boardName);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerDeviceName", deviceName == null ? "" : deviceName);
        defaultString = this.fPersistentPreferences.getGdbServerOtherOptions();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerOther", defaultString);
        defaultBoolean = this.fPersistentPreferences.getQemuEnableSemihosting();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.enableSemihosting", defaultBoolean);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.semihosting.cmdline", this.getProjectName((ILaunchConfiguration)configuration));
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doGdbServerAllocateConsole", true);
        defaultBoolean = this.fPersistentPreferences.getQemuIsVerbose();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.isGdbServerVerbose", defaultBoolean);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.fPersistentPreferences.getGdbClientExecutable());
        defaultString = this.fPersistentPreferences.getGdbClientOtherOptions();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbClientOtherOptions", this.fDefaultPreferences.getGdbClientOtherOptions());
        defaultString = this.fPersistentPreferences.getGdbClientCommands();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbClientOtherCommands", defaultString);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 1234);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }
}

