/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.jlink;

import ilg.gnumcueclipse.debug.gdbjtag.jlink.Activator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class SemihostingProcess
extends Process
implements Runnable {
    boolean fRunning;
    Thread fThread = null;
    Socket fSocket;
    protected static final int BUFFER_SIZE = 2048;
    protected byte[] fRawBytes = new byte[2048];
    protected InputStream fInputStream;
    protected OutputStream fOutputStream;
    protected InputStream fErrorStream;
    protected PipedInputStream fPipeIn;
    protected PipedOutputStream fPipeOut;
    private String fHost;
    private int fPort;

    public SemihostingProcess(String host, int port) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.SemihostingProcess(" + host + "," + port + ") " + this);
        }
        this.fHost = host;
        this.fPort = port;
        this.fRunning = false;
        this.fInputStream = new NullInputStream();
        this.fErrorStream = new NullInputStream();
        this.fOutputStream = new NullOutputStream();
        this.fPipeOut = new PipedOutputStream();
        try {
            this.fPipeIn = new PipedInputStream(this.fPipeOut);
        }
        catch (IOException e) {
            Activator.log((Throwable)e);
        }
    }

    @Override
    public void destroy() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.SemihostingProcess.destroy() " + Thread.currentThread() + " " + this.fThread);
        }
        if (this.fRunning) {
            if (this.fThread != null && this.fThread != Thread.currentThread()) {
                this.fThread.interrupt();
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("jlink.SemihostingProcess.destroy() after interrupt");
                }
            }
            try {
                if (this.fSocket != null && !this.fSocket.isClosed()) {
                    if (this.fSocket != null && !this.fSocket.isInputShutdown()) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("jlink.SemihostingProcess.destroy() before shutdownInput");
                        }
                        this.fSocket.shutdownInput();
                    }
                    if (this.fSocket != null && !this.fSocket.isOutputShutdown()) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("jlink.SemihostingProcess.destroy() before shutdownOutput");
                        }
                        this.fSocket.shutdownOutput();
                    }
                }
            }
            catch (IOException iOException) {}
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.SemihostingProcess.destroy() return");
        }
    }

    @Override
    public int exitValue() {
        if (this.fRunning) {
            throw new IllegalThreadStateException();
        }
        return 0;
    }

    @Override
    public InputStream getErrorStream() {
        return this.fErrorStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.fPipeIn;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    @Override
    public int waitFor() throws InterruptedException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.SemihostingProcess.waitFor() " + Thread.currentThread() + " will wait for " + this.fThread);
        }
        this.fThread.join();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.SemihostingProcess.waitFor() return " + Thread.currentThread());
        }
        return 0;
    }

    @Override
    public void run() {
        block46: {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingProcess.run() " + Thread.currentThread());
            }
            this.fRunning = true;
            int nTimeout = 10000;
            int i = 50;
            while (i > 0) {
                InetSocketAddress address = new InetSocketAddress(this.fHost, this.fPort);
                this.fSocket = new Socket();
                try {
                    this.fSocket.connect(address, nTimeout);
                    break;
                }
                catch (IOException iOException) {
                    --i;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (i != 0) continue;
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("jlink.SemihostingProcess.run() cannot connect, no way to go further.");
                    }
                    return;
                }
            }
            this.fRunning = true;
            try {
                try {
                    this.fInputStream = this.fSocket.getInputStream();
                    this.fOutputStream = this.fSocket.getOutputStream();
                    this.fSocket.setKeepAlive(true);
                    while (this.fSocket.isConnected() & this.fRunning) {
                        int nRawBytes;
                        try {
                            nRawBytes = this.fInputStream.read(this.fRawBytes);
                        }
                        catch (SocketException socketException) {
                            nRawBytes = -1;
                        }
                        if (nRawBytes == -1) {
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("jlink.SemihostingProcess.run() Connection closed by the GDB server.");
                            }
                            this.fPipeOut.write("Connection closed by the GDB server.".getBytes());
                            break;
                        }
                        if (nRawBytes <= 0) continue;
                        this.fPipeOut.write(this.fRawBytes, 0, nRawBytes);
                    }
                }
                catch (IOException e) {
                    Activator.log((Throwable)e);
                    try {
                        this.fPipeOut.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.fErrorStream.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.fSocket.close();
                        this.fSocket = null;
                    }
                    catch (IOException iOException) {}
                    try {
                        this.fInputStream.close();
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (IOException iOException) {}
                    this.fRunning = false;
                    break block46;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.fPipeOut.close();
                }
                catch (IOException iOException) {}
                try {
                    this.fErrorStream.close();
                }
                catch (IOException iOException) {}
                try {
                    this.fSocket.close();
                    this.fSocket = null;
                }
                catch (IOException iOException) {}
                try {
                    this.fInputStream.close();
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {}
                this.fRunning = false;
                throw throwable;
            }
            try {
                this.fPipeOut.close();
            }
            catch (IOException iOException) {}
            try {
                this.fErrorStream.close();
            }
            catch (IOException iOException) {}
            try {
                this.fSocket.close();
                this.fSocket = null;
            }
            catch (IOException iOException) {}
            try {
                this.fInputStream.close();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {}
            this.fRunning = false;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.SemihostingProcess.run() completed ");
        }
    }

    public void submit() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.SemihostingProcess.submit() " + Thread.currentThread());
        }
        this.fThread = new Thread(this);
        this.fThread.setName("Semihosting and SWV fake process");
        this.fThread.setDaemon(true);
        this.fThread.setPriority(1);
        this.fThread.start();
    }

    protected class NullInputStream
    extends InputStream {
        private boolean fIsOpened = true;
        private Thread fThread = null;

        protected NullInputStream() {
        }

        @Override
        public int read() throws IOException {
            block3: {
                if (!this.fIsOpened) {
                    return -1;
                }
                try {
                    this.fThread = Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    if (!Activator.getInstance().isDebugging()) break block3;
                    System.out.println("jlink.SemihostingProcess.NullInputStream.read() interrupted");
                }
            }
            return 0;
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() throws IOException {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("jlink.SemihostingProcess.NullInputStream.close() " + Thread.currentThread());
            }
            if (this.fIsOpened) {
                super.close();
                this.fIsOpened = false;
                if (this.fThread != null) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("jlink.SemihostingProcess.NullInputStream.close() interrupt " + Thread.currentThread() + " " + this.fThread);
                    }
                    this.fThread.interrupt();
                }
            }
        }
    }

    protected class NullOutputStream
    extends OutputStream {
        protected NullOutputStream() {
        }

        @Override
        public void write(int arg) throws IOException {
        }
    }
}

