/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.render.peripheral;

import ilg.gnumcueclipse.debug.gdbjtag.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterFieldVMNode;
import ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralTreeVMNode;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class PeripheralViewerComparator
extends ViewerComparator {
    private int fColumnIndex = 1;
    private static final int DESCENDING = 1;
    private static final int ASCENDING = 0;
    private int fDirection = 0;

    public int getDirection() {
        return this.fDirection == 1 ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Column " + column);
        }
        if (column == this.fColumnIndex) {
            this.fDirection = 1 - this.fDirection;
        } else {
            this.fColumnIndex = column;
            this.fDirection = 0;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        PeripheralTreeVMNode p1 = (PeripheralTreeVMNode)e1;
        PeripheralTreeVMNode p2 = (PeripheralTreeVMNode)e2;
        int comparison = 0;
        switch (this.fColumnIndex) {
            case 0: {
                try {
                    comparison = p1.getName().compareTo(p2.getName());
                }
                catch (DebugException debugException) {}
                break;
            }
            case 1: {
                if (e1 instanceof PeripheralRegisterFieldVMNode && e2 instanceof PeripheralRegisterFieldVMNode) {
                    comparison = ((PeripheralRegisterFieldVMNode)e1).getOffsetBits() - ((PeripheralRegisterFieldVMNode)e2).getOffsetBits();
                    break;
                }
                comparison = p1.getDisplayAddress().compareTo(p2.getDisplayAddress());
                break;
            }
            default: {
                comparison = 0;
            }
        }
        if (this.fDirection == 1) {
            comparison = -comparison;
        }
        return comparison;
    }
}

