/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.openocd.ui;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.debug.gdbjtag.openocd.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.openocd.Configuration;
import ilg.gnumcueclipse.debug.gdbjtag.openocd.preferences.DefaultPreferences;
import ilg.gnumcueclipse.debug.gdbjtag.openocd.preferences.PersistentPreferences;
import ilg.gnumcueclipse.debug.gdbjtag.openocd.ui.Messages;
import ilg.gnumcueclipse.debug.gdbjtag.openocd.ui.TabStartup;
import java.io.File;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TabDebugger
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "ilg.gnumcueclipse.debug.gdbjtag.openocd.ui.debuggertab";
    private ILaunchConfiguration fConfiguration;
    private Button fDoStartGdbServer;
    private Text fGdbServerGdbPort;
    private Text fGdbServerTelnetPort;
    private Text fGdbServerTclPort;
    private Text fGdbServerExecutable;
    private Button fGdbServerBrowseButton;
    private Button fGdbServerVariablesButton;
    private Text fGdbServerPathLabel;
    private Text fGdbServerOtherOptions;
    private Button fDoGdbServerAllocateConsole;
    private Button fDoGdbServerAllocateTelnetConsole;
    private Button fDoStartGdbClient;
    private Text fGdbClientExecutable;
    private Button fGdbClientBrowseButton;
    private Button fGdbClientVariablesButton;
    private Text fGdbClientPathLabel;
    private Text fGdbClientOtherOptions;
    private Text fGdbClientOtherCommands;
    private Link fLink;
    private Text fTargetIpAddress;
    private Text fTargetPortNumber;
    protected Button fUpdateThreadlistOnSuspend;
    private DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
    private PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();

    protected TabDebugger(TabStartup tabStartup) {
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    public void createControl(Composite parent) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.createControl() ");
        }
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createGdbServerGroup(comp);
        this.createGdbClientControls(comp);
        this.createRemoteControl(comp);
        this.fUpdateThreadlistOnSuspend = new Button(comp, 32);
        this.fUpdateThreadlistOnSuspend.setText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_Text"));
        this.fUpdateThreadlistOnSuspend.setToolTipText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_ToolTipText"));
        Link restoreDefaults = new Link(comp, 0);
        restoreDefaults.setText(Messages.getString("DebuggerTab.restoreDefaults_Link"));
        restoreDefaults.setToolTipText(Messages.getString("DebuggerTab.restoreDefaults_ToolTipText"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        restoreDefaults.setLayoutData((Object)gd);
        this.fUpdateThreadlistOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
        restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabDebugger.this.initializeFromDefaults();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    private void createGdbServerGroup(final Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("DebuggerTab.gdbServerGroup_Text"));
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        this.fDoStartGdbServer = new Button(comp, 32);
        this.fDoStartGdbServer.setText(Messages.getString("DebuggerTab.doStartGdbServer_Text"));
        this.fDoStartGdbServer.setToolTipText(Messages.getString("DebuggerTab.doStartGdbServer_ToolTipText"));
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.fDoStartGdbServer.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerExecutable_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerExecutable_ToolTipText"));
        Composite local = new Composite(comp, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 3;
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        local.setLayout((Layout)layout3);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd3);
        this.fGdbServerExecutable = new Text(local, 2052);
        gd3 = new GridData(768);
        this.fGdbServerExecutable.setLayoutData((Object)gd3);
        this.fGdbServerBrowseButton = new Button(local, 0);
        this.fGdbServerBrowseButton.setText(Messages.getString("DebuggerTab.gdbServerExecutableBrowse"));
        this.fGdbServerVariablesButton = new Button(local, 0);
        this.fGdbServerVariablesButton.setText(Messages.getString("DebuggerTab.gdbServerExecutableVariable"));
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerActualPath_Label"));
        this.fGdbServerPathLabel = new Text(comp, 2052);
        gd2 = new GridData(4, 0, true, false);
        gd2.horizontalSpan = 4;
        this.fGdbServerPathLabel.setLayoutData((Object)gd2);
        this.fGdbServerPathLabel.setEnabled(true);
        this.fGdbServerPathLabel.setEditable(false);
        label = new Label(comp, 0);
        label.setText("");
        this.fLink = new Link(comp, 0);
        this.fLink.setText(Messages.getString("DebuggerTab.gdbServerActualPath_link"));
        gd2 = new GridData();
        gd2.horizontalSpan = 4;
        this.fLink.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerGdbPort_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerGdbPort_ToolTipText"));
        this.fGdbServerGdbPort = new Text(comp, 2052);
        gd2 = new GridData();
        gd2.widthHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerGdbPort.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerTelnetPort_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerTelnetPort_ToolTipText"));
        this.fGdbServerTelnetPort = new Text(comp, 2052);
        gd2 = new GridData();
        gd2.widthHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerTelnetPort.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerTclPort_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerTclPort_ToolTipText"));
        this.fGdbServerTclPort = new Text(comp, 2052);
        gd2 = new GridData();
        gd2.widthHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerTclPort.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerOther_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerOther_ToolTipText"));
        gd2 = new GridData();
        gd2.verticalAlignment = 128;
        label.setLayoutData((Object)gd2);
        this.fGdbServerOtherOptions = new Text(comp, 2626);
        gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerOtherOptions.setLayoutData((Object)gd2);
        Composite local2 = new Composite(comp, 0);
        GridLayout layout4 = new GridLayout();
        layout4.numColumns = 2;
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        layout4.makeColumnsEqualWidth = true;
        local2.setLayout((Layout)layout4);
        GridData gd4 = new GridData(768);
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        local2.setLayoutData((Object)gd4);
        this.fDoGdbServerAllocateConsole = new Button(local2, 32);
        this.fDoGdbServerAllocateConsole.setText(Messages.getString("DebuggerTab.gdbServerAllocateConsole_Label"));
        this.fDoGdbServerAllocateConsole.setToolTipText(Messages.getString("DebuggerTab.gdbServerAllocateConsole_ToolTipText"));
        gd4 = new GridData(768);
        this.fDoGdbServerAllocateConsole.setLayoutData((Object)gd4);
        this.fDoGdbServerAllocateTelnetConsole = new Button(local2, 32);
        this.fDoGdbServerAllocateTelnetConsole.setText(Messages.getString("DebuggerTab.gdbServerAllocateTelnetConsole_Label"));
        this.fDoGdbServerAllocateTelnetConsole.setToolTipText(Messages.getString("DebuggerTab.gdbServerAllocateTelnetConsole_ToolTipText"));
        gd4 = new GridData(768);
        this.fDoGdbServerAllocateTelnetConsole.setLayoutData((Object)gd4);
        this.fDoGdbServerAllocateTelnetConsole.setEnabled(false);
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        SelectionAdapter scheduleUpdateJobSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        this.fDoStartGdbServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.doStartGdbServerChanged();
                if (TabDebugger.this.fDoStartGdbServer.getSelection()) {
                    TabDebugger.this.fTargetIpAddress.setText("localhost");
                }
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
                TabDebugger.this.updateGdbServerActualPath();
            }
        });
        this.fGdbServerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbServerExecutableBrowse_Title"), TabDebugger.this.fGdbServerExecutable);
            }
        });
        this.fGdbServerVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbServerExecutable);
            }
        });
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = e.text;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(text);
                }
                int ret = -1;
                if ("global".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"ilg.gnumcueclipse.debug.gdbjtag.openocd.globalPreferencePage", null, null).open();
                } else if ("workspace".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"ilg.gnumcueclipse.debug.gdbjtag.openocd.workspacePreferencePage", null, null).open();
                } else if ("project".equals(text)) {
                    if (!$assertionsDisabled && TabDebugger.this.fConfiguration == null) {
                        throw new AssertionError();
                    }
                    IProject project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)TabDebugger.this.fConfiguration);
                    ret = PreferencesUtil.createPropertyDialogOn((Shell)parent.getShell(), (IAdaptable)project, (String)"ilg.gnumcueclipse.debug.gdbjtag.openocd.projectPropertiesPage", null, null, (int)0).open();
                }
                if (ret == 0) {
                    TabDebugger.this.updateGdbServerActualPath();
                }
            }
        });
        this.fGdbServerGdbPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.fTargetPortNumber.setText(TabDebugger.this.fGdbServerGdbPort.getText());
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerTelnetPort.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerTclPort.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerOtherOptions.addModifyListener(scheduleUpdateJobModifyListener);
        this.fDoGdbServerAllocateConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fDoGdbServerAllocateTelnetConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
    }

    private void createGdbClientControls(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("DebuggerTab.gdbSetupGroup_Text"));
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        this.fDoStartGdbClient = new Button(comp, 32);
        this.fDoStartGdbClient.setText(Messages.getString("DebuggerTab.doStartGdbClient_Text"));
        this.fDoStartGdbClient.setToolTipText(Messages.getString("DebuggerTab.doStartGdbClient_ToolTipText"));
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.fDoStartGdbClient.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbCommand_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbCommand_ToolTipText"));
        Composite local = new Composite(comp, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 3;
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        local.setLayout((Layout)layout3);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd3);
        this.fGdbClientExecutable = new Text(local, 2052);
        gd3 = new GridData(768);
        this.fGdbClientExecutable.setLayoutData((Object)gd3);
        this.fGdbClientBrowseButton = new Button(local, 0);
        this.fGdbClientBrowseButton.setText(Messages.getString("DebuggerTab.gdbCommandBrowse"));
        this.fGdbClientVariablesButton = new Button(local, 0);
        this.fGdbClientVariablesButton.setText(Messages.getString("DebuggerTab.gdbCommandVariable"));
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbCommandActualPath_Label"));
        this.fGdbClientPathLabel = new Text(comp, 2052);
        gd2 = new GridData(4, 0, true, false);
        gd2.horizontalSpan = 4;
        this.fGdbClientPathLabel.setLayoutData((Object)gd2);
        this.fGdbClientPathLabel.setEnabled(true);
        this.fGdbClientPathLabel.setEditable(false);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbOtherOptions_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbOtherOptions_ToolTipText"));
        gd2 = new GridData();
        label.setLayoutData((Object)gd2);
        this.fGdbClientOtherOptions = new Text(comp, 2052);
        gd2 = new GridData(768);
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientOtherOptions.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbOtherCommands_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbOtherCommands_ToolTipText"));
        gd2 = new GridData();
        gd2.verticalAlignment = 128;
        label.setLayoutData((Object)gd2);
        this.fGdbClientOtherCommands = new Text(comp, 2626);
        gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientOtherCommands.setLayoutData((Object)gd2);
        this.fDoStartGdbClient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.doStartGdbClientChanged();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbClientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
                TabDebugger.this.updateGdbClientActualPath();
            }
        });
        this.fGdbClientOtherOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbClientOtherCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbClientBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbCommandBrowse_Title"), TabDebugger.this.fGdbClientExecutable);
            }
        });
        this.fGdbClientVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbClientExecutable);
            }
        });
    }

    private void createRemoteControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.remoteGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ipAddressLabel"));
        this.fTargetIpAddress = new Text(comp, 2048);
        gd2 = new GridData();
        gd2.widthHint = 125;
        this.fTargetIpAddress.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.portNumberLabel"));
        this.fTargetPortNumber = new Text(comp, 2048);
        gd2 = new GridData();
        gd2.widthHint = 125;
        this.fTargetPortNumber.setLayoutData((Object)gd2);
        this.fTargetIpAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fTargetPortNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        this.fTargetPortNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void updateGdbServerActualPath() {
        assert (this.fConfiguration != null);
        String fullCommand = Configuration.getGdbServerCommand(this.fConfiguration, this.fGdbServerExecutable.getText());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.updateGdbServerActualPath() \"" + fullCommand + "\"");
        }
        this.fGdbServerPathLabel.setText(fullCommand);
    }

    private void updateGdbClientActualPath() {
        assert (this.fConfiguration != null);
        String fullCommand = Configuration.getGdbClientCommand(this.fConfiguration, this.fGdbClientExecutable.getText());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.updateGdbClientActualPath() \"" + fullCommand + "\"");
        }
        this.fGdbClientPathLabel.setText(fullCommand);
    }

    private void doStartGdbServerChanged() {
        boolean enabled = this.fDoStartGdbServer.getSelection();
        this.fGdbServerExecutable.setEnabled(enabled);
        this.fGdbServerBrowseButton.setEnabled(enabled);
        this.fGdbServerVariablesButton.setEnabled(enabled);
        this.fGdbServerOtherOptions.setEnabled(enabled);
        this.fGdbServerGdbPort.setEnabled(enabled);
        this.fGdbServerTelnetPort.setEnabled(enabled);
        this.fGdbServerTclPort.setEnabled(enabled);
        if (EclipseUtils.isWindows()) {
            this.fDoGdbServerAllocateConsole.setEnabled(false);
        } else {
            this.fDoGdbServerAllocateConsole.setEnabled(enabled);
        }
        this.fTargetIpAddress.setEnabled(!enabled);
        this.fTargetPortNumber.setEnabled(!enabled);
        this.fGdbServerPathLabel.setEnabled(enabled);
        this.fLink.setEnabled(enabled);
    }

    private void doStartGdbClientChanged() {
        boolean enabled = this.fDoStartGdbClient.getSelection();
        this.fGdbClientExecutable.setEnabled(enabled);
        this.fGdbClientBrowseButton.setEnabled(enabled);
        this.fGdbClientVariablesButton.setEnabled(enabled);
        this.fGdbClientOtherOptions.setEnabled(enabled);
        this.fGdbClientOtherCommands.setEnabled(enabled);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.initializeFrom() " + configuration.getName());
        }
        this.fConfiguration = configuration;
        try {
            Boolean booleanDefault = this.fPersistentPreferences.getGdbServerDoStart();
            this.fDoStartGdbServer.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doStartGdbServer", booleanDefault.booleanValue()));
            String stringDefault = this.fPersistentPreferences.getGdbServerExecutable();
            this.fGdbServerExecutable.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerExecutable", stringDefault));
            this.fGdbServerGdbPort.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerGdbPortNumber", 3333)));
            this.fGdbServerTelnetPort.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerTelnetPortNumber", 4444)));
            this.fGdbServerTclPort.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerTclPortNumber", "6666"));
            stringDefault = this.fPersistentPreferences.getGdbServerOtherOptions();
            this.fGdbServerOtherOptions.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerOther", stringDefault));
            if (EclipseUtils.isWindows()) {
                this.fDoGdbServerAllocateConsole.setSelection(true);
            } else {
                this.fDoGdbServerAllocateConsole.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doGdbServerAllocateConsole", true));
            }
            this.fDoGdbServerAllocateTelnetConsole.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doGdbServerAllocateTelnetConsole", false));
            booleanDefault = this.fPersistentPreferences.getGdbClientDoStart();
            this.fDoStartGdbClient.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doStartGdbCLient", booleanDefault.booleanValue()));
            stringDefault = this.fPersistentPreferences.getGdbClientExecutable();
            String gdbCommandAttr = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringDefault);
            this.fGdbClientExecutable.setText(gdbCommandAttr);
            stringDefault = this.fPersistentPreferences.getGdbClientOtherOptions();
            this.fGdbClientOtherOptions.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbClientOtherOptions", stringDefault));
            stringDefault = this.fPersistentPreferences.getGdbClientCommands();
            this.fGdbClientOtherCommands.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbClientOtherCommands", stringDefault));
            this.fTargetIpAddress.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost"));
            int storedPort = 0;
            storedPort = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
            if (storedPort <= 0 || 65535 < storedPort) {
                storedPort = 3333;
            }
            String portString = Integer.toString(storedPort);
            this.fTargetPortNumber.setText(portString);
            this.doStartGdbServerChanged();
            boolean updateThreadsOnSuspend = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
            this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.initializeFrom() completed " + configuration.getName());
        }
    }

    public void initializeFromDefaults() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.initializeFromDefaults()");
        }
        this.fDoStartGdbServer.setSelection(true);
        String stringDefault = this.fDefaultPreferences.getGdbServerExecutable();
        this.fGdbServerExecutable.setText(stringDefault);
        this.fGdbServerGdbPort.setText(Integer.toString(3333));
        this.fGdbServerTelnetPort.setText(Integer.toString(4444));
        this.fGdbServerTclPort.setText("6666");
        stringDefault = this.fDefaultPreferences.getOpenocdConfig();
        this.fGdbServerOtherOptions.setText(stringDefault);
        if (EclipseUtils.isWindows()) {
            this.fDoGdbServerAllocateConsole.setSelection(true);
        } else {
            this.fDoGdbServerAllocateConsole.setSelection(true);
        }
        this.fDoGdbServerAllocateTelnetConsole.setSelection(false);
        this.fDoStartGdbClient.setSelection(true);
        stringDefault = this.fDefaultPreferences.getGdbClientExecutable();
        this.fGdbClientExecutable.setText(stringDefault);
        this.fGdbClientOtherOptions.setText("");
        this.fGdbClientOtherCommands.setText("set mem inaccessible-by-default off\n");
        this.fTargetIpAddress.setText("localhost");
        String portString = Integer.toString(3333);
        this.fTargetPortNumber.setText(portString);
        this.doStartGdbServerChanged();
        this.fUpdateThreadlistOnSuspend.setSelection(false);
    }

    public String getId() {
        return TAB_ID;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.activated() " + workingCopy.getName());
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.deactivated() " + workingCopy.getName());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.isValid() " + launchConfig.getName());
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean result = true;
        boolean hasContent = false;
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            hasContent = true;
            if (this.fGdbServerExecutable != null && this.fGdbServerExecutable.getText().trim().isEmpty()) {
                this.setErrorMessage("GDB server executable path?");
                result = false;
            }
            if (this.fGdbServerGdbPort != null && this.fGdbServerGdbPort.getText().trim().isEmpty()) {
                this.setErrorMessage("GDB port?");
                result = false;
            }
            if (this.fGdbServerTelnetPort != null && this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
                this.setErrorMessage("Telnet port?");
                result = false;
            }
            if (this.fGdbServerTclPort != null && this.fGdbServerTclPort.getText().trim().isEmpty()) {
                this.setErrorMessage("Tcl port?");
                result = false;
            }
        }
        if (this.fDoStartGdbClient != null && this.fDoStartGdbClient.getSelection()) {
            hasContent = true;
            if (this.fGdbClientExecutable != null && this.fGdbClientExecutable.getText().trim().isEmpty()) {
                result = false;
                this.setErrorMessage("GDB client executable name?");
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.isValid() " + launchConfig.getName() + " = " + result);
        }
        return hasContent && result;
    }

    public boolean canSave() {
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            if (this.fGdbServerExecutable != null && this.fGdbServerExecutable.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerGdbPort != null && this.fGdbServerGdbPort.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerTelnetPort != null && this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerTclPort != null && this.fGdbServerTclPort.getText().trim().isEmpty()) {
                return false;
            }
        }
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            return true;
        }
        return this.fDoStartGdbClient != null && this.fDoStartGdbClient.getSelection();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String str;
        int port;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.performApply() " + configuration.getName() + ", dirty=" + this.isDirty());
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU OpenOCD");
        boolean booleanValue = this.fDoStartGdbServer.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doStartGdbServer", booleanValue);
        this.fPersistentPreferences.putGdbServerDoStart(booleanValue);
        String stringValue = this.fGdbServerExecutable.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerExecutable", stringValue);
        this.fPersistentPreferences.putGdbServerExecutable(stringValue);
        if (!this.fGdbServerGdbPort.getText().trim().isEmpty()) {
            port = Integer.parseInt(this.fGdbServerGdbPort.getText().trim());
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerGdbPortNumber", port);
        } else {
            Activator.log((String)"empty fGdbServerGdbPort");
        }
        if (!this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
            port = Integer.parseInt(this.fGdbServerTelnetPort.getText().trim());
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerTelnetPortNumber", port);
        } else {
            Activator.log((String)"empty fGdbServerTelnetPort");
        }
        if (!this.fGdbServerTclPort.getText().trim().isEmpty()) {
            str = this.fGdbServerTclPort.getText().trim();
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerTclPortNumber", str);
        } else {
            Activator.log((String)"empty fGdbServerTclPort");
        }
        stringValue = this.fGdbServerOtherOptions.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerOther", stringValue);
        this.fPersistentPreferences.putGdbServerOtherOptions(stringValue);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doGdbServerAllocateConsole", this.fDoGdbServerAllocateConsole.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doGdbServerAllocateTelnetConsole", this.fDoGdbServerAllocateTelnetConsole.getSelection());
        booleanValue = this.fDoStartGdbClient.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doStartGdbCLient", booleanValue);
        this.fPersistentPreferences.putGdbClientDoStart(booleanValue);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        stringValue = this.fGdbClientExecutable.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringValue);
        this.fPersistentPreferences.putGdbClientExecutable(stringValue);
        stringValue = this.fGdbClientOtherOptions.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbClientOtherOptions", stringValue);
        this.fPersistentPreferences.putGdbClientOtherOptions(stringValue);
        stringValue = this.fGdbClientOtherCommands.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbClientOtherCommands", stringValue);
        this.fPersistentPreferences.putGdbClientCommands(stringValue);
        if (this.fDoStartGdbServer.getSelection()) {
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost");
            String str2 = this.fGdbServerGdbPort.getText().trim();
            if (!str2.isEmpty()) {
                try {
                    int port2 = Integer.parseInt(str2);
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port2);
                }
                catch (NumberFormatException e) {
                    Activator.log((Throwable)e);
                }
            }
        } else {
            String ip = this.fTargetIpAddress.getText().trim();
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", ip);
            str = this.fTargetPortNumber.getText().trim();
            if (!str.isEmpty()) {
                try {
                    int port3 = Integer.valueOf(str);
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port3);
                }
                catch (NumberFormatException e) {
                    Activator.log((Throwable)e);
                }
            }
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        this.fPersistentPreferences.flush();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.performApply() completed " + configuration.getName() + ", dirty=" + this.isDirty());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.TabDebugger.setDefaults() " + configuration.getName());
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU OpenOCD");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        boolean defaultBoolean = this.fPersistentPreferences.getGdbServerDoStart();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doStartGdbServer", defaultBoolean);
        String defaultString = this.fPersistentPreferences.getGdbServerExecutable();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerExecutable", defaultString);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerConnectionAddress", "");
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerGdbPortNumber", 3333);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerTelnetPortNumber", 4444);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerTclPortNumber", "6666");
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerLog", "");
        defaultString = this.fPersistentPreferences.getGdbServerOtherOptions();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbServerOther", defaultString);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doGdbServerAllocateConsole", true);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.doGdbServerAllocateTelnetConsole", false);
        defaultString = this.fPersistentPreferences.getGdbClientExecutable();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultString);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        defaultString = this.fPersistentPreferences.getGdbClientOtherOptions();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbClientOtherOptions", defaultString);
        defaultString = this.fPersistentPreferences.getGdbClientCommands();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.openocd.gdbClientOtherCommands", defaultString);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }
}

