/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesComposite;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesPackage;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectComposite
extends PropertiesComposite {
    private static final int READER_ROLE = 0;
    private static final int WRITER_ROLE = 1;
    private static final int PROJECT_ADMIN_ROLE = 2;
    private static final int SERVER_ADMIN_ROLE = 3;
    private String[] roleNames = new String[]{"Reader", "Writer", "Project Admin", "Server Admin"};
    private Label lblVersion;
    private Text txtVersion;
    private ProjectInfo projectInfo;

    public ProjectComposite(Composite parent, int style, AdminBroker adminBroker) {
        super(parent, style, adminBroker);
        this.createControls();
    }

    @Override
    protected void removeOrgUnit(ACOrgUnit orgUnit) {
        try {
            this.getAdminBroker().removeParticipant(this.projectInfo.getProjectId(), orgUnit.getId());
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        this.getTableViewer().refresh();
    }

    @Override
    protected void addExistingOrgUnit(ACOrgUnit participant) {
        try {
            if (participant != null) {
                this.getAdminBroker().addParticipant(this.projectInfo.getProjectId(), participant.getId());
            }
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        this.getTableViewer().refresh();
    }

    @Override
    protected void addNewOrgUnit() {
        try {
            EList<ACOrgUnit> participants = this.getParticipants();
            for (ACOrgUnit orgUnit : participants) {
                this.getAdminBroker().addParticipant(this.projectInfo.getProjectId(), orgUnit.getId());
            }
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        this.getTableViewer().refresh();
    }

    private EList<ACOrgUnit> getParticipants() {
        BasicEList allOrgUnits = new BasicEList();
        BasicEList participants = new BasicEList();
        try {
            allOrgUnits.addAll(this.getAdminBroker().getOrgUnits());
            if (this.projectInfo != null) {
                allOrgUnits.removeAll(this.getAdminBroker().getParticipants(this.projectInfo.getProjectId()));
            }
            Object[] result = this.showDialog((Collection<ACOrgUnit>)allOrgUnits, "Select a participant");
            int i = 0;
            while (i < result.length) {
                if (result[i] instanceof ACOrgUnit) {
                    participants.add((Object)((ACOrgUnit)result[i]));
                }
                ++i;
            }
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        return participants;
    }

    @Override
    protected void createTableGroup() {
        super.createTableGroup("Participants");
    }

    @Override
    protected void createTableViewer(Composite parent) {
        super.createTableViewer(parent);
        TableViewerColumn roleColumnViewer = new TableViewerColumn(this.getTableViewer(), 0);
        roleColumnViewer.getColumn().setText("Role");
        roleColumnViewer.getColumn().setWidth(120);
        roleColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ACOrgUnit orgUnit = (ACOrgUnit)element;
                int roleIndex = ProjectComposite.this.getCurrentRoleIndex(orgUnit);
                return ProjectComposite.this.roleNames[roleIndex];
            }
        });
        roleColumnViewer.setEditingSupport((EditingSupport)new RoleEditingSupport((ColumnViewer)this.getTableViewer()));
    }

    @Override
    protected void addDragNDropSupport() {
        super.addDragNDropSupport();
        int ops = 1;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DropTargetAdapter dropListener = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = PropertiesForm.getDragSource().equals("Projects") ? 0 : 1;
            }

            public void drop(DropTargetEvent event) {
                if (PropertiesForm.getDragNDropObject() != null && PropertiesForm.getDragNDropObject() instanceof ACOrgUnit) {
                    ACOrgUnit orgUnit = (ACOrgUnit)PropertiesForm.getDragNDropObject();
                    ProjectComposite.this.addExistingOrgUnit(orgUnit);
                    PropertiesForm.setDragNDropObject(null);
                    ProjectComposite.this.getTableViewer().refresh();
                }
            }
        };
        this.getTableViewer().addDropSupport(ops, transfers, (DropTargetListener)dropListener);
    }

    public void changeRole(ACOrgUnit orgUnit, int role) {
        try {
            switch (role) {
                case 0: {
                    this.getAdminBroker().changeRole(this.projectInfo.getProjectId(), orgUnit.getId(), RolesPackage.eINSTANCE.getReaderRole());
                    break;
                }
                case 1: {
                    this.getAdminBroker().changeRole(this.projectInfo.getProjectId(), orgUnit.getId(), RolesPackage.eINSTANCE.getWriterRole());
                    break;
                }
                case 2: {
                    this.getAdminBroker().changeRole(this.projectInfo.getProjectId(), orgUnit.getId(), RolesPackage.eINSTANCE.getProjectAdminRole());
                    break;
                }
                case 3: {
                    this.getAdminBroker().changeRole(this.projectInfo.getProjectId(), orgUnit.getId(), RolesPackage.eINSTANCE.getServerAdmin());
                    break;
                }
            }
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        this.getTableViewer().refresh();
    }

    @Override
    protected void createSimpleAttributes() {
        super.createSimpleAttributes();
        this.getTxtName().setEnabled(false);
        this.getTxtDescription().setEnabled(false);
        this.lblVersion = new Label((Composite)this.getAttributesGroup(), 0);
        this.lblVersion.setText("Version: ");
        this.txtVersion = new Text((Composite)this.getAttributesGroup(), 2048);
        this.txtVersion.setLayoutData((Object)new GridData(768));
        this.txtVersion.setEnabled(false);
    }

    @Override
    public void updateControls(EObject input) {
        if (input instanceof ProjectInfo) {
            this.projectInfo = (ProjectInfo)input;
            this.getTxtName().setText(this.projectInfo.getName());
            this.getTxtDescription().setText(this.projectInfo.getDescription());
            this.txtVersion.setText(String.valueOf(this.projectInfo.getVersion().getIdentifier()));
            this.getTableViewer().setInput((Object)this.projectInfo);
        }
    }

    public int getCurrentRoleIndex(ACOrgUnit orgUnit) {
        int result = 0;
        try {
            Role role = this.getAdminBroker().getRole(this.projectInfo.getProjectId(), orgUnit.getId());
            if (role.eClass().equals(RolesPackage.eINSTANCE.getReaderRole())) {
                result = 0;
            } else if (role.eClass().equals(RolesPackage.eINSTANCE.getWriterRole())) {
                result = 1;
            } else if (role.eClass().equals(RolesPackage.eINSTANCE.getProjectAdminRole())) {
                result = 2;
            } else if (role.eClass().equals(RolesPackage.eINSTANCE.getServerAdmin())) {
                result = 3;
            }
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        return result;
    }

    private class RoleEditingSupport
    extends EditingSupport {
        private ComboBoxCellEditor cellEditor;

        public RoleEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.cellEditor = new ComboBoxCellEditor((Composite)ProjectComposite.this.getTableViewer().getTable(), ProjectComposite.this.roleNames, 8);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            return ProjectComposite.this.getCurrentRoleIndex((ACOrgUnit)element);
        }

        protected void setValue(Object element, Object value) {
            ProjectComposite.this.changeRole((ACOrgUnit)element, (Integer)value);
        }
    }
}

