/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.conflictDetection;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.emfstore.internal.common.ExtensionRegistry;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucketCandidate;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ReservationSet;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ReservationSetModifier;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.ContainmentType;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.FeatureOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceMoveOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceSetOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.ReferenceOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservationToConflictBucketCandidateMap {
    private static ReservationSetModifier reservationSetModifier = ReservationToConflictBucketCandidateMap.initCustomReservationModifier();
    private ReservationSet reservationToConflictMap = new ReservationSet();
    private Set<ConflictBucketCandidate> conflictBucketCandidates = new LinkedHashSet<ConflictBucketCandidate>();

    private static ReservationSetModifier initCustomReservationModifier() {
        return (ReservationSetModifier)ExtensionRegistry.INSTANCE.get("org.eclipse.emf.emfstore.server.conflictDetection.reservationSetModifiier", ReservationSetModifier.class, (Object)new ReservationSetModifier(){

            public ReservationSet addCustomReservation(AbstractOperation operation, ReservationSet reservationSet, ModelElementIdToEObjectMapping mapping) {
                return reservationSet;
            }
        }, true);
    }

    private void joinReservationSet(ReservationSet reservationSet, ConflictBucketCandidate currentConflictBucketCandidate) {
        Set<String> modelElements = reservationSet.getAllModelElements();
        for (String modelElement : modelElements) {
            if (reservationSet.hasFullReservation(modelElement) || this.reservationToConflictMap.hasFullReservation(modelElement)) {
                ConflictBucketCandidate mergedConflictBucketCandidates = this.mergeConflictBucketCandidates(this.reservationToConflictMap.getConflictBucketCandidates(modelElement), currentConflictBucketCandidate);
                this.reservationToConflictMap.addFullReservation(modelElement, mergedConflictBucketCandidates);
                continue;
            }
            if (reservationSet.hasExistenceReservation(modelElement)) {
                this.reservationToConflictMap.addExistenceReservation(modelElement, currentConflictBucketCandidate);
            }
            Set<String> featureNames = reservationSet.getFeatureNames(modelElement);
            for (String featureName : featureNames) {
                if (featureName.equals("+existence")) continue;
                if (!reservationSet.hasOppositeReservations(modelElement, featureName)) {
                    this.handleFeatureVsFeatureReservation(currentConflictBucketCandidate, modelElement, featureName);
                    continue;
                }
                this.handleOppositeVsOppositeReservation(reservationSet, currentConflictBucketCandidate, modelElement, featureName);
            }
        }
    }

    private void handleFeatureVsFeatureReservation(ConflictBucketCandidate currentConflictBucketCandidate, String modelElement, String featureName) {
        if (this.reservationToConflictMap.hasFeatureReservation(modelElement, featureName)) {
            Set<ConflictBucketCandidate> existingBuckets = this.reservationToConflictMap.getConflictBucketCandidates(modelElement, featureName);
            ConflictBucketCandidate mergedConflictBucketCandidates = this.mergeConflictBucketCandidates(existingBuckets, currentConflictBucketCandidate);
            this.reservationToConflictMap.addFeatureReservation(modelElement, featureName, mergedConflictBucketCandidates);
        } else {
            if (this.reservationToConflictMap.hasOppositeReservations(modelElement, featureName)) {
                throw new IllegalStateException("Reservation for same feature with and without opposites is illegal!");
            }
            this.reservationToConflictMap.addFeatureReservation(modelElement, featureName, currentConflictBucketCandidate);
        }
    }

    private void handleOppositeVsOppositeReservation(ReservationSet reservationSet, ConflictBucketCandidate currentConflictBucketCandidate, String modelElement, String featureName) {
        if (this.reservationToConflictMap.hasOppositeReservations(modelElement, featureName)) {
            Set<String> opposites = reservationSet.getOpposites(modelElement, featureName);
            for (String oppositeModelElement : opposites) {
                if (!this.reservationToConflictMap.hasOppositeReservation(modelElement, featureName, oppositeModelElement)) continue;
                ConflictBucketCandidate mergedConflictBucketCandidates = this.mergeConflictBucketCandidates(this.reservationToConflictMap.getConflictBucketCandidates(modelElement, featureName, oppositeModelElement), currentConflictBucketCandidate);
                this.reservationToConflictMap.addMultiReferenceWithOppositeReservation(modelElement, featureName, oppositeModelElement, mergedConflictBucketCandidates);
            }
        } else {
            if (this.reservationToConflictMap.hasFeatureReservation(modelElement, featureName)) {
                throw new IllegalStateException("Reservation for same feature with and without opposites is illegal!");
            }
            Set<String> opposites = reservationSet.getOpposites(modelElement, featureName);
            for (String oppositeModelElement : opposites) {
                this.reservationToConflictMap.addMultiReferenceWithOppositeReservation(modelElement, featureName, oppositeModelElement, currentConflictBucketCandidate);
            }
        }
    }

    private ConflictBucketCandidate mergeConflictBucketCandidates(Set<ConflictBucketCandidate> existingBuckets, ConflictBucketCandidate currentBucket) {
        ConflictBucketCandidate rootBucket = currentBucket.getRootConflictBucketCandidate();
        for (ConflictBucketCandidate otherBucket : existingBuckets) {
            otherBucket.getRootConflictBucketCandidate().setParentConflictBucketCandidate(rootBucket);
        }
        return rootBucket;
    }

    public void scanOperationReservations(AbstractOperation operation, int priority, ModelElementIdToEObjectMapping idToEObjectMapping, boolean isMyOperation) {
        ReservationSet reservationSet = this.extractReservationFromOperation(operation, new ReservationSet());
        reservationSet = this.addCustomReservations(operation, reservationSet, idToEObjectMapping);
        ConflictBucketCandidate conflictBucketCandidate = new ConflictBucketCandidate();
        this.conflictBucketCandidates.add(conflictBucketCandidate);
        conflictBucketCandidate.addOperation(operation, isMyOperation, priority);
        this.joinReservationSet(reservationSet, conflictBucketCandidate);
    }

    private ReservationSet addCustomReservations(AbstractOperation operation, ReservationSet reservationSet, ModelElementIdToEObjectMapping idToEObjectMapping) {
        return reservationSetModifier.addCustomReservation(operation, reservationSet, idToEObjectMapping);
    }

    private ReservationSet extractReservationFromOperation(AbstractOperation operation, ReservationSet reservationSet) {
        if (operation instanceof CompositeOperation) {
            CompositeOperation compositeOperation = (CompositeOperation)operation;
            for (AbstractOperation subOperation : compositeOperation.getSubOperations()) {
                this.extractReservationFromOperation(subOperation, reservationSet);
            }
            return reservationSet;
        }
        if (operation instanceof CreateDeleteOperation) {
            CreateDeleteOperation createDeleteOperation = (CreateDeleteOperation)operation;
            if (createDeleteOperation.isDelete()) {
                for (ModelElementId modelElementId : createDeleteOperation.getEObjectToIdMap().values()) {
                    reservationSet.addFullReservation(modelElementId.getId());
                }
            }
            for (AbstractOperation subOperation : createDeleteOperation.getSubOperations()) {
                this.extractReservationFromOperation(subOperation, reservationSet);
            }
            return reservationSet;
        }
        if (operation instanceof FeatureOperation) {
            this.handleFeatureOperation(operation, reservationSet);
            return reservationSet;
        }
        throw new IllegalStateException("Unkown operation type: " + operation.getClass().getCanonicalName());
    }

    private void handleFeatureOperation(AbstractOperation operation, ReservationSet reservationSet) {
        FeatureOperation featureOperation = (FeatureOperation)operation;
        String modelElementId = featureOperation.getModelElementId().getId();
        String featureName = featureOperation.getFeatureName();
        if (featureOperation instanceof ReferenceOperation) {
            ReferenceOperation referenceOperation = (ReferenceOperation)featureOperation;
            for (ModelElementId otherModelElement : referenceOperation.getOtherInvolvedModelElements()) {
                if (referenceOperation.getContainmentType().equals((Object)ContainmentType.CONTAINMENT) && !referenceOperation.isBidirectional()) {
                    reservationSet.addContainerReservation(otherModelElement.getId());
                    continue;
                }
                reservationSet.addExistenceReservation(otherModelElement.getId());
            }
        }
        if (featureOperation instanceof MultiReferenceOperation || featureOperation instanceof MultiReferenceSetOperation || featureOperation instanceof MultiReferenceMoveOperation) {
            for (ModelElementId otherModelElement : featureOperation.getOtherInvolvedModelElements()) {
                reservationSet.addMultiReferenceWithOppositeReservation(modelElementId, featureName, otherModelElement.getId());
            }
        } else {
            reservationSet.addFeatureReservation(modelElementId, featureName);
        }
    }

    public Set<ConflictBucketCandidate> getConflictBucketCandidates() {
        LinkedHashMap<ConflictBucketCandidate, LinkedHashSet<ConflictBucketCandidate>> rootToBucketMergeSetMap = new LinkedHashMap<ConflictBucketCandidate, LinkedHashSet<ConflictBucketCandidate>>();
        for (ConflictBucketCandidate candidate : this.conflictBucketCandidates) {
            ConflictBucketCandidate root = candidate.getRootConflictBucketCandidate();
            LinkedHashSet<ConflictBucketCandidate> bucketMergeSet = (LinkedHashSet<ConflictBucketCandidate>)rootToBucketMergeSetMap.get(root);
            if (bucketMergeSet == null) {
                bucketMergeSet = new LinkedHashSet<ConflictBucketCandidate>();
                rootToBucketMergeSetMap.put(root, bucketMergeSet);
            }
            bucketMergeSet.add(candidate);
        }
        for (ConflictBucketCandidate root : rootToBucketMergeSetMap.keySet()) {
            for (ConflictBucketCandidate sibling : (Set)rootToBucketMergeSetMap.get(root)) {
                root.addConflictBucketCandidate(sibling);
            }
        }
        return rootToBucketMergeSetMap.keySet();
    }
}

