/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atom;

import com.google.gdata.data.IOutOfLineContent;
import com.google.gdata.data.Reference;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.atom.Content;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import java.net.URI;
import java.net.URISyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfLineContent
extends Content
implements IOutOfLineContent,
Reference {
    public static final String KIND = "out-of-line";
    public static final ElementKey<String, OutOfLineContent> KEY = ElementKey.of(Content.KEY.getId(), String.class, OutOfLineContent.class);
    public static final AttributeKey<Long> LENGTH = AttributeKey.of(new QName("length"), Long.class);
    public static final AttributeKey<String> ETAG = AttributeKey.of(new QName(Namespaces.gNs, "etag"));

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        Content.registerMetadata(registry);
        ElementCreator builder = registry.build(KEY);
        builder.replaceAttribute(Content.SRC).setRequired(true);
        builder.addAttribute(LENGTH).setVisible(false);
        builder.addAttribute(ETAG);
        registry.adapt(Content.KEY, KIND, KEY);
    }

    public OutOfLineContent() {
        super(KEY);
    }

    public OutOfLineContent(Content content) {
        super(KEY, content);
    }

    protected OutOfLineContent(ElementKey<?, ?> key) {
        super(key);
    }

    @Override
    public int getType() {
        return 7;
    }

    public void setMimeType(ContentType v) {
        this.setAttributeValue(TYPE, (Object)(v == null ? null : v.getMediaType()));
    }

    @Override
    @Deprecated
    public String getUri() {
        URI uri = this.getSrc();
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    @Deprecated
    public void setUri(String v) {
        try {
            this.setSrc(v == null ? null : new URI(v));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSrc(URI v) {
        this.setAttributeValue(SRC, (Object)v);
    }

    public void setLength(long length) {
        this.setAttributeValue(LENGTH, (Object)(length == -1L ? null : Long.valueOf(length)));
    }

    @Override
    public String getHref() {
        URI uri = (URI)this.getAttributeValue(SRC);
        return uri == null ? null : uri.toString();
    }

    @Override
    public void setHref(String href) {
        try {
            this.setAttributeValue(SRC, (Object)(href == null ? null : new URI(href)));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Not a URI: " + href, e);
        }
    }

    public long getLength() {
        Long length = this.getAttributeValue(LENGTH);
        return length == null ? -1L : length;
    }

    @Override
    public String getEtag() {
        return this.getAttributeValue(ETAG);
    }

    public void setEtag(String etag) {
        this.setAttributeValue(ETAG, (Object)etag);
    }
}

