/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.engine;

import java.lang.reflect.Method;
import java.util.concurrent.Future;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.util.MatlabEngineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatlabEngine {
    private static final String CONNECT_MATLAB_METHOD = "connectMatlab";
    private static final String GET_VARIABLE_METHOD = "getVariable";
    private static final String EVAL_METHOD = "eval";
    private static final String EVAL_ASYNC_METHOD = "evalAsync";
    private static final String RESULT = "result";
    private static final String ASIGN = " = ";
    private static final String PARAM_REGEX = "[?]";
    private static final String ERROR_INVALID_PARAMETER_NUMBER = "%d parameters were expected but %d were provided";
    private static final Logger LOGGER = LoggerFactory.getLogger(MatlabEngine.class);
    protected Object engine;
    protected Method evalMethod;
    protected Method getVariableMethod;
    protected Method evalAsyncMethod;

    public MatlabEngine(Class<?> matlabEngineClass) throws Exception {
        try {
            this.engine = matlabEngineClass.getMethod(CONNECT_MATLAB_METHOD, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            System.out.println("retrying connection");
            this.engine = matlabEngineClass.getMethod(CONNECT_MATLAB_METHOD, new Class[0]).invoke(null, new Object[0]);
        }
        this.evalMethod = this.engine.getClass().getMethod(EVAL_METHOD, String.class);
        this.getVariableMethod = this.engine.getClass().getMethod(GET_VARIABLE_METHOD, String.class);
        this.evalAsyncMethod = this.engine.getClass().getMethod(EVAL_ASYNC_METHOD, String.class);
    }

    public Object evalWithSetupAndResult(String setup, String cmd, Object ... parameters) throws MatlabException {
        this.eval(String.valueOf(setup) + (setup.endsWith(";") ? "" : ";") + RESULT + ASIGN + cmd, parameters);
        return this.getVariable(RESULT);
    }

    public Object evalWithResult(String cmd) throws MatlabException {
        this.eval("result = " + cmd);
        return this.getVariable(RESULT);
    }

    public Object evalWithResult(String cmd, Object ... parameters) throws MatlabException {
        this.eval("result = " + cmd, parameters);
        return this.getVariable(RESULT);
    }

    public void eval(String cmd, Object ... parameters) throws MatlabException {
        String[] parts = (cmd = " " + cmd + " ").split(PARAM_REGEX);
        if (parts.length != parameters.length + 1) {
            String error = String.format(ERROR_INVALID_PARAMETER_NUMBER, parts.length - 1, parameters.length);
            throw new RuntimeException(error);
        }
        cmd = parts[0];
        int i = 0;
        while (i < parameters.length) {
            cmd = String.valueOf(cmd) + String.valueOf(parameters[i]).replace("'", "''").replace("\n", "\\n") + parts[i + 1];
            ++i;
        }
        cmd = cmd.substring(1, cmd.length() - 1);
        this.eval(cmd);
    }

    public void eval(String cmd) throws MatlabException {
        try {
            LOGGER.debug(cmd);
            this.evalMethod.invoke(this.engine, cmd);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
            throw new MatlabException(e);
        }
    }

    public Object getVariable(String variable) throws MatlabException {
        try {
            return MatlabEngineUtil.parseMatlabEngineVariable(this.getVariableMethod.invoke(this.engine, variable));
        }
        catch (Exception e) {
            throw new MatlabException(e);
        }
    }

    public Future<Void> evalAsync(String cmd) throws MatlabException {
        try {
            Method evalSyncMethod = this.engine.getClass().getMethod(EVAL_ASYNC_METHOD, String.class);
            return (Future)evalSyncMethod.invoke(this.engine, cmd);
        }
        catch (Exception e) {
            throw new MatlabException(e);
        }
    }
}

