/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.engine;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabRuntimeException;

public class MatlabEnginePool {
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final String MATLAB_ENGINE_CLASS = "com.mathworks.engine.MatlabEngine";
    private static final String SYS_PATHS = "sys_paths";
    protected static MatlabEnginePool instance;
    protected Set<MatlabEngine> pool = new LinkedHashSet<MatlabEngine>();
    protected Class<?> matlabEngineClass;
    protected String libraryPath = "";
    protected String engineJarPath = "";

    private MatlabEnginePool(String libraryPath, String engineJarPath) throws MatlabRuntimeException {
        this.libraryPath = libraryPath;
        this.engineJarPath = engineJarPath;
        try {
            String SEP = System.getProperty("os.name").toLowerCase().contains("win") ? ";" : ":";
            System.setProperty(JAVA_LIBRARY_PATH, String.valueOf(libraryPath) + SEP + System.getProperty(JAVA_LIBRARY_PATH));
            Field sysPathsField = ClassLoader.class.getDeclaredField(SYS_PATHS);
            Class[] urlClass = new Class[]{URL.class};
            Class<URLClassLoader> urlClassLoaderClass = URLClassLoader.class;
            sysPathsField.setAccessible(true);
            sysPathsField.set(null, null);
            URL engineJarPathURL = new File(engineJarPath).toURI().toURL();
            URLClassLoader systemURLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Method method = urlClassLoaderClass.getDeclaredMethod("addURL", urlClass);
            method.setAccessible(true);
            method.invoke((Object)systemURLClassLoader, engineJarPathURL);
            this.matlabEngineClass = systemURLClassLoader.loadClass(MATLAB_ENGINE_CLASS);
        }
        catch (Exception exception) {
            throw new MatlabRuntimeException("Make sure to properly configure the library path and MATLAB engine Jar in Epsilon/Simulink preferences");
        }
    }

    public static MatlabEnginePool getInstance(String libraryPath, String engineJarPath) throws MatlabRuntimeException {
        if (instance == null || instance != null && (!libraryPath.equalsIgnoreCase(instance.getLibraryPath()) || !engineJarPath.equalsIgnoreCase(instance.getEngineJarPath()))) {
            instance = new MatlabEnginePool(libraryPath, engineJarPath);
        }
        return instance;
    }

    public static void reset() {
        instance = null;
    }

    public MatlabEngine getMatlabEngine() throws Exception {
        MatlabEngine engine = null;
        if (this.pool.isEmpty()) {
            engine = new MatlabEngine(this.matlabEngineClass);
        } else {
            engine = this.pool.iterator().next();
            this.pool.remove(engine);
        }
        return engine;
    }

    public void release(MatlabEngine engine) {
        this.pool.add(engine);
    }

    public String getEngineJarPath() {
        return this.engineJarPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }
}

