/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model.element;

import java.util.List;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.exception.MatlabRuntimeException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkPort;
import org.eclipse.epsilon.emc.simulink.util.SimulinkUtil;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class SimulinkBlock
extends SimulinkElement {
    private static final String HANDLE_DELETE_BLOCK_HANDLE = "handle = ?; delete_block(handle);";
    private static final String INSPECT_HANDLE = "handle = ?; inspect(handle);";
    private static final String GET_SIMULINK_BLOCK_HANDLE = "getSimulinkBlockHandle('?');";
    private static final String DELETE = "delete";
    private static final String CREATE = "add";
    private static final String DELETE_BLOCK = "handle = ?; delete_block(handle);";

    public SimulinkBlock(SimulinkModel model, MatlabEngine engine, Double handle) throws MatlabRuntimeException {
        super(model, engine, handle);
    }

    public SimulinkBlock(String path, SimulinkModel model, MatlabEngine engine) throws MatlabRuntimeException {
        super(path, model, engine);
    }

    public SimulinkBlock(SimulinkModel model, MatlabEngine engine, String type) throws MatlabRuntimeException {
        super(model, engine, type);
    }

    protected String getParentPath() throws MatlabRuntimeException {
        SimulinkBlock parent = this.getParent();
        return parent == null ? this.model.getSimulinkModelName() : parent.getPath();
    }

    public void setParent(SimulinkBlock parent) {
        try {
            String name = (String)this.getProperty("name");
            String parentPath = parent == null ? this.model.getSimulinkModelName() : parent.getPath();
            Double newHandle = (Double)this.engine.evalWithResult("add_block('?', '?', 'MakeNameUnique', 'on');", this.getPath(), String.valueOf(parentPath) + "/" + name);
            this.engine.eval("handle = ?; delete_block(handle);", this.handle);
            this.handle = newHandle;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SimulinkBlock getParent() throws MatlabRuntimeException {
        block5: {
            String parentPath;
            block6: {
                try {
                    String path = this.getPath();
                    String name = ((String)this.getProperty("name")).replace("/", "//").replace("\n", " ");
                    if (path.equalsIgnoreCase(name)) break block5;
                    parentPath = path.substring(0, path.length() - name.length() - 1);
                    if (parentPath.replace("//", "").indexOf("/") >= 0) break block6;
                    return null;
                }
                catch (EolIllegalPropertyException eolIllegalPropertyException) {}
            }
            try {
                return new SimulinkBlock(parentPath, this.model, this.engine);
            }
            catch (MatlabRuntimeException matlabRuntimeException) {
                throw new MatlabRuntimeException("Unable to retrieve parent");
            }
        }
        return null;
    }

    public List<SimulinkBlock> getChildren() throws MatlabException {
        return SimulinkUtil.getChildren(this.model, this.engine, this);
    }

    public SimulinkModelElement inspect() throws EolRuntimeException {
        try {
            this.engine.eval(INSPECT_HANDLE, this.handle);
            return this;
        }
        catch (MatlabException e) {
            throw new EolRuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean deleteElementInModel() throws EolRuntimeException {
        try {
            this.engine.eval("handle = ?; delete_block(handle);", this.getHandle());
            return true;
        }
        catch (MatlabException matlabException) {
            return false;
        }
    }

    public void setScript(String script) {
        try {
            this.engine.eval("sf = sfroot();block = sf.find('Path','?','-isa','Stateflow.EMChart');block.Script = sprintf('?');", this.getPath(), script);
        }
        catch (MatlabException e) {
            e.printStackTrace();
        }
    }

    public String getScript() {
        try {
            this.engine.eval("sf = sfroot();block = sf.find('Path','?','-isa','Stateflow.EMChart');script = string(block.Script);", this.getPath());
            return "" + this.engine.getVariable("script");
        }
        catch (MatlabException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void link(SimulinkBlock other) throws EolRuntimeException {
        this.link(other, 1, 1);
    }

    public void linkTo(SimulinkBlock other, int inPort) throws EolRuntimeException {
        this.link(other, 1, inPort);
    }

    public void linkFrom(SimulinkBlock other, int outPort) throws EolRuntimeException {
        this.link(other, outPort, 1);
    }

    public void link(SimulinkBlock other, int outPort, int inPort) throws EolRuntimeException {
        this.manageLink(other, outPort, inPort, true);
    }

    public void unlink(SimulinkBlock other) throws EolRuntimeException {
        this.unlink(other, 1, 1);
    }

    public void unlinkTo(SimulinkBlock other, int inPort) throws EolRuntimeException {
        this.unlink(other, 1, inPort);
    }

    public void unlinkFrom(SimulinkBlock other, int outPort) throws EolRuntimeException {
        this.unlink(other, outPort, 1);
    }

    public void unlink(SimulinkBlock other, int outPort, int inPort) throws EolRuntimeException {
        this.manageLink(other, outPort, inPort, false);
    }

    public void manageLink(SimulinkBlock other, int outPort, int inPort, boolean create) throws EolRuntimeException {
        String command = "sourceHandle = ?;targetHandle = ?;OutPortHandles = get_param(sourceHandle,'PortHandles');InPortHandles = get_param(targetHandle,'PortHandles');?_line('?',OutPortHandles.Outport(?),InPortHandles.Inport(?));";
        try {
            this.engine.eval(command, this.getHandle(), other.getHandle(), create ? CREATE : DELETE, this.getParentPath(), outPort, inPort);
        }
        catch (MatlabException ex) {
            throw new EolRuntimeException(ex.getMessage());
        }
    }

    public List<SimulinkPort> getOutports() {
        try {
            Object handles = this.engine.evalWithSetupAndResult("handle = ?; ph = get_param(handle, 'PortHandles');", "ph.Outport;", this.handle);
            return SimulinkUtil.getSimulinkPorts(this.model, this.engine, handles);
        }
        catch (MatlabException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<SimulinkPort> getInports() {
        try {
            Object handles = this.engine.evalWithSetupAndResult("handle = ?; ph = get_param(handle, 'PortHandles');", "ph.Inport;", this.handle);
            return SimulinkUtil.getSimulinkPorts(this.model, this.engine, handles);
        }
        catch (MatlabException e) {
            e.printStackTrace();
            return null;
        }
    }
}

