/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class MozillaDelegate {
    Browser browser;
    Shell eventShell;
    Listener listener;
    boolean hasFocus;

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(int handle) {
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(handle);
    }

    static String getLibraryName() {
        return "libxpcom.dylib";
    }

    static char[] mbcsToWcs(String codePage, byte[] buffer) {
        return new String(buffer).toCharArray();
    }

    static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        if (terminate) {
            string = String.valueOf(string) + "\u0000";
        }
        return string.getBytes();
    }

    void addWindowSubclass() {
    }

    int createBaseWindow(nsIBaseWindow baseWindow) {
        NSApplication application = NSApplication.sharedApplication();
        NSMenu mainMenu = application.mainMenu();
        if (mainMenu != null) {
            mainMenu.retain();
        }
        int rc = baseWindow.Create();
        application.setMainMenu(mainMenu);
        if (mainMenu != null) {
            mainMenu.release();
        }
        ((Mozilla)this.browser.webBrowser).Activate();
        return rc;
    }

    int getHandle() {
        return this.browser.view.id;
    }

    String getJSLibraryName() {
        return "libmozjs.dylib";
    }

    String getProfilePath() {
        String baseDir = System.getProperty("user.home");
        return String.valueOf(baseDir) + Mozilla.SEPARATOR_OS + ".mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String GetSWTInitLibraryName() {
        return "swt-xulrunner";
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        ((Mozilla)this.browser.webBrowser).Activate();
        this.browser.setFocus();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                if (event.type != 12) {
                    ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                    MozillaDelegate.this.hasFocus = false;
                }
                MozillaDelegate.this.eventShell.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.eventShell.removeListener(27, this);
                MozillaDelegate.this.eventShell.removeListener(12, this);
                MozillaDelegate.this.eventShell = null;
                MozillaDelegate.this.listener = null;
            }
        };
        this.eventShell = this.browser.getShell();
        this.eventShell.getDisplay().addFilter(15, this.listener);
        this.eventShell.addListener(27, this.listener);
        this.eventShell.addListener(12, this.listener);
    }

    void handleMouseDown() {
    }

    boolean hookEnterExit() {
        return true;
    }

    void init() {
    }

    boolean needsSpinup() {
        return false;
    }

    void onDispose(int embedHandle) {
        if (this.listener != null) {
            this.eventShell.getDisplay().removeFilter(15, this.listener);
            this.eventShell.removeListener(27, this.listener);
            this.eventShell.removeListener(12, this.listener);
            this.eventShell = null;
            this.listener = null;
        }
        this.browser = null;
    }

    void removeWindowSubclass() {
    }

    boolean sendTraverse() {
        return true;
    }

    void setSize(int embedHandle, int width, int height) {
    }
}

