/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.metatype.MetaTypeInformationImpl;
import org.eclipse.equinox.metatype.MetaTypeProviderTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaTypeServiceImpl
implements MetaTypeService,
SynchronousBundleListener {
    SAXParserFactory _parserFactory;
    private Hashtable<Long, MetaTypeInformation> _mtps = new Hashtable(7);
    private final LogService logger;
    private final ServiceTracker<Object, Object> metaTypeProviderTracker;

    public MetaTypeServiceImpl(SAXParserFactory parserFactory, LogService logger, ServiceTracker<Object, Object> metaTypeProviderTracker) {
        this._parserFactory = parserFactory;
        this.logger = logger;
        this.metaTypeProviderTracker = metaTypeProviderTracker;
    }

    public MetaTypeInformation getMetaTypeInformation(Bundle bundle) {
        MetaTypeInformation mti;
        try {
            mti = this.getMetaTypeProvider(bundle);
        }
        catch (IOException e) {
            this.logger.log(1, "IOException in MetaTypeInformation:getMetaTypeInformation(Bundle bundle)");
            e.printStackTrace();
            mti = null;
        }
        return mti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaTypeInformation getMetaTypeProvider(final Bundle b) throws IOException {
        try {
            Long bID = new Long(b.getBundleId());
            Hashtable<Long, MetaTypeInformation> hashtable = this._mtps;
            synchronized (hashtable) {
                if (this._mtps.containsKey(bID)) {
                    return this._mtps.get(bID);
                }
                final LogService loggerTemp = this.logger;
                final ServiceTracker<Object, Object> tracker = this.metaTypeProviderTracker;
                MetaTypeInformation mti = AccessController.doPrivileged(new PrivilegedExceptionAction<MetaTypeInformation>(){

                    @Override
                    public MetaTypeInformation run() throws IOException {
                        MetaTypeInformationImpl impl = new MetaTypeInformationImpl(b, MetaTypeServiceImpl.this._parserFactory, loggerTemp);
                        if (!impl._isThereMeta) {
                            return new MetaTypeProviderTracker(b, loggerTemp, (ServiceTracker<Object, Object>)tracker);
                        }
                        return impl;
                    }
                });
                this._mtps.put(bID, mti);
                return mti;
            }
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Long bID = new Long(event.getBundle().getBundleId());
        switch (type) {
            case 8: 
            case 16: {
                this._mtps.remove(bID);
                break;
            }
        }
    }
}

