/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.equinox.jmx.common.ContributionNotificationEvent;
import org.eclipse.equinox.jmx.common.ContributionProxy;
import org.eclipse.equinox.jmx.common.util.ByteArrayHolder;
import org.eclipse.equinox.jmx.internal.server.Activator;
import org.eclipse.equinox.jmx.internal.server.ContributionMessages;
import org.eclipse.equinox.jmx.server.ContributionProvider;

public abstract class Contribution
extends NotificationBroadcasterSupport
implements DynamicMBean {
    private static long sequenceNumber;
    private static Map contributionDelegates;
    private static Map imageCache;
    private ContributionProxy proxy;
    private boolean stateChanged;
    private ObjectName objectName;
    protected final Object contributionDelegate;
    static /* synthetic */ Class class$0;

    static {
        contributionDelegates = new Hashtable();
        imageCache = new Hashtable();
    }

    public Contribution() {
        this((Object)null);
    }

    public Contribution(Object contributionDelegate) {
        this.contributionDelegate = contributionDelegate;
        Contribution priorContrib = null;
        if (contributionDelegate != null) {
            priorContrib = (Contribution)contributionDelegates.get(contributionDelegate);
        }
        if (priorContrib != null) {
            this.objectName = priorContrib.getObjectName();
        } else {
            try {
                String objectNameStr = "jmxserver:type=" + this.getClass().getName() + this.hashCode();
                this.objectName = ObjectName.getInstance(objectNameStr);
            }
            catch (MalformedObjectNameException e) {
                Activator.logError(e);
            }
            if (contributionDelegate != null) {
                contributionDelegates.put(this.contributionDelegate, this);
            }
        }
    }

    protected abstract String getName();

    protected abstract Object[] getChildren();

    protected abstract Set getProperties();

    protected abstract URL getImageLocation();

    protected abstract MBeanInfo getMBeanInfo(Object var1);

    protected abstract Object invokeOperation(String var1, Object[] var2, String[] var3);

    public static final Contribution getContribution(Object contributionDelegate) {
        return (Contribution)contributionDelegates.get(contributionDelegate);
    }

    public Object getContributionDelegate() {
        return this.contributionDelegate;
    }

    public final ContributionProxy createProxy() {
        if (this.proxy == null || this.stateChanged) {
            ByteArrayHolder holder;
            block17: {
                holder = null;
                URL imageUrl = this.getImageLocation();
                if (imageUrl != null && (holder = (ByteArrayHolder)imageCache.get(imageUrl)) == null) {
                    InputStream in = null;
                    try {
                        try {
                            int nread;
                            in = imageUrl.openStream();
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            byte[] buf = new byte[512];
                            while ((nread = in.read(buf)) != -1) {
                                bout.write(buf, 0, nread);
                            }
                            holder = new ByteArrayHolder(bout.toByteArray());
                            imageCache.put(imageUrl, holder);
                        }
                        catch (IOException e) {
                            Activator.logError(e);
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e2) {
                                    Activator.logError(e2);
                                }
                            }
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                Activator.logError(e);
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            Activator.logError(e);
                        }
                    }
                }
            }
            this.proxy = new ContributionProxy(this.getName(), this.getProperties(), holder, this.getObjectName(), this.getMBeanInfo());
            this.stateChanged = false;
        }
        return this.proxy;
    }

    public final ContributionProxy[] getChildContributions() {
        ContributionProxy[] result = this.getChildContributionProxies();
        if (!(this instanceof ContributionProvider) && this.contributionDelegate != null) {
            ContributionProxy[] delegateProxies = null;
            ContributionProvider[] delegateProviders = ContributionProvider.getExtendingProviders(this.contributionDelegate);
            if (delegateProviders != null) {
                delegateProxies = this.getChildContributions(delegateProviders);
            }
            if (delegateProxies != null) {
                ContributionProxy[] oldResult = result == null ? (result = new ContributionProxy[0]) : result;
                result = new ContributionProxy[result.length + delegateProxies.length];
                System.arraycopy(oldResult, 0, result, 0, oldResult.length);
                System.arraycopy(delegateProxies, 0, result, oldResult.length, delegateProxies.length);
            }
        }
        return result;
    }

    private ContributionProxy[] getChildContributionProxies() {
        ArrayList<ContributionProxy> proxies = null;
        Object[] childs = this.getChildren();
        if (childs != null) {
            int i = 0;
            while (i < childs.length) {
                ContributionProvider provider = null;
                provider = this instanceof ContributionProvider && ((ContributionProvider)this).contributesType(childs[i]) ? (ContributionProvider)this : ContributionProvider.getProvider(childs[i]);
                if (provider != null) {
                    try {
                        Contribution contrib = provider.createContribution(childs[i]);
                        contrib.registerContribution(Activator.getDefault().getServer());
                        if (proxies == null) {
                            proxies = new ArrayList<ContributionProxy>();
                        }
                        proxies.add(contrib.createProxy());
                    }
                    catch (Exception e) {
                        Activator.log(e);
                    }
                }
                ++i;
            }
        }
        return proxies == null ? null : proxies.toArray(new ContributionProxy[proxies.size()]);
    }

    public final void registerContribution(MBeanServer mbeanServer) throws MBeanRegistrationException, NotCompliantMBeanException {
        if (!mbeanServer.isRegistered(this.getObjectName())) {
            try {
                mbeanServer.registerMBean(this, this.getObjectName());
            }
            catch (InstanceAlreadyExistsException e) {
                Activator.logError(e);
            }
        }
    }

    protected void contributionStateChanged(ContributionNotificationEvent event) {
        if (event == null) {
            return;
        }
        if (event.getType().equals("contribution.removed")) {
            contributionDelegates.remove(this.contributionDelegate);
        } else if (!event.getType().equals("contribution.added")) {
            event.getType().equals("contribution.updated");
        }
        this.stateChanged = true;
        this.sendNotification(new Notification(event.getType(), (Object)this, sequenceNumber++, new Date().getTime()));
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = this.getMBeanInfo(this.contributionDelegate);
        if (info != null) {
            MBeanOperationInfo[] ops = info.getOperations();
            MBeanOperationInfo[] opsNew = new MBeanOperationInfo[ops.length + 2];
            System.arraycopy(ops, 0, opsNew, 0, ops.length);
            try {
                int n = opsNew.length - 2;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.equinox.jmx.server.Contribution");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                opsNew[n] = new MBeanOperationInfo(ContributionMessages.desc_getcontribs, clazz.getMethod("getChildContributions", new Class[0]));
                int n2 = opsNew.length - 1;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.equinox.jmx.server.Contribution");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                opsNew[n2] = new MBeanOperationInfo("", clazz2.getMethod("createProxy", new Class[0]));
                return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), opsNew, info.getNotifications());
            }
            catch (Exception e) {
                Activator.logError(e);
            }
        } else {
            info = new MBeanInfo(this.getClass().getName(), this.getName(), new MBeanAttributeInfo[0], new MBeanConstructorInfo[0], new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
        }
        return info;
    }

    public Object invoke(String arg0, Object[] arg1, String[] arg2) throws MBeanException, ReflectionException {
        if (arg0.equals("getChildContributions")) {
            return this.getChildContributions();
        }
        if (arg0.equals("createProxy")) {
            return this.createProxy();
        }
        arg0.equals("getContributionUIUrl");
        return this.invokeOperation(arg0, arg1, arg2);
    }

    protected ObjectName getObjectName() {
        return this.objectName;
    }

    private final ContributionProxy[] getChildContributions(ContributionProvider[] delegateProviders) {
        ArrayList<ContributionProxy> delegateProviderList;
        block5: {
            try {
                delegateProviderList = new ArrayList<ContributionProxy>();
                int i = 0;
                while (i < delegateProviders.length) {
                    ContributionProvider delegateProvider = delegateProviders[i];
                    ContributionProxy[] proxies = delegateProvider.getChildContributions();
                    if (proxies != null && proxies.length > 0) {
                        delegateProvider.registerContribution(Activator.getDefault().getServer());
                        delegateProviderList.add(delegateProvider.createProxy());
                    }
                    ++i;
                }
                if (delegateProviderList.size() != 0) break block5;
                return null;
            }
            catch (Exception e) {
                Activator.logError(e);
                return null;
            }
        }
        return delegateProviderList.toArray(new ContributionProxy[delegateProviderList.size()]);
    }

    public abstract /* synthetic */ AttributeList setAttributes(AttributeList var1);

    public abstract /* synthetic */ void setAttribute(Attribute var1) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException;

    public abstract /* synthetic */ AttributeList getAttributes(String[] var1);

    public abstract /* synthetic */ Object getAttribute(String var1) throws AttributeNotFoundException, MBeanException, ReflectionException;
}

