/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.actions;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.jmx.client.IJMXConnectorProvider;
import org.eclipse.equinox.jmx.internal.client.Activator;
import org.eclipse.equinox.jmx.internal.client.MBeanServerProxy;
import org.eclipse.equinox.jmx.internal.client.ui.actions.ActionMessages;
import org.eclipse.equinox.jmx.internal.client.ui.actions.ConnectionSelectionDialog;
import org.eclipse.equinox.jmx.internal.client.ui.contributionsview.ContributionsViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NewConnectionAction
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow window;
    protected JMXConnector connector;
    private MBeanServerProxy serverProxy;
    private boolean connected;
    private boolean isClosing;
    private boolean isConnecting;
    private static Map transports;

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(final IAction action) {
        this.serverProxy = null;
        if (!this.connected) {
            MBeanServer mbeanServer = this.findLocalMBeanServer();
            if (mbeanServer != null && MessageDialog.openConfirm((Shell)this.window.getShell(), (String)ActionMessages.info_message, (String)ActionMessages.local_mbean_server)) {
                this.serverProxy = new MBeanServerProxy(mbeanServer);
                action.setText(ActionMessages.connect_host);
                this.connected = false;
                this.loadContributionsView();
                return;
            }
            if (this.serverProxy == null) {
                NewConnectionAction.loadTransportExtensions();
                if (transports.size() == 0) {
                    MessageDialog.openInformation(null, (String)ActionMessages.info_message, (String)ActionMessages.no_transports_available);
                    return;
                }
                ConnectionSelectionDialog dialog = new ConnectionSelectionDialog(this.window.getShell(), transports);
                if (dialog.open() != 0) {
                    return;
                }
                try {
                    this.connector = dialog.getJMXConnector();
                    this.isConnecting = true;
                    this.connector.addConnectionNotificationListener(new NotificationListener(){

                        public void handleNotification(Notification notification, Object handback) {
                            if (NewConnectionAction.this.isClosing || NewConnectionAction.this.isConnecting) {
                                return;
                            }
                            NewConnectionAction.this.connected = false;
                            NewConnectionAction.this.connector = null;
                            NewConnectionAction.this.serverProxy = null;
                            action.setText(ActionMessages.connect_host);
                            NewConnectionAction.this.window.getShell().getDisplay().asyncExec(new Runnable(this){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    MessageDialog.openError((Shell)1.access$0(this.this$1).window.getShell(), (String)ActionMessages.info_message, (String)ActionMessages.server_closed_connection);
                                }
                            });
                        }

                        static /* synthetic */ NewConnectionAction access$0(1 var0) {
                            return var0.NewConnectionAction.this;
                        }
                    }, null, null);
                    this.connector.connect();
                    this.isConnecting = false;
                    this.serverProxy = new MBeanServerProxy(this.connector.getMBeanServerConnection());
                }
                catch (Exception e) {
                    Activator.logError(e.getMessage(), e);
                    MessageDialog.openError((Shell)this.window.getShell(), (String)ActionMessages.error_message, (String)e.getMessage());
                }
            }
            this.loadContributionsView();
            this.connected = true;
            action.setText(ActionMessages.disconnect_action);
        } else {
            if (this.connector != null) {
                try {
                    this.isClosing = true;
                    this.connector.close();
                    this.isClosing = false;
                    this.connector = null;
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)this.window.getShell(), (String)ActionMessages.error_message, (String)e.getMessage());
                    Activator.log(e);
                }
            }
            this.connected = false;
            this.serverProxy = null;
            this.loadContributionsView();
            action.setText(ActionMessages.connect_host);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    private MBeanServer findLocalMBeanServer() {
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
        Iterator iter = ((AbstractList)mbeanServers).iterator();
        while (iter.hasNext()) {
            MBeanServer mbeanServer = (MBeanServer)iter.next();
            if (!mbeanServer.getDefaultDomain().equals("jmxserver")) continue;
            return mbeanServer;
        }
        return null;
    }

    private void loadContributionsView() {
        try {
            ContributionsViewPart contributionsView = (ContributionsViewPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.equinox.jmx.client.ui.contributionsview");
            if (contributionsView != null) {
                contributionsView.setMBeanServerProxy(this.serverProxy);
            }
        }
        catch (PartInitException e) {
            Activator.log(e);
        }
    }

    private static void loadTransportExtensions() {
        if (transports == null) {
            transports = new HashMap();
        }
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.equinox.jmx.client", "transport");
        IExtension[] types = point.getExtensions();
        int i = 0;
        while (i < types.length) {
            NewConnectionAction.loadTransportConfigurationElements(types[i].getConfigurationElements());
            ++i;
        }
    }

    private static void loadTransportConfigurationElements(IConfigurationElement[] configElems) {
        int j = 0;
        while (j < configElems.length) {
            String transport;
            IConfigurationElement element = configElems[j];
            String elementName = element.getName();
            if (elementName.equals("transport") && element.getAttribute("class") != null && (transport = element.getAttribute("protocol")) != null) {
                try {
                    Object obj = element.createExecutableExtension("class");
                    if (obj instanceof IJMXConnectorProvider) {
                        transports.put(transport, obj);
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            ++j;
        }
    }
}

