/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.viewsupport;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageRegistry {
    private HashMap registry = new HashMap(10);
    private Display display;

    public ImageRegistry() {
        this(ImageRegistry.getStandardDisplay());
    }

    public ImageRegistry(Display display) {
        this.display = display;
        Assert.isNotNull((Object)display);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result = (Image)this.registry.get(descriptor);
        if (result != null) {
            return result;
        }
        Assert.isTrue((this.display == ImageRegistry.getStandardDisplay() ? 1 : 0) != 0, (String)"Allocating image for wrong display.");
        result = descriptor.createImage();
        if (result != null) {
            this.registry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        Iterator iter = this.registry.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        this.registry.clear();
    }

    private void hookDisplay() {
        this.display.disposeExec(new Runnable(){

            public void run() {
                ImageRegistry.this.dispose();
            }
        });
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

