/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.rmi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RMISecurityManager;
import java.rmi.registry.LocateRegistry;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.jmx.internal.rmi.Activator;
import org.eclipse.equinox.jmx.server.IJMXConnectorServerProvider;
import org.osgi.framework.Bundle;

public class RMIServer
implements IJMXConnectorServerProvider {
    private int port;

    public JMXServiceURL getJMXServiceURL(String host, int port, String protocol, String domain) throws MalformedURLException {
        this.port = port;
        return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/" + domain);
    }

    public JMXConnectorServer newJMXConnectorServer(JMXServiceURL arg0, Map arg1, MBeanServer arg2) throws IOException {
        this.initialize();
        return JMXConnectorServerFactory.newJMXConnectorServer(arg0, arg1, arg2);
    }

    private void initialize() throws IOException {
        Path serverPolicyFileName = new Path("server.policy");
        URL serverPolicyBundleURL = FileLocator.find((Bundle)Activator.getBundleContext().getBundle(), (IPath)serverPolicyFileName, null);
        if (serverPolicyBundleURL == null) {
            throw new FileNotFoundException("Unable to find server policy file.");
        }
        serverPolicyBundleURL = FileLocator.toFileURL((URL)serverPolicyBundleURL);
        System.setProperty("java.security.policy", serverPolicyBundleURL.getFile());
        LocateRegistry.createRegistry(this.port);
        System.setSecurityManager(new RMISecurityManager());
    }
}

