/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.util.Collection;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIActivator;
import org.eclipse.equinox.internal.p2.ui.admin.dialogs.AddProfileDialog;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.p2.ui.model.Profiles;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementLabelProvider;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallAction
extends ProfileModificationAction {
    String userChosenProfileId;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public InstallAction(ProvisioningUI ui, ISelectionProvider selectionProvider) {
        super(ui, ProvUI.INSTALL_COMMAND_LABEL, selectionProvider, null);
        this.setToolTipText(ProvUI.INSTALL_COMMAND_TOOLTIP);
        this.userChosenProfileId = ui.getProfileId();
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        if (selectionArray.length == 0) {
            return false;
        }
        int i = 0;
        while (i < selectionArray.length) {
            IInstallableUnit iu;
            if (selectionArray[i] instanceof InstalledIUElement && this.isSelectable((IIUElement)selectionArray[i])) {
                return true;
            }
            Object object = selectionArray[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iu = (IInstallableUnit)ProvUI.getAdapter((Object)object, (Class)clazz)) != null && this.isSelectable(iu)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSelectable(IIUElement element) {
        return super.isSelectable(element) && !(element.getParent((Object)element) instanceof AvailableIUElement);
    }

    protected int performAction(ProfileChangeOperation operation, Collection<IInstallableUnit> ius) {
        ProvisioningUI ui = ProvAdminUIActivator.getDefault().getProvisioningUI(this.userChosenProfileId);
        operation.setProfileId(this.userChosenProfileId);
        int ret = ui.openInstallWizard(ius, (InstallOperation)operation, null);
        this.userChosenProfileId = null;
        return ret;
    }

    protected ProfileChangeOperation getProfileChangeOperation(Collection<IInstallableUnit> ius) {
        InstallOperation op = new InstallOperation(this.getSession(), ius);
        op.setProfileId(this.userChosenProfileId);
        return op;
    }

    protected boolean isInvalidProfileId() {
        if (this.userChosenProfileId == null) {
            this.userChosenProfileId = this.getUserChosenProfileId();
        }
        return this.userChosenProfileId == null;
    }

    private String getUserChosenProfileId() {
        IProfileRegistry registry = ProvAdminUIActivator.getDefault().getProfileRegistry();
        if (registry.getProfiles().length == 0) {
            AddProfileDialog dialog = new AddProfileDialog(this.getShell(), new String[0]);
            if (dialog.open() == 0) {
                return dialog.getAddedProfileId();
            }
            return null;
        }
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setTitle("Choose a Profile");
        dialog.setLabelProvider((ILabelProvider)new ProvElementLabelProvider());
        dialog.setInput((Object)new Profiles(this.getProvisioningUI()));
        dialog.setContentProvider((IStructuredContentProvider)new ProvElementContentProvider());
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0) {
            IProfile profile;
            Object object = result[0];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((profile = (IProfile)ProvUI.getAdapter((Object)object, (Class)clazz)) != null) {
                return profile.getProfileId();
            }
        }
        return null;
    }

    protected void runCanceled() {
        super.runCanceled();
        this.userChosenProfileId = null;
    }
}

