/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.update;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;

public class PathUtil {
    public static boolean isWindows = System.getProperty("os.name").startsWith("Win");
    private static final String FILE_PROTOCOL = "file:";

    public static String makeRelative(String urlString, URL rootURL) {
        int index = urlString.indexOf(FILE_PROTOCOL);
        if (index == -1) {
            return urlString;
        }
        index += 5;
        boolean done = false;
        URL url = null;
        String file = urlString;
        while (!done) {
            try {
                url = new URL(file);
                file = url.getFile();
            }
            catch (MalformedURLException e) {
                done = true;
            }
        }
        if (url == null || !new File(url.getFile()).isAbsolute()) {
            return urlString;
        }
        String rootString = rootURL.toExternalForm();
        return urlString.substring(0, index) + PathUtil.makeRelative(urlString.substring(index), rootString.substring(rootString.indexOf(FILE_PROTOCOL) + 5));
    }

    public static String makeRelative(String original, String rootPath) {
        IPath path = IPath.fromOSString((String)original);
        if (!path.isAbsolute()) {
            return original;
        }
        String result = PathUtil.makeRelative(path, IPath.fromOSString((String)rootPath));
        return path.toOSString().equals(result) ? original : result;
    }

    private static String makeRelative(IPath toRel, IPath base) {
        String device = toRel.getDevice();
        if (!(device == base.getDevice() || device != null && device.equalsIgnoreCase(base.getDevice()))) {
            return toRel.toOSString();
        }
        int i = base.matchingFirstSegments(toRel);
        if (i == 0) {
            return toRel.toOSString();
        }
        Object result = "";
        int j = 0;
        while (j < base.segmentCount() - i) {
            result = (String)result + "../";
            ++j;
        }
        if (i == toRel.segmentCount()) {
            return ".";
        }
        result = (String)result + toRel.setDevice(null).removeFirstSegments(i).toOSString();
        return result;
    }

    public static String makeAbsolute(String original, String rootPath) {
        IPath path = IPath.fromOSString((String)original);
        if (path.isAbsolute()) {
            return original;
        }
        IPath root = IPath.fromOSString((String)rootPath);
        return root.addTrailingSeparator().append(original.replace(':', '}')).toOSString().replace('}', ':');
    }

    public static String makeAbsolute(String urlString, URL rootURL) {
        int index = urlString.indexOf(FILE_PROTOCOL);
        if (index == -1) {
            return urlString;
        }
        index += 5;
        boolean done = false;
        URL url = null;
        String file = urlString;
        while (!done) {
            try {
                url = new URL(file);
                file = url.getFile();
            }
            catch (MalformedURLException e) {
                done = true;
            }
        }
        if (url == null || new File(url.getFile()).isAbsolute()) {
            return urlString;
        }
        return urlString.substring(0, index - 5) + PathUtil.makeAbsolute(urlString.substring(index), rootURL.toExternalForm());
    }
}

