/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.simulink;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.CodeGen;
import org.eclipse.escet.cif.codegen.CurlyBraceIfElseGenerator;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.TypeCodeGen;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.c89.C89CodeGen;
import org.eclipse.escet.cif.codegen.c89.C89DataValue;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfoHelper;
import org.eclipse.escet.cif.codegen.options.SimulinkOutputsOption;
import org.eclipse.escet.cif.codegen.options.SimulinkSampleOffsetOption;
import org.eclipse.escet.cif.codegen.options.SimulinkSampleTimeOption;
import org.eclipse.escet.cif.codegen.options.TargetLanguage;
import org.eclipse.escet.cif.codegen.simulink.SimulinkExprCodeGen;
import org.eclipse.escet.cif.codegen.simulink.SimulinkFunctionCodeGen;
import org.eclipse.escet.cif.codegen.simulink.SimulinkTypeCodeGen;
import org.eclipse.escet.cif.codegen.simulink.SimulinkTypeUtils;
import org.eclipse.escet.cif.codegen.simulink.typeinfos.SimulinkArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.codegen.updates.tree.LhsListProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsTupleProjection;
import org.eclipse.escet.cif.codegen.updates.tree.SingleVariableAssignment;
import org.eclipse.escet.cif.common.CifDocAnnotationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFor;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.options.processing.PatternMatchingOptionProcessing;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SimulinkCodeGen
extends CodeGen {
    public static final int INDENT = 4;
    public static final String[] RESERVED_SIMULINK_WORDS = C89CodeGen.RESERVED_C89_WORDS;
    public static final String INITIAL_EVENT_NAME = "EVT_INITIAL_";
    public static final String DELAY_EVENT_NAME = "EVT_DELAY_";
    public static final String ENUM_NAMES_LIST = "enum_names";
    public Map<PositionObject, String> simulinkTargetRefMap = null;
    public Map<Declaration, Integer> outputMap;

    public SimulinkCodeGen() {
        super(TargetLanguage.SIMULINK, 4);
    }

    @Override
    protected ExprCodeGen getExpressionCodeGenerator() {
        return new SimulinkExprCodeGen(this.inputVars, this.contVars);
    }

    @Override
    protected TypeCodeGen getTypeCodeGenerator() {
        return new SimulinkTypeCodeGen();
    }

    @Override
    protected void init() {
        super.init();
        this.simulinkTargetRefMap = null;
        this.replacements.put("generated-types", "");
        this.replacements.put("type-support-code", "");
    }

    @Override
    protected Set<String> getReservedTargetNames() {
        Set reserved = Sets.setc((int)RESERVED_SIMULINK_WORDS.length);
        int i = 0;
        while (i < RESERVED_SIMULINK_WORDS.length) {
            reserved.add(RESERVED_SIMULINK_WORDS[i]);
            ++i;
        }
        return reserved;
    }

    private void setupVarMaps() {
        if (this.simulinkTargetRefMap != null) {
            return;
        }
        this.simulinkTargetRefMap = Maps.map();
        this.outputMap = Maps.map();
        PatternMatchingOptionProcessing.OptionMatcher outputVarMatcher = SimulinkOutputsOption.getMatcher();
        List modeReport = Lists.list();
        List outputReport = Lists.list();
        List cstateReport = Lists.list();
        List reportSection = Lists.list();
        int i = 0;
        int outputIndex = 0;
        for (DiscVariable lpVar : this.lpVariables) {
            this.simulinkTargetRefMap.put((PositionObject)lpVar, Strings.fmt((String)"modes[%d]", (Object[])new Object[]{i}));
            this.reportLine((PositionObject)lpVar, i, modeReport);
            this.addDeclarationToSection(outputVarMatcher, (Declaration)lpVar, reportSection);
            ++i;
        }
        this.replacements.put("number-of-modes", Strings.str((Object)i));
        this.writeReport("mode-report", modeReport);
        outputIndex = this.moveSection(reportSection, outputIndex, this.outputMap, outputReport);
        cstateReport.add(Pair.pair((Object)"time", (Object)"1"));
        i = 1;
        for (ContVariable cVar : this.contVars) {
            this.simulinkTargetRefMap.put((PositionObject)cVar, Strings.fmt((String)"cstate[%d]", (Object[])new Object[]{i}));
            this.reportLine((PositionObject)cVar, i, cstateReport);
            this.addDeclarationToSection(outputVarMatcher, (Declaration)cVar, reportSection);
            ++i;
        }
        this.replacements.put("number-of-contvars", Strings.str((Object)i));
        this.writeReport("cstate-report", cstateReport);
        outputIndex = this.moveSection(reportSection, outputIndex, this.outputMap, outputReport);
        for (ContVariable cVar : this.constants) {
            this.simulinkTargetRefMap.put((PositionObject)cVar, Strings.fmt((String)"work->%s", (Object[])new Object[]{super.getTargetRef((PositionObject)cVar)}));
        }
        for (InputVariable inpVar : this.inputVars) {
            this.simulinkTargetRefMap.put((PositionObject)inpVar, Strings.fmt((String)"work->%s", (Object[])new Object[]{super.getTargetRef((PositionObject)inpVar)}));
        }
        for (Declaration stateVar : this.stateVars) {
            DiscVariable discVar;
            if (!(stateVar instanceof DiscVariable) || this.simulinkTargetRefMap.containsKey(discVar = (DiscVariable)stateVar)) continue;
            this.simulinkTargetRefMap.put((PositionObject)discVar, Strings.fmt((String)"work->%s", (Object[])new Object[]{super.getTargetRef((PositionObject)discVar)}));
            CifType type = discVar.getType();
            if (SimulinkTypeUtils.isSimulinkCompatibleType(type)) {
                this.addDeclarationToSection(outputVarMatcher, (Declaration)discVar, reportSection);
                continue;
            }
            String origName = (String)this.origDeclNames.get(discVar);
            Assert.notNull((Object)origName);
            String msg = Strings.fmt((String)"Discrete variable \"%s\" has non-Simulink-compatible type \"%s\", and will therefore be omitted from the output.", (Object[])new Object[]{origName, CifTextUtils.typeToStr((CifType)type)});
            OutputProvider.warn((String)msg);
        }
        outputIndex = this.moveSection(reportSection, outputIndex, this.outputMap, outputReport);
        for (AlgVariable algVar : this.algVars) {
            CifType type = algVar.getType();
            if (SimulinkTypeUtils.isSimulinkCompatibleType(type)) {
                this.addDeclarationToSection(outputVarMatcher, (Declaration)algVar, reportSection);
                continue;
            }
            String origName = (String)this.origDeclNames.get(algVar);
            Assert.notNull((Object)origName);
            String msg = Strings.fmt((String)"Algebraic variable \"%s\" has non-Simulink-compatible type \"%s\", and will therefore be omitted from the output.", (Object[])new Object[]{origName, CifTextUtils.typeToStr((CifType)type)});
            OutputProvider.warn((String)msg);
        }
        outputIndex = this.moveSection(reportSection, outputIndex, this.outputMap, outputReport);
        this.replacements.put("number-of-outputs", Strings.str((Object)outputIndex));
        this.writeReport("output-report", outputReport);
    }

    private void addDeclarationToSection(PatternMatchingOptionProcessing.OptionMatcher optionMatcher, Declaration decl, List<Pair<Declaration, String>> outputSection) {
        if (optionMatcher == null) {
            return;
        }
        String origName = (String)this.origDeclNames.get(decl);
        Assert.notNull((Object)origName);
        if (optionMatcher.matchName(origName, false)) {
            outputSection.add((Pair<Declaration, String>)Pair.pair((Object)decl, (Object)origName));
        }
    }

    private int moveSection(List<Pair<Declaration, String>> outputSection, int startIndex, Map<Declaration, Integer> outputMap, List<Pair<String, String>> outputReport) {
        if (outputSection.isEmpty()) {
            return startIndex;
        }
        Collections.sort(outputSection, new DeclarationCompator());
        for (Pair<Declaration, String> p : outputSection) {
            outputReport.add((Pair<String, String>)Pair.pair((Object)((String)p.right), (Object)Strings.str((Object)(startIndex + 1))));
            outputMap.put((Declaration)p.left, startIndex);
            ++startIndex;
        }
        outputSection.clear();
        return startIndex;
    }

    private void reportLine(PositionObject obj, int destIndex, List<Pair<String, String>> report) {
        String origName = (String)this.origDeclNames.get(obj);
        if (origName == null) {
            origName = CifTextUtils.getName((PositionObject)obj);
        }
        report.add((Pair<String, String>)Pair.pair((Object)origName, (Object)Strings.str((Object)(destIndex + 1))));
    }

    private void writeReport(String replName, List<Pair<String, String>> report) {
        if (report.isEmpty()) {
            this.replacements.put(replName, "No variables are available here.");
            return;
        }
        GridBox reportLines = new GridBox(report.size(), 2, 0, 1);
        int row = 0;
        for (Pair<String, String> pair : report) {
            reportLines.set(row, 0, (String)pair.left);
            reportLines.set(row, 1, (String)pair.right);
            ++row;
        }
        this.replacements.put(replName, reportLines.toString());
    }

    @Override
    public String getTargetRef(PositionObject obj) {
        String result;
        if (this.simulinkTargetRefMap == null) {
            this.setupVarMaps();
        }
        if ((result = this.simulinkTargetRefMap.get(obj)) != null) {
            return result;
        }
        result = super.getTargetRef(obj);
        this.simulinkTargetRefMap.put(obj, result);
        return result;
    }

    @Override
    public void performSingleAssign(CodeBox code, SingleVariableAssignment asgn, Expression value, CodeContext readCtxt, CodeContext writeCtxt) {
        Assert.check((asgn.rhsProjections == null ? 1 : 0) != 0);
        Assert.check((asgn.lhsProjections == null ? 1 : 0) != 0);
        Assert.check((!asgn.needsRangeBoundCheck() ? 1 : 0) != 0);
        VariableInformation varInfo = writeCtxt.getWriteVarInfo(asgn.variable);
        ExprCode assignment = readCtxt.exprToTarget(value, writeCtxt.makeDestination(varInfo));
        code.add((Box)assignment.getCode());
        Assert.check((!assignment.hasDataValue() ? 1 : 0) != 0);
    }

    @Override
    public void performAssign(CodeBox code, SingleVariableAssignment asgn, String rhsText, CodeContext readCtxt, CodeContext writeCtxt) {
        ArrayTypeInfo arrayTi;
        LhsTupleProjection tupleLhs;
        TupleTypeInfo tupleTi;
        LhsProjection lhsProj;
        VariableInformation fullVarInfo = writeCtxt.getWriteVarInfo(asgn.variable);
        C89DataValue rhsValue = C89DataValue.makeValue(rhsText);
        if (asgn.lhsProjections == null) {
            CifType assignedType = asgn.getAssignedType();
            TypeInfo rangeCheckInfo = readCtxt.typeToTarget(assignedType);
            MemoryCodeBox rangeCode = this.makeCodeBox();
            rangeCheckInfo.checkRange(assignedType, asgn.valueType, rhsValue, asgn.variableType, fullVarInfo.name, Lists.list(), 0, (CodeBox)rangeCode, readCtxt);
            this.insertRangecheckCode(code, (CodeBox)rangeCode);
            fullVarInfo.typeInfo.storeValue(code, rhsValue, writeCtxt.makeDestination(fullVarInfo));
            return;
        }
        String[] indexTexts = new String[asgn.lhsProjections.length];
        List rangeErrorTexts = Lists.list();
        int i = 0;
        while (i < asgn.lhsProjections.length) {
            LhsProjection lhsProj2 = asgn.lhsProjections[i];
            if (lhsProj2 instanceof LhsTupleProjection) {
                LhsTupleProjection tupleProj = (LhsTupleProjection)lhsProj2;
                indexTexts[i] = Integer.toString(tupleProj.fieldNumber);
                rangeErrorTexts.add(new RangeCheckErrorLevelText(false, tupleProj.getSelectedFieldName()));
            } else {
                LhsListProjection listProj = (LhsListProjection)lhsProj2;
                VariableInformation indexVarInfo = writeCtxt.makeTempVariable((CifType)CifConstructors.newIntType(), "index");
                indexTexts[i] = indexVarInfo.targetRef;
                rangeErrorTexts.add(new RangeCheckErrorLevelText(true, indexVarInfo.targetRef));
                ExprCode indexCode = readCtxt.exprToTarget(listProj.index, null);
                indexVarInfo.typeInfo.declareInit(code, indexCode.getRawDataValue(), writeCtxt.makeDestination(indexVarInfo));
            }
            ++i;
        }
        CifType assignedType = asgn.getAssignedType();
        TypeInfo rangeCheckInfo = readCtxt.typeToTarget(assignedType);
        MemoryCodeBox rangeCode = this.makeCodeBox();
        rangeCheckInfo.checkRange(assignedType, asgn.valueType, rhsValue, asgn.variableType, fullVarInfo.name, rangeErrorTexts, 0, (CodeBox)rangeCode, readCtxt);
        this.insertRangecheckCode(code, (CodeBox)rangeCode);
        int last = asgn.lhsProjections.length - 1;
        VariableInformation[] partVariables = new VariableInformation[last];
        int i2 = 0;
        while (i2 < last) {
            ExprCode projectRhs;
            lhsProj = asgn.lhsProjections[i2];
            CifType elementType = lhsProj.getPartType();
            partVariables[i2] = readCtxt.makeTempVariable(elementType, "part");
            VariableInformation containerInfo = i2 == 0 ? readCtxt.getReadVarInfo(new VariableWrapper(asgn.variable, false)) : partVariables[i2 - 1];
            ExprCode containerValue = new ExprCode();
            containerValue.setDataValue(C89DataValue.makeValue(containerInfo.targetRef));
            if (containerInfo.typeInfo instanceof TupleTypeInfo) {
                tupleTi = (TupleTypeInfo)containerInfo.typeInfo;
                tupleLhs = (LhsTupleProjection)lhsProj;
                projectRhs = tupleTi.getProjectedValue(containerValue, tupleLhs.fieldNumber, null, readCtxt);
            } else {
                Assert.check((boolean)(containerInfo.typeInfo instanceof ArrayTypeInfo));
                arrayTi = (ArrayTypeInfo)containerInfo.typeInfo;
                ExprCode indexVar = new ExprCode();
                indexVar.setDataValue(C89DataValue.makeComputed(indexTexts[i2]));
                projectRhs = arrayTi.getProjectedValue(containerValue, indexVar, null, readCtxt);
            }
            code.add((Box)projectRhs.getCode());
            partVariables[i2].typeInfo.declareInit(code, projectRhs.getRawDataValue(), readCtxt.makeDestination(partVariables[i2]));
            ++i2;
        }
        i2 = last;
        while (i2 >= 0) {
            MemoryCodeBox modify;
            lhsProj = asgn.lhsProjections[i2];
            VariableInformation containerInfo = i2 == 0 ? writeCtxt.getReadVarInfo(new VariableWrapper(asgn.variable, false)) : partVariables[i2 - 1];
            ExprCode containerCode = new ExprCode();
            containerCode.setDataValue(C89DataValue.makeValue(containerInfo.targetRef));
            ExprCode partCode = new ExprCode();
            if (i2 == last) {
                partCode.setDataValue(rhsValue);
            } else {
                partCode.setDataValue(C89DataValue.makeValue(partVariables[i2].targetRef));
            }
            if (containerInfo.typeInfo instanceof TupleTypeInfo) {
                tupleTi = (TupleTypeInfo)containerInfo.typeInfo;
                tupleLhs = (LhsTupleProjection)lhsProj;
                modify = readCtxt.makeCodeBox();
                modify.add((Box)tupleTi.modifyContainer(containerInfo, partCode, tupleLhs.fieldNumber, readCtxt));
            } else {
                Assert.check((boolean)(containerInfo.typeInfo instanceof ArrayTypeInfo));
                arrayTi = (ArrayTypeInfo)containerInfo.typeInfo;
                ExprCode indexCode = new ExprCode();
                indexCode.setDataValue(C89DataValue.makeComputed(indexTexts[i2]));
                modify = arrayTi.modifyContainer(containerInfo, partCode, indexCode, readCtxt);
            }
            code.add((Box)modify);
            --i2;
        }
    }

    void insertRangecheckCode(CodeBox surrounding, CodeBox rangeCode) {
        if (rangeCode.isEmpty()) {
            return;
        }
        surrounding.add("#if CHECK_RANGES");
        surrounding.add((Box)rangeCode);
        surrounding.add("#endif");
    }

    @Override
    public Destination makeDestination(VariableInformation varInfo) {
        return new Destination(null, varInfo.typeInfo, C89DataValue.makeValue(varInfo.targetRef));
    }

    @Override
    public DataValue makeDataValue(String value) {
        return C89DataValue.makeValue(value);
    }

    private void addPreamble(CodeBox code, boolean clearInputs) {
        code.add("struct WorkStruct *work = ssGetPWorkValue(sim_struct, 0);");
        code.add("int_T *modes = ssGetModeVector(sim_struct);");
        code.add("real_T *cstate = ssGetContStates(sim_struct);");
        if (clearInputs && !this.inputVars.isEmpty()) {
            code.add("ClearInputFlags(work);");
        }
    }

    @Override
    protected void addConstants(CodeContext ctxt) {
        MemoryCodeBox defCode = this.makeCodeBox(1);
        MemoryCodeBox initCode = this.makeCodeBox(1);
        for (Constant constant : this.constants) {
            VariableWrapper varWrap = new VariableWrapper((Declaration)constant, false);
            VariableInformation constInfo = ctxt.getReadVarInfo(varWrap);
            String typeName = constInfo.typeInfo.getTargetType();
            String varName = this.getTargetVariableName((PositionObject)constant);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)constant);
            defCode.add();
            if (docs.isEmpty()) {
                defCode.add("/** Constant \"%s\". */", new Object[]{constInfo.name});
            } else {
                defCode.add("/**");
                defCode.add(" * Constant \"%s\".", new Object[]{constInfo.name});
                for (String doc : docs) {
                    defCode.add(" *");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        defCode.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                }
                defCode.add(" */");
            }
            defCode.add("%s %s;", new Object[]{typeName, varName});
            ExprCode constantCode = ctxt.exprToTarget(constant.getValue(), ctxt.makeDestination((Declaration)constant));
            initCode.add((Box)constantCode.getCode());
        }
        this.replacements.put("constant-definitions", defCode.toString());
        this.replacements.put("constant-initialization", initCode.toString());
    }

    @Override
    protected void addEvents(CodeContext ctxt) {
        String prefix = (String)this.replacements.get("prefix");
        MemoryCodeBox evtDeclsCode = this.makeCodeBox();
        evtDeclsCode.add("enum %sEventEnum_ {", new Object[]{prefix});
        evtDeclsCode.indent();
        evtDeclsCode.add("/** Initial step. */");
        evtDeclsCode.add("EVT_INITIAL_,");
        evtDeclsCode.add();
        evtDeclsCode.add("/** Delay step. */");
        evtDeclsCode.add("EVT_DELAY_,");
        int i = 0;
        while (i < this.events.size()) {
            Event evt = (Event)this.events.get(i);
            String origName = (String)this.origDeclNames.get(evt);
            Assert.notNull((Object)origName);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)evt);
            evtDeclsCode.add();
            if (docs.isEmpty()) {
                evtDeclsCode.add(Strings.fmt((String)"/** Event \"%s\". */", (Object[])new Object[]{origName}));
            } else {
                evtDeclsCode.add("/**");
                evtDeclsCode.add(" * Event \"%s\".", new Object[]{origName});
                for (String doc : docs) {
                    evtDeclsCode.add(" *");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        evtDeclsCode.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                }
                evtDeclsCode.add(" */");
            }
            evtDeclsCode.add(Strings.fmt((String)"%s,", (Object[])new Object[]{this.getTargetRef((PositionObject)evt)}));
            ++i;
        }
        evtDeclsCode.dedent();
        evtDeclsCode.add("};");
        evtDeclsCode.add("typedef enum %sEventEnum_ %s_Event_;", new Object[]{prefix, prefix});
        this.replacements.put("event-declarations", evtDeclsCode.toString());
        MemoryCodeBox evtNamesCode = this.makeCodeBox(1);
        GridBox evtNames = new GridBox(2 + this.events.size(), 2, 0, 1);
        evtNames.set(0, 0, "\"initial-step\",");
        evtNames.set(0, 1, "/**< Initial step. */");
        evtNames.set(1, 0, "\"delay-step\",");
        evtNames.set(1, 1, "/**< Delay step. */");
        int i2 = 0;
        while (i2 < this.events.size()) {
            Event evt = (Event)this.events.get(i2);
            String origName = (String)this.origDeclNames.get(evt);
            Assert.notNull((Object)origName);
            evtNames.set(2 + i2, 0, Strings.fmt((String)"\"%s\",", (Object[])new Object[]{origName}));
            evtNames.set(2 + i2, 1, Strings.fmt((String)"/**< Event \"%s\". */", (Object[])new Object[]{origName}));
            ++i2;
        }
        evtNamesCode.add((Box)evtNames);
        this.replacements.put("event-name-list", evtNamesCode.toString());
    }

    @Override
    protected void addStateVars(CodeContext ctxt) {
        MemoryCodeBox preAmble = this.makeCodeBox(1);
        this.addPreamble((CodeBox)preAmble, true);
        this.replacements.put("preamble", preAmble.toString());
        Set lpVarSet = Sets.setc((int)this.lpVariables.size());
        lpVarSet.addAll(this.lpVariables);
        MemoryCodeBox varDefCode = this.makeCodeBox();
        boolean first = true;
        for (Declaration decl : this.stateVars) {
            if (lpVarSet.contains(decl) || !(decl instanceof DiscVariable)) continue;
            DiscVariable dv = (DiscVariable)decl;
            String typeText = CifTextUtils.typeToStr((CifType)dv.getType());
            VariableInformation declVarInfo = ctxt.getWriteVarInfo(decl);
            String declaration = Strings.fmt((String)"%s %s;", (Object[])new Object[]{declVarInfo.typeInfo.getTargetType(), declVarInfo.targetVariableName});
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)dv);
            if (!first) {
                varDefCode.add();
            }
            first = false;
            if (docs.isEmpty()) {
                varDefCode.add("/** Discrete variable \"%s %s\". */", new Object[]{typeText, declVarInfo.name});
            } else {
                varDefCode.add("/**");
                varDefCode.add(" * Discrete variable \"%s %s\".", new Object[]{typeText, declVarInfo.name});
                for (String doc : docs) {
                    varDefCode.add(" *");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        varDefCode.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                }
                varDefCode.add(" */");
            }
            varDefCode.add(declaration);
        }
        MemoryCodeBox code = this.makeCodeBox(1);
        code.add((Box)varDefCode);
        this.replacements.put("discvar-definitions", code.toString());
        code = this.makeCodeBox(1);
        for (Declaration decl : this.stateVars) {
            Expression rhs;
            VariableInformation declVarInfo = ctxt.getWriteVarInfo(decl);
            if (decl instanceof DiscVariable) {
                DiscVariable dv = (DiscVariable)decl;
                Assert.check((dv.getValue() != null ? 1 : 0) != 0);
                Assert.check((dv.getValue().getValues().size() == 1 ? 1 : 0) != 0);
                rhs = (Expression)dv.getValue().getValues().get(0);
            } else {
                Assert.check((boolean)(decl instanceof ContVariable));
                ContVariable cvar = (ContVariable)decl;
                rhs = cvar.getValue();
            }
            ExprCode initValCode = ctxt.exprToTarget(rhs, this.makeDestination(declVarInfo));
            code.add((Box)initValCode.getCode());
        }
        this.replacements.put("initialize-statevars", code.toString());
    }

    @Override
    protected void addContVars(CodeContext ctxt) {
        MemoryCodeBox derivDeclCode = this.makeCodeBox();
        MemoryCodeBox derivDefCode = this.makeCodeBox();
        MemoryCodeBox assignDerivCode = this.makeCodeBox(1);
        assignDerivCode.add("derivs[0] = 1.0;");
        int i = 0;
        for (ContVariable cv : this.contVars) {
            VariableInformation cvVarInfo = ctxt.getWriteVarInfo((Declaration)cv);
            if (i != 0) {
                derivDefCode.add();
            }
            String header = Strings.fmt((String)"static real_T deriv%02d(SimStruct *sim_struct)", (Object[])new Object[]{i + 1});
            derivDeclCode.add("%s;", new Object[]{header});
            derivDefCode.add("/** Derivative of \"%s\". */", new Object[]{cvVarInfo.name});
            derivDefCode.add("%s {", new Object[]{header});
            derivDefCode.indent();
            this.addPreamble((CodeBox)derivDefCode, false);
            derivDefCode.add();
            ExprCode derCode = ctxt.exprToTarget(cv.getDerivative(), null);
            derivDefCode.add((Box)derCode.getCode());
            derivDefCode.add("return %s;", new Object[]{derCode.getData()});
            derivDefCode.dedent();
            derivDefCode.add("}");
            assignDerivCode.add("derivs[%d] = deriv%02d(sim_struct);", new Object[]{i + 1, i + 1});
            ++i;
        }
        this.replacements.put("derivative-declarations", derivDeclCode.toString());
        this.replacements.put("derivative-functions", derivDefCode.toString());
        this.replacements.put("assign-derivatives", assignDerivCode.toString());
    }

    @Override
    protected void addAlgVars(CodeContext ctxt) {
        MemoryCodeBox defCode = this.makeCodeBox();
        MemoryCodeBox declCode = this.makeCodeBox();
        boolean first = true;
        for (AlgVariable algVar : this.algVars) {
            VariableInformation algVarInfo = ctxt.getWriteVarInfo((Declaration)algVar);
            if (!first) {
                defCode.add();
            }
            first = false;
            TypeInfo ti = ctxt.typeToTarget(algVar.getType());
            String header = Strings.fmt((String)"static %s %s(SimStruct *sim_struct)", (Object[])new Object[]{ti.getTargetType(), algVarInfo.targetRef});
            declCode.add("%s;", new Object[]{header});
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)algVar);
            if (docs.isEmpty()) {
                defCode.add("/** Algebraic variable %s = %s. */", new Object[]{algVarInfo.name, CifTextUtils.exprToStr((Expression)algVar.getValue())});
            } else {
                defCode.add("/**");
                defCode.add(" * Algebraic variable %s = %s.", new Object[]{algVarInfo.name, CifTextUtils.exprToStr((Expression)algVar.getValue())});
                for (String doc : docs) {
                    defCode.add(" *");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        defCode.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                }
                defCode.add(" */");
            }
            defCode.add("%s {", new Object[]{header});
            defCode.indent();
            this.addPreamble((CodeBox)defCode, false);
            defCode.add();
            ExprCode valueCode = ctxt.exprToTarget(algVar.getValue(), null);
            defCode.add((Box)valueCode.getCode());
            defCode.add("return %s;", new Object[]{valueCode.getData()});
            defCode.dedent();
            defCode.add("}");
        }
        if (!this.algVars.isEmpty()) {
            declCode.add();
        }
        this.replacements.put("algvar-inline-declarations", declCode.toString());
        this.replacements.put("algvar-inline-functions", defCode.toString());
    }

    @Override
    protected void addInputVars(CodeContext ctxt) {
        String sampleOffset;
        MemoryCodeBox varDefCode = new MemoryCodeBox();
        MemoryCodeBox inputFlagsCode = this.makeCodeBox();
        MemoryCodeBox inputClearCode = this.makeCodeBox(1);
        List inputReport = Lists.list();
        boolean first = true;
        int i = 0;
        while (i < this.inputVars.size()) {
            InputVariable var = (InputVariable)this.inputVars.get(i);
            String typeText = CifTextUtils.typeToStr((CifType)var.getType());
            VariableInformation declVarInfo = ctxt.getWriteVarInfo((Declaration)var);
            String declaration = Strings.fmt((String)"%s %s;", (Object[])new Object[]{declVarInfo.typeInfo.getTargetType(), declVarInfo.targetVariableName});
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)var);
            if (!first) {
                varDefCode.add();
            }
            first = false;
            if (docs.isEmpty()) {
                varDefCode.add("/** Input variable \"%s %s\". */", new Object[]{typeText, declVarInfo.name});
            } else {
                varDefCode.add("/**");
                varDefCode.add(" * Input variable \"%s %s\".", new Object[]{typeText, declVarInfo.name});
                for (String doc : docs) {
                    varDefCode.add(" *");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        varDefCode.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                }
                varDefCode.add(" */");
            }
            varDefCode.add(declaration);
            this.reportLine((PositionObject)var, i, inputReport);
            String flagName = Strings.fmt((String)"input_loaded%02d", (Object[])new Object[]{i});
            inputFlagsCode.add("unsigned char %s;", new Object[]{flagName});
            inputClearCode.add("work->%s = FALSE;", new Object[]{flagName});
            ++i;
        }
        MemoryCodeBox indentBox = this.makeCodeBox(1);
        indentBox.add((Box)varDefCode);
        indentBox.add();
        indentBox.add((Box)inputFlagsCode);
        this.replacements.put("inputvar-definitions", indentBox.toString());
        this.replacements.put("clear-inputflags-code", inputClearCode.toString());
        this.writeReport("input-report", inputReport);
        MemoryCodeBox inputDimsCode = this.makeCodeBox(1);
        int i2 = 0;
        while (i2 < this.inputVars.size()) {
            int columns;
            InputVariable decl = (InputVariable)this.inputVars.get(i2);
            int rows = SimulinkTypeUtils.getRowCount(decl.getType());
            if (rows == 0) {
                rows = 1;
                columns = 0;
            } else {
                columns = SimulinkTypeUtils.getColumnCount(decl.getType());
            }
            if (columns > 0) {
                inputDimsCode.add("ssSetInputPortMatrixDimensions(sim_struct, %d, %d, %d);", new Object[]{i2, rows, columns});
            } else {
                inputDimsCode.add("ssSetInputPortWidth(sim_struct, %d, %d);", new Object[]{i2, rows});
            }
            ++i2;
        }
        this.replacements.put("number-of-inputs", Strings.str((Object)this.inputVars.size()));
        this.replacements.put("set-input-ports-dimensions", inputDimsCode.toString());
        String sampleTime = SimulinkSampleTimeOption.getSimulinkSampleTimeText();
        if (sampleTime == null) {
            throw new UnsupportedException(Strings.fmt((String)"Invalid sample time option value '%s' found.", (Object[])new Object[]{SimulinkSampleTimeOption.getSampleTime()}));
        }
        this.replacements.put("sample-time", sampleTime);
        if (SimulinkSampleOffsetOption.sampleOffsetIsFixed()) {
            sampleOffset = "FIXED_IN_MINOR_STEP_OFFSET";
            if (!SimulinkSampleTimeOption.offsetMayBeFixed()) {
                msg = "Fixed sample offset option value is not allowed for the provided sample time.";
                throw new UnsupportedException(msg);
            }
        } else if (SimulinkSampleOffsetOption.sampleOffsetIsZero()) {
            sampleOffset = "0.0";
        } else if (SimulinkSampleOffsetOption.sampleOffsetIsValidReal()) {
            double offset;
            sampleOffset = SimulinkSampleOffsetOption.getSampleOffset();
            if (!SimulinkSampleTimeOption.offsetMayBeNonzero()) {
                msg = "Sample offset option may not be a non-zero real value for the provided sample time.";
                throw new UnsupportedException(msg);
            }
            double stime = SimulinkSampleTimeOption.sampleGetValue();
            if (stime <= (offset = SimulinkSampleOffsetOption.offsetGetValue().doubleValue())) {
                String msg = "Sample offset (found value %f) must be less than sample time (found value %f).";
                throw new UnsupportedException(Strings.fmt((String)msg, (Object[])new Object[]{offset, stime}));
            }
        } else {
            throw new UnsupportedException("sample offset option value not recognized.");
        }
        this.replacements.put("sample-offset", sampleOffset);
        this.addOutput(ctxt);
    }

    private void addOutput(CodeContext ctxt) {
        this.setupVarMaps();
        MemoryCodeBox outputDimsCode = this.makeCodeBox(1);
        for (Map.Entry<Declaration, Integer> entry : this.outputMap.entrySet()) {
            int columns;
            int rows;
            Declaration d = entry.getKey();
            if (d instanceof ContVariable) {
                rows = 1;
                columns = 0;
            } else if (d instanceof AlgVariable) {
                AlgVariable aVar = (AlgVariable)d;
                rows = SimulinkTypeUtils.getRowCount(aVar.getType());
                if (rows == 0) {
                    rows = 1;
                    columns = 0;
                } else {
                    columns = SimulinkTypeUtils.getColumnCount(aVar.getType());
                }
            } else {
                Assert.check((boolean)(d instanceof DiscVariable));
                DiscVariable dVar = (DiscVariable)d;
                rows = SimulinkTypeUtils.getRowCount(dVar.getType());
                if (rows == 0) {
                    rows = 1;
                    columns = 0;
                } else {
                    columns = SimulinkTypeUtils.getColumnCount(dVar.getType());
                }
            }
            int idx = entry.getValue();
            if (columns > 0) {
                outputDimsCode.add("ssSetOutputPortMatrixDimensions(sim_struct, %d, %d, %d);", new Object[]{idx, rows, columns});
                continue;
            }
            outputDimsCode.add("ssSetOutputPortWidth(sim_struct, %d, %d);", new Object[]{idx, rows});
        }
        this.replacements.put("set-output-ports-dimensions", outputDimsCode.toString());
        MemoryCodeBox outputCode = this.makeCodeBox(1);
        outputCode.add("real_T *y;");
        int index = 0;
        for (Map.Entry<Declaration, Integer> entry : this.outputMap.entrySet()) {
            if (index > 0) {
                outputCode.add();
            }
            Declaration d = entry.getKey();
            outputCode.add("y = ssGetOutputPortSignal(sim_struct, %d);", new Object[]{entry.getValue()});
            VariableInformation varInfo = ctxt.getReadVarInfo(new VariableWrapper(d, false));
            Object varAccess = varInfo.targetRef;
            if (varInfo.typeInfo.cifType instanceof ListType) {
                if (d instanceof AlgVariable) {
                    String dest = Strings.fmt((String)"tmp%d", (Object[])new Object[]{index});
                    outputCode.add("%s %s = %s(sim_struct);", new Object[]{varInfo.typeInfo.getTargetType(), dest, varAccess});
                    varAccess = dest;
                }
                outputCode.add("%sTypeToSimulink(y, &%s);", new Object[]{varInfo.typeInfo.getTypeName(), varAccess});
            } else {
                if (d instanceof AlgVariable) {
                    varAccess = (String)varAccess + "(sim_struct)";
                }
                outputCode.add("*y = %s;", new Object[]{SimulinkArrayTypeInfo.getElementConversionToSimulinkVector(varInfo.typeInfo, (String)varAccess)});
            }
            ++index;
        }
        this.replacements.put("write-output", outputCode.toString());
    }

    @Override
    protected void addFunctions(CodeContext ctxt) {
        MemoryCodeBox declCode = this.makeCodeBox(0);
        MemoryCodeBox defCode = this.makeCodeBox(0);
        boolean first = true;
        for (InternalFunction func : this.functions) {
            if (!first) {
                defCode.add();
            }
            first = false;
            SimulinkFunctionCodeGen funcGen = new SimulinkFunctionCodeGen(true, func);
            funcGen.generate((CodeBox)declCode, (CodeBox)defCode, ctxt);
        }
        this.replacements.put("functions-declarations", declCode.toString());
        this.replacements.put("functions-code", defCode.toString());
    }

    @Override
    protected void addEnum(EnumDecl enumDecl, CodeContext ctxt) {
        EnumType enumType = CifConstructors.newEnumType((EnumDecl)enumDecl, null);
        ctxt.typeToTarget((CifType)enumType);
        MemoryCodeBox enumNames = ctxt.makeCodeBox();
        enumNames.add("static const char *%s[] = {", new Object[]{ENUM_NAMES_LIST});
        enumNames.indent();
        EList eLits = enumDecl.getLiterals();
        int i = 0;
        while (i < eLits.size()) {
            if (i > 0) {
                enumNames.add();
            }
            EnumLiteral lit = (EnumLiteral)eLits.get(i);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)lit);
            String name = lit.getName();
            if (docs.isEmpty()) {
                enumNames.add("/** Literal \"%s\". */", new Object[]{name});
            } else {
                enumNames.add("/**");
                enumNames.add(" * Literal \"%s\".", new Object[]{name});
                for (String doc : docs) {
                    enumNames.add(" *");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        enumNames.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                }
                enumNames.add(" */");
            }
            enumNames.add("%s,", new Object[]{Strings.stringToJava((String)name)});
            ++i;
        }
        enumNames.dedent();
        enumNames.add("};");
        this.replacements.put("enum-names-list", enumNames.toString());
    }

    @Override
    protected void addPrints(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox();
        code.add("#if PRINT_OUTPUT");
        String prefix = (String)this.replacements.get("prefix");
        code.add("static void PrintOutput(%s_Event_ event, BoolType pre) {", new Object[]{prefix});
        code.indent();
        VariableInformation txtVarInfo = ctxt.makeTempVariable((CifType)CifConstructors.newStringType(), "text_var");
        List preCodes = Lists.listc((int)this.printDecls.size());
        List postCodes = Lists.listc((int)this.printDecls.size());
        for (Print print : this.printDecls) {
            String targetFile = Strings.stringToJava((String)print.getFile().getPath());
            CodeBox printCode = this.genPrint(print.getWhenPre(), (List<PrintFor>)print.getFors(), print.getTxtPre(), txtVarInfo, targetFile, ctxt);
            if (printCode != null) {
                preCodes.add(printCode);
            }
            if ((printCode = this.genPrint(print.getWhenPost(), (List<PrintFor>)print.getFors(), print.getTxtPost(), txtVarInfo, targetFile, ctxt)) == null) continue;
            postCodes.add(printCode);
        }
        if (!preCodes.isEmpty() || !postCodes.isEmpty()) {
            code.add("%s %s;", new Object[]{txtVarInfo.typeInfo.getTargetType(), txtVarInfo.targetRef});
            code.add();
            if (!preCodes.isEmpty()) {
                code.add("if (pre) {");
                code.indent();
                boolean first = true;
                for (CodeBox box : preCodes) {
                    if (!first) {
                        code.add();
                    }
                    first = false;
                    code.add((Box)box);
                }
                code.dedent();
            }
            if (!postCodes.isEmpty()) {
                code.add(preCodes.isEmpty() ? "if (!pre) {" : "} else {");
                code.indent();
                boolean first = true;
                for (CodeBox box : postCodes) {
                    if (!first) {
                        code.add();
                    }
                    first = false;
                    code.add((Box)box);
                }
                code.dedent();
            }
            code.add("}");
        }
        code.dedent();
        code.add("}");
        code.add("#endif");
        this.replacements.put("print-function", code.toString());
    }

    @Override
    protected void addSvgDecls(CodeContext ctxt, String cifSpecFileDir) {
        Assert.check((boolean)this.svgDecls.isEmpty());
    }

    private String makeForPrintConditions(String eventVar, List<PrintFor> fors) {
        if (fors.isEmpty()) {
            return "TRUE";
        }
        List conds = Lists.listc((int)fors.size());
        for (PrintFor pf : fors) {
            switch (pf.getKind()) {
                case EVENT: {
                    conds.add(Strings.fmt((String)"%s > %s", (Object[])new Object[]{eventVar, DELAY_EVENT_NAME}));
                    break;
                }
                case FINAL: {
                    break;
                }
                case INITIAL: {
                    conds.add(Strings.fmt((String)"%s == %s", (Object[])new Object[]{eventVar, INITIAL_EVENT_NAME}));
                    break;
                }
                case NAME: {
                    Expression eventRef = pf.getEvent();
                    Assert.check((boolean)(eventRef instanceof EventExpression));
                    Event event = ((EventExpression)eventRef).getEvent();
                    conds.add(Strings.fmt((String)"%s == %s", (Object[])new Object[]{eventVar, this.getTargetRef((PositionObject)event)}));
                    break;
                }
                case TIME: {
                    conds.add(Strings.fmt((String)"%s == %s", (Object[])new Object[]{eventVar, DELAY_EVENT_NAME}));
                    break;
                }
                default: {
                    Assert.fail((Object)"Unexpected kind of print event.");
                }
            }
        }
        if (conds.isEmpty()) {
            return null;
        }
        if (conds.size() == 1) {
            return (String)conds.get(0);
        }
        return String.join((CharSequence)" || ", conds);
    }

    private CodeBox genPrint(Expression whenPred, List<PrintFor> fors, Expression txtExpr, VariableInformation txtVarInfo, String targetFile, CodeContext ctxt) {
        if (txtExpr == null) {
            return null;
        }
        if (!targetFile.equals(":stdout:")) {
            return null;
        }
        String forConds = this.makeForPrintConditions("event", fors);
        if (forConds == null) {
            return null;
        }
        MemoryCodeBox valueCode = ctxt.makeCodeBox();
        CifType valueType = txtExpr.getType();
        if (valueType instanceof StringType) {
            ExprCode strCode = ctxt.exprToTarget(txtExpr, this.makeDestination(txtVarInfo));
            valueCode.add((Box)strCode.getCode());
        } else {
            Object valueText;
            TypeInfo ti = ctxt.typeToTarget(valueType);
            ExprCode strCode = ctxt.exprToTarget(txtExpr, null);
            valueCode.add((Box)strCode.getCode());
            DataValue dataValue = strCode.getRawDataValue();
            if (C89TypeInfoHelper.typeUsesValues(ti)) {
                valueText = dataValue.getData();
            } else if (dataValue.canBeReferenced()) {
                valueText = dataValue.getReference();
            } else {
                VariableInformation tempVar = ctxt.makeTempVariable(ti, "print_temp");
                valueCode.add(Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{ti.getTargetType(), tempVar.targetRef, dataValue.getData()}));
                valueText = "&" + tempVar.targetRef;
            }
            valueCode.add("%s(%s, %s.data, 0, MAX_STRING_SIZE);", new Object[]{C89TypeInfoHelper.typeGetTypePrintName(ti, true), valueText, txtVarInfo.targetRef});
        }
        MemoryCodeBox result = ctxt.makeCodeBox();
        boolean unconditional = forConds.equals("TRUE");
        if (whenPred != null) {
            ExprCode whenCondCode = ctxt.exprToTarget(whenPred, null);
            result.add((Box)whenCondCode.getCode());
            if (unconditional) {
                forConds = whenCondCode.getData();
                unconditional = false;
            } else {
                forConds = Strings.fmt((String)"(%s) && (%s)", (Object[])new Object[]{forConds, whenCondCode.getData()});
            }
        }
        if (!unconditional) {
            result.add("if (%s) {", new Object[]{forConds});
            result.indent();
        }
        result.add((Box)valueCode);
        result.add("ssPrintf(\"%s\\n\", %s.data);", new Object[]{txtVarInfo.targetRef});
        if (!unconditional) {
            result.dedent();
            result.add("}");
        }
        return result;
    }

    @Override
    protected void addEdges(CodeContext ctxt, String cifSpecFileDir) {
        Assert.check((boolean)this.svgInEdges.isEmpty());
        Assert.check((boolean)this.environmentEvents.isEmpty());
        MemoryCodeBox codeGuardFuncs = this.makeCodeBox();
        MemoryCodeBox codeZeroCross = this.makeCodeBox(1);
        MemoryCodeBox codeCallsUncontrollables = this.makeCodeBox(2);
        MemoryCodeBox codeCallsControllables = this.makeCodeBox(2);
        MemoryCodeBox codeMethods = this.makeCodeBox();
        AtomicInteger numTimeDependentGuards = new AtomicInteger(0);
        int edgeIdx = 0;
        edgeIdx = this.addEdges(this.uncontrollableEdges, edgeIdx, (CodeBox)codeCallsUncontrollables, (CodeBox)codeMethods, (CodeBox)codeGuardFuncs, (CodeBox)codeZeroCross, numTimeDependentGuards, ctxt);
        edgeIdx = this.addEdges(this.controllableEdges, edgeIdx, (CodeBox)codeCallsControllables, (CodeBox)codeMethods, (CodeBox)codeGuardFuncs, (CodeBox)codeZeroCross, numTimeDependentGuards, ctxt);
        this.replacements.put("number-of-time-dependent-guards", Strings.str((Object)numTimeDependentGuards));
        this.replacements.put("zero-crossings-compute", codeZeroCross.toString());
        this.replacements.put("guard-functions", codeGuardFuncs.toString());
        if (numTimeDependentGuards.get() == 0) {
            this.replacements.put("define-mdlZeroCrossings", "#undef MDL_ZERO_CROSSINGS");
        } else {
            this.replacements.put("define-mdlZeroCrossings", "#define MDL_ZERO_CROSSINGS");
        }
        this.replacements.put("edge-calls-code-uncontrollables", codeCallsUncontrollables.toString());
        this.replacements.put("edge-calls-code-controllables", codeCallsControllables.toString());
        this.replacements.put("edge-methods-code", codeMethods.toString());
        MemoryCodeBox code = this.makeCodeBox(2);
        code.add("#if PRINT_OUTPUT");
        code.indent();
        code.add("/* pre-initial and post-initial prints. */");
        code.add("PrintOutput(%s, TRUE);", new Object[]{INITIAL_EVENT_NAME});
        code.add("PrintOutput(%s, FALSE);", new Object[]{INITIAL_EVENT_NAME});
        code.dedent();
        code.add("#endif");
        this.replacements.put("initial-print-calls", code.toString());
        code = this.makeCodeBox(1);
        code.add("#if PRINT_OUTPUT");
        code.indent();
        code.add("/* pre-timestep print. */");
        code.add("PrintOutput(%s, TRUE);", new Object[]{DELAY_EVENT_NAME});
        code.dedent();
        code.add("#endif");
        this.replacements.put("time-pre-print-call", code.toString());
        code = this.makeCodeBox(2);
        code.add("#if PRINT_OUTPUT");
        code.indent();
        code.add("/* post-timestep print. */");
        code.add("PrintOutput(%s, FALSE);", new Object[]{DELAY_EVENT_NAME});
        code.dedent();
        code.add("#endif");
        this.replacements.put("time-post-print-call", code.toString());
    }

    private int addEdges(List<Edge> edges, int edgeIdx, CodeBox codeCalls, CodeBox codeMethods, CodeBox codeGuardFuncs, CodeBox codeZeroCross, AtomicInteger numTimeDependentGuards, CodeContext ctxt) {
        int i = 0;
        while (i < edges.size()) {
            ExprCode guardCode;
            Expression guard;
            Edge edge = edges.get(i);
            EList guards = edge.getGuards();
            Assert.check((guards.size() <= 1 ? 1 : 0) != 0);
            Expression expression = guard = guards.isEmpty() ? null : (Expression)Lists.first((List)guards);
            if (guard == null) {
                guardCode = null;
            } else {
                guardCode = ctxt.exprToTarget(guard, null);
                if (!CifValueUtils.isTimeConstant((Expression)guard, (Boolean)false)) {
                    String guardFuncName = Strings.fmt((String)"GuardEval%02d", (Object[])new Object[]{i});
                    codeZeroCross.add("zcSignals[%d] = %s(sim_struct);", new Object[]{numTimeDependentGuards.get(), guardFuncName});
                    if (!codeGuardFuncs.isEmpty()) {
                        codeGuardFuncs.add();
                    }
                    codeGuardFuncs.add("static BoolType %s(SimStruct *sim_struct) {", new Object[]{guardFuncName});
                    codeGuardFuncs.indent();
                    this.addPreamble(codeGuardFuncs, false);
                    codeGuardFuncs.add();
                    codeGuardFuncs.add((Box)guardCode.getCode());
                    codeGuardFuncs.add("return %s;", new Object[]{guardCode.getData()});
                    codeGuardFuncs.dedent();
                    codeGuardFuncs.add("}");
                    numTimeDependentGuards.incrementAndGet();
                    guardCode = new ExprCode();
                    guardCode.setDataValue(C89DataValue.makeComputed(guardFuncName + "(sim_struct)"));
                }
            }
            Assert.check((edge.getEvents().size() == 1 ? 1 : 0) != 0);
            Expression eventRef = ((EdgeEvent)Lists.first((List)edge.getEvents())).getEvent();
            Event event = ((EventExpression)eventRef).getEvent();
            String eventName = (String)this.origDeclNames.get(event);
            Assert.notNull((Object)eventName);
            String eventTargetName = this.getTargetRef((PositionObject)event);
            codeCalls.add("edgeExecuted |= execEdge%d(sim_struct); /* (Try to) perform edge with index %d and event \"%s\". */", new Object[]{edgeIdx, edgeIdx, eventName});
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)event);
            codeMethods.add();
            codeMethods.add("/**");
            codeMethods.add(" * Execute code for edge with index %d and event \"%s\".", new Object[]{edgeIdx, eventName});
            for (String doc : docs) {
                codeMethods.add(" *");
                String[] stringArray = doc.split("\\r?\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    codeMethods.add(" * %s", new Object[]{line});
                    ++n2;
                }
            }
            codeMethods.add(" *");
            codeMethods.add(" * @return Whether the edge was performed.");
            codeMethods.add(" */");
            codeMethods.add("static BoolType execEdge%d(SimStruct *sim_struct) {", new Object[]{edgeIdx});
            codeMethods.indent();
            this.addPreamble(codeMethods, false);
            codeMethods.add();
            if (guardCode != null) {
                codeMethods.add((Box)guardCode.getCode());
                codeMethods.add("BoolType guard = %s;", new Object[]{guardCode.getData()});
                codeMethods.add("if (!guard) return FALSE;");
                codeMethods.add();
            }
            if (!this.printDecls.isEmpty()) {
                codeMethods.add("#if PRINT_OUTPUT");
                codeMethods.indent();
                codeMethods.add("PrintOutput(%s, TRUE);", new Object[]{eventTargetName});
                codeMethods.dedent();
                codeMethods.add("#endif");
            }
            codeMethods.add();
            if (!edge.getUpdates().isEmpty()) {
                this.addUpdates((List<Update>)edge.getUpdates(), codeMethods, ctxt);
                codeMethods.add();
            }
            if (!this.printDecls.isEmpty()) {
                codeMethods.add("#if PRINT_OUTPUT");
                codeMethods.indent();
                codeMethods.add("PrintOutput(%s, FALSE);", new Object[]{eventTargetName});
                codeMethods.dedent();
                codeMethods.add("#endif");
            }
            codeMethods.add("return TRUE;");
            codeMethods.dedent();
            codeMethods.add("}");
            ++i;
            ++edgeIdx;
        }
        return edgeIdx;
    }

    @Override
    protected IfElseGenerator getIfElseUpdateGenerator() {
        return new CurlyBraceIfElseGenerator();
    }

    @Override
    protected void addUpdatesBeginScope(CodeBox code) {
        code.add("{");
        code.indent();
    }

    @Override
    protected void addUpdatesEndScope(CodeBox code) {
        code.dedent();
        code.add("}");
    }

    @Override
    protected void addSpec(CodeContext ctxt) {
        List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)this.spec);
        MemoryCodeBox specCommentsBox = this.makeCodeBox(0);
        for (String doc : docs) {
            specCommentsBox.add(" *");
            String[] stringArray = doc.split("\\r?\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                specCommentsBox.add(" * %s", new Object[]{line});
                ++n2;
            }
        }
        Object specCommentsCode = specCommentsBox.toString();
        if (!((String)specCommentsCode).isEmpty()) {
            specCommentsCode = (String)specCommentsCode + "\n";
        }
        this.replacements.put("spec-comments", specCommentsCode);
    }

    @Override
    protected Map<String, String> getTemplates() {
        Map templates = Maps.map();
        templates.put("sfunction.c", ".c");
        templates.put("report.txt", "_report.txt");
        return templates;
    }

    private static class DeclarationCompator
    implements Comparator<Pair<Declaration, String>> {
        private DeclarationCompator() {
        }

        @Override
        public int compare(Pair<Declaration, String> p1, Pair<Declaration, String> p2) {
            return ((String)p1.right).compareTo((String)p2.right);
        }
    }
}

