/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.metamodel.cif;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SupKind implements Enumerator
{
    NONE(0, "None", "None"),
    PLANT(1, "Plant", "Plant"),
    REQUIREMENT(2, "Requirement", "Requirement"),
    SUPERVISOR(3, "Supervisor", "Supervisor");

    public static final int NONE_VALUE = 0;
    public static final int PLANT_VALUE = 1;
    public static final int REQUIREMENT_VALUE = 2;
    public static final int SUPERVISOR_VALUE = 3;
    private static final SupKind[] VALUES_ARRAY;
    public static final List<SupKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SupKind[]{NONE, PLANT, REQUIREMENT, SUPERVISOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SupKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SupKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SupKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SupKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SupKind get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return PLANT;
            }
            case 2: {
                return REQUIREMENT;
            }
            case 3: {
                return SUPERVISOR;
            }
        }
        return null;
    }

    private SupKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

