/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.sequencing.elements;

import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.common.dsm.sequencing.elements.Element;
import org.eclipse.escet.common.dsm.sequencing.elements.SingularElement;
import org.eclipse.escet.common.dsm.sequencing.graph.Vertex;

public class CollectionElement
extends Element {
    public final List<SingularElement> containedElements;

    public CollectionElement(List<SingularElement> containedElements, BitSet inputs, BitSet outputs) {
        super(inputs, outputs);
        this.containedElements = containedElements;
    }

    @Override
    public void setVertexIndices(BitSet indexSet) {
        for (SingularElement singular : this.containedElements) {
            singular.setVertexIndices(indexSet);
        }
    }

    @Override
    public void clearVertexIndices(BitSet indexSet) {
        for (SingularElement singular : this.containedElements) {
            singular.clearVertexIndices(indexSet);
        }
    }

    @Override
    public int getVertexCount() {
        return this.containedElements.size();
    }

    @Override
    public void appendVertices(List<Vertex> vertices) {
        for (SingularElement singular : this.containedElements) {
            singular.appendVertices(vertices);
        }
    }

    @Override
    protected String getSelfNumbers() {
        return this.containedElements.stream().map(String::valueOf).collect(Collectors.joining(","));
    }
}

