/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mirror.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class AnnotationProcessors {
    public static final AnnotationProcessor NO_OP = new NoOpAP();

    public static AnnotationProcessor getCompositeAnnotationProcessor(AnnotationProcessor ... aps) {
        return new CompositeAnnotationProcessor(aps);
    }

    public static AnnotationProcessor getCompositeAnnotationProcessor(Collection<AnnotationProcessor> aps) {
        return new CompositeAnnotationProcessor(aps);
    }

    static class CompositeAnnotationProcessor
    implements AnnotationProcessor {
        private final List<AnnotationProcessor> aps = new LinkedList<AnnotationProcessor>();

        public CompositeAnnotationProcessor(Collection<AnnotationProcessor> aps) {
            this.aps.addAll(aps);
        }

        public CompositeAnnotationProcessor(AnnotationProcessor ... aps) {
            this.aps.addAll(Arrays.asList(aps));
        }

        @Override
        public void process() {
            for (AnnotationProcessor ap : this.aps) {
                ap.process();
            }
        }
    }

    static class NoOpAP
    implements AnnotationProcessor {
        NoOpAP() {
        }

        @Override
        public void process() {
        }
    }
}

