/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;

class DefaultRuntimeInitialContextFactoryBuilder
implements InitialContextFactoryBuilder {
    private static final Logger logger = Logger.getLogger(DefaultRuntimeInitialContextFactoryBuilder.class.getName());

    DefaultRuntimeInitialContextFactoryBuilder() {
    }

    public InitialContextFactory createInitialContextFactory(Hashtable environment) throws NamingException {
        if (environment != null && environment.get("java.naming.factory.initial") != null) {
            String initialContextFactoryName = (String)environment.get("java.naming.factory.initial");
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(initialContextFactoryName);
                return (InitialContextFactory)clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "Error while trying to load system-level JNDI provider", e);
            }
        }
        return null;
    }
}

