/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.debug;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AbstractJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointDetailPaneFactory;
import org.eclipse.jdt.internal.debug.ui.breakpoints.LineBreakpointDetailPane;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.xbase.ui.debug.JavaBreakPointProvider;
import org.eclipse.xtext.xbase.ui.debug.XbaseDetailPanePrioritizer;

public class XbaseBreakpointDetailPaneFactory
extends BreakpointDetailPaneFactory {
    public static final String XBASE_DETAIL_PANE = "org.eclipse.xtext.xbase.debug.DetailPane";
    @Inject
    private XbaseDetailPanePrioritizer prioritizer;
    @Inject
    private IResourceServiceProvider.Registry registry;

    public Set<String> getDetailPaneTypes(IStructuredSelection selection) {
        Object selectedElement;
        this.prioritizer.prioritizeXbaseOverJdt();
        if (selection.size() == 1 && (selectedElement = selection.getFirstElement()) instanceof IBreakpoint) {
            IBreakpoint b = (IBreakpoint)selectedElement;
            try {
                Object sourceUri = b.getMarker().getAttribute("org.eclipse.xtext.xbase.source.uri");
                if (sourceUri != null) {
                    return Collections.singleton(XBASE_DETAIL_PANE);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return Collections.emptySet();
    }

    public IDetailPane createDetailPane(String paneID) {
        if (XBASE_DETAIL_PANE.equals(paneID)) {
            return new LineBreakpointDetailPane(){

                public void display(IStructuredSelection selection) {
                    super.display(selection);
                    AbstractJavaBreakpointEditor editor = this.getEditor();
                    Object input = null;
                    if (selection != null && selection.size() == 1) {
                        input = selection.getFirstElement();
                    }
                    try {
                        if (input instanceof IJavaStratumLineBreakpoint) {
                            IJavaStratumLineBreakpoint stratumBreakpoint = (IJavaStratumLineBreakpoint)input;
                            URI uri = URI.createURI((String)((String)stratumBreakpoint.getMarker().getAttribute("org.eclipse.xtext.xbase.source.uri")));
                            IResourceServiceProvider resourceServiceProvider = XbaseBreakpointDetailPaneFactory.this.registry.getResourceServiceProvider(uri);
                            if (resourceServiceProvider != null) {
                                JavaBreakPointProvider javaBreakPointProvider = (JavaBreakPointProvider)resourceServiceProvider.get(JavaBreakPointProvider.class);
                                input = javaBreakPointProvider.getBreakpointWithJavaLocation(stratumBreakpoint);
                            }
                        }
                        editor.setInput(input);
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log((Throwable)e);
                    }
                }
            };
        }
        return super.createDetailPane(paneID);
    }
}

