/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.profiler.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.common.tools.api.profiler.TimeProfiler2;
import org.eclipse.sirius.common.ui.tools.api.util.ImageProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TimeProfiler2ViewLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IFontProvider {
    public static final int CATEGORY_COL = 0;
    public static final int TASK_NAME_COL = 1;
    public static final int TIME_COL_MS = 2;
    public static final int OCCURENCES_COL = 3;
    private static final int MINIMUM = 4;
    private static final int MAXIMUM = 5;
    private static final int AVERAGE = 6;
    private Map<Boolean, Font> fontCache = new HashMap<Boolean, Font>();

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (element instanceof TimeProfiler2.CompositeTask) {
            TimeProfiler2.CompositeTask item = (TimeProfiler2.CompositeTask)element;
            switch (columnIndex) {
                case 0: {
                    if (item.getProfilerTask().getCategoryImage() == null) break;
                    image = ImageProvider.getImageFromPath(item.getProfilerTask().getCategoryImage());
                    break;
                }
                case 1: {
                    if (item.getProfilerTask().getTaskImage() == null) break;
                    image = ImageProvider.getImageFromPath(item.getProfilerTask().getTaskImage());
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof TimeProfiler2.CompositeTask) {
            TimeProfiler2.CompositeTask item = (TimeProfiler2.CompositeTask)element;
            switch (columnIndex) {
                case 0: {
                    text = item.getProfilerTask().getCategory();
                    break;
                }
                case 1: {
                    text = item.getProfilerTask().getName();
                    break;
                }
                case 2: {
                    text = Long.valueOf(item.getEllapsedTime()).toString();
                    break;
                }
                case 3: {
                    text = Integer.valueOf(item.getOccurences()).toString();
                    break;
                }
                case 4: {
                    text = Long.valueOf(item.getMin()).toString();
                    break;
                }
                case 5: {
                    text = Long.valueOf(item.getMax()).toString();
                    break;
                }
                case 6: {
                    text = Long.valueOf((long)((double)item.getEllapsedTime() / (double)item.getOccurences())).toString();
                    break;
                }
            }
        }
        return text;
    }

    public Font getFont(Object element) {
        if (element instanceof TimeProfiler2.CompositeTask) {
            TimeProfiler2.CompositeTask task = (TimeProfiler2.CompositeTask)element;
            return this.getFontFromValue(task.getParent() == null);
        }
        return null;
    }

    private Font getFontFromValue(boolean bold) {
        if (!this.fontCache.containsKey(bold)) {
            this.fontCache.put(bold, new Font((Device)Display.getDefault(), "ARIAL", 12, !bold ? 0 : 1));
        }
        return this.fontCache.get(bold);
    }
}

