/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper.task;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.ext.emf.EReferencePredicate;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DeleteEObjectTask
extends AbstractCommandTask {
    protected final EObject objectToDelete;
    private ModelAccessor accessor;
    private EReferencePredicate danglingEReferencesToIgnores;

    public DeleteEObjectTask(EObject objectToDelete, ModelAccessor accessor) {
        this(objectToDelete, accessor, null);
    }

    public DeleteEObjectTask(EObject objectToDelete, ModelAccessor accessor, final EReferencePredicate eReferencesToIgnores) {
        this.objectToDelete = objectToDelete;
        this.accessor = accessor;
        this.danglingEReferencesToIgnores = new EReferencePredicate(){

            public boolean apply(EReference ref) {
                return DanglingRefRemovalTrigger.DSEMANTICDECORATOR_REFERENCE_TO_IGNORE_PREDICATE.apply(ref) || DanglingRefRemovalTrigger.NOTATION_VIEW_ELEMENT_REFERENCE_TO_IGNORE_PREDICATE.apply(ref) || eReferencesToIgnores != null && eReferencesToIgnores.apply(ref);
            }
        };
    }

    @Override
    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
        Session session = null;
        session = this.objectToDelete instanceof DSemanticDecorator ? SessionManager.INSTANCE.getSession(((DSemanticDecorator)this.objectToDelete).getTarget()) : SessionManager.INSTANCE.getSession(this.objectToDelete);
        ECrossReferenceAdapter semanticCrossReferencer = null;
        if (session != null) {
            semanticCrossReferencer = session.getSemanticCrossReferencer();
        }
        DRepresentationDescriptor dRepresentationDescriptorToDelete = null;
        if (this.objectToDelete instanceof DRepresentation) {
            dRepresentationDescriptorToDelete = new DRepresentationQuery((DRepresentation)this.objectToDelete, session).getRepresentationDescriptor();
        }
        this.accessor.eDelete(this.objectToDelete, semanticCrossReferencer, this.danglingEReferencesToIgnores);
        if (dRepresentationDescriptorToDelete != null) {
            this.accessor.eDelete((EObject)dRepresentationDescriptorToDelete, semanticCrossReferencer, this.danglingEReferencesToIgnores);
        }
    }

    @Override
    public String getLabel() {
        return Messages.DeleteEObjectTask_label;
    }
}

