/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gemoc.timeline.model.PossibleStep;
import org.eclipse.gemoc.timeline.model.TimelineWindow;
import org.eclipse.gemoc.timeline.view.ITimelineProvider;

public final class Choice {
    private static final int SHIFT = 8;
    private final TimelineWindow timelineWindow;
    private final int branch;
    private final int index;

    public Choice(TimelineWindow timelineWindow, int branch, int index) {
        this.timelineWindow = timelineWindow;
        this.branch = branch;
        this.index = index;
    }

    public TimelineWindow getTimelineWindow() {
        return this.timelineWindow;
    }

    public List<PossibleStep> getPossibleSteps() {
        ArrayList<PossibleStep> res = new ArrayList<PossibleStep>();
        ITimelineProvider provider = this.getTimelineWindow().getProvider();
        int numberOfPossibleStepsAt = provider.getNumberOfPossibleStepsAt(this.branch, this.index);
        int i = 0;
        while (i < numberOfPossibleStepsAt) {
            res.add(new PossibleStep(this.getTimelineWindow(), this.branch, this.index, i));
            ++i;
        }
        return res;
    }

    public int getIndex() {
        return this.index;
    }

    public int getBranch() {
        return this.branch;
    }

    public Choice getPreviousChoice() {
        Choice res = this.index > this.getTimelineWindow().getProvider().getStart(this.branch) ? new Choice(this.getTimelineWindow(), this.branch, this.index - 1) : null;
        return res;
    }

    public Choice getNextChoice() {
        int numberOfChoices = this.getTimelineWindow().getProvider().getEnd(this.branch);
        Choice res = this.index < numberOfChoices - 1 ? new Choice(this.getTimelineWindow(), this.branch, this.index + 1) : null;
        return res;
    }

    public int hashCode() {
        return (this.branch << 8) + this.index;
    }

    public boolean equals(Object obj) {
        return obj instanceof Choice && ((Choice)obj).branch == this.branch && ((Choice)obj).index == this.index;
    }

    public int getConnectedIndex() {
        return this.getTimelineWindow().getProvider().getSelectedPossibleStep(this.branch, this.index);
    }

    public boolean hasSelected() {
        return this.getTimelineWindow().getProvider().getSelectedPossibleStep(this.branch, this.index) >= 0;
    }
}

