/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.ui.genericdebugmodel;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gemoc.commons.eclipse.emf.EObjectUtil;
import org.eclipse.gemoc.dsl.debug.DebugTarget;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.Thread;
import org.eclipse.gemoc.dsl.debug.Variable;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLStackFrameAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.variable.DSLObjectVariable;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.DSLDebugModelPresentation;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.SiriusEditorUtils;
import org.eclipse.gemoc.dsl.debug.provider.CustomDebugItemProviderAdapterFactory;
import org.eclipse.gemoc.executionframework.engine.ui.provider.DSLVariableLabelDecorator;
import org.eclipse.gemoc.executionframework.ui.Activator;
import org.eclipse.gemoc.executionframework.ui.IMSEPresenter;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class GemocGenericDebugModelPresentation
extends DSLDebugModelPresentation
implements IFontProvider {
    protected final ILabelDecorator labelDecorator;

    public GemocGenericDebugModelPresentation() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        CustomDebugItemProviderAdapterFactory debugFactory = new CustomDebugItemProviderAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)debugFactory);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.eLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        this.labelDecorator = new DSLVariableLabelDecorator();
    }

    public IEditorInput getEditorInput(Object element) {
        IEditorInput res = element instanceof MSE && ((MSE)element).getCaller() != null ? super.getEditorInput((Object)((MSE)element).getCaller()) : super.getEditorInput(element);
        return res;
    }

    public String getEditorId(IEditorInput input, Object element) {
        String res = element instanceof MSE && ((MSE)element).getCaller() != null ? super.getEditorId(input, (Object)((MSE)element).getCaller()) : super.getEditorId(input, element);
        return res;
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        if (frame instanceof DSLStackFrameAdapter) {
            this.changeCurrentStackFrame(frame);
            if (editorPart instanceof DialectEditor) {
                EObject instruction = ((DSLStackFrameAdapter)frame).getCurrentInstruction();
                if (instruction instanceof Step) {
                    ArrayList<MSE> tickedEvents = new ArrayList<MSE>();
                    tickedEvents.add(((Step)instruction).getMseoccurrence().getMse());
                    this.showEvents(tickedEvents);
                    LinkedHashSet<EObject> callers = new LinkedHashSet<EObject>();
                    for (MSE event : tickedEvents) {
                        if (event.getCaller() == null) continue;
                        callers.add(event.getCaller());
                    }
                    try {
                        SiriusEditorUtils.showInstructions((DialectEditor)((DialectEditor)editorPart), new ArrayList(callers));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        SiriusEditorUtils.showInstruction((DialectEditor)((DialectEditor)editorPart), (EObject)instruction);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                super.addAnnotations(editorPart, frame);
            }
        }
        return false;
    }

    private void showEvents(List<MSE> events) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (MSE event : events) {
            uris.add(EcoreUtil.getURI((EObject)event));
        }
        for (IMSEPresenter presenter : Activator.getDefault().getEventPresenters()) {
            presenter.present(uris);
        }
    }

    public Image getImage(Object element) {
        Image res;
        Object unwrapped = this.unwrapp(element);
        if (unwrapped instanceof Variable) {
            Image valueImage = this.getImage(((Variable)unwrapped).getValue());
            if (valueImage == null) {
                valueImage = super.getImage(element);
            }
            if (valueImage == null) {
                valueImage = DebugUIPlugin.getDefaultLabelProvider().getImage(element);
            }
            res = this.labelDecorator.decorateImage(valueImage, unwrapped);
        } else if (element instanceof DSLObjectVariable) {
            Image valueImage = this.getImage(this.unwrapp(element));
            if (valueImage == null) {
                valueImage = super.getImage(element);
            }
            if (valueImage == null) {
                valueImage = DebugUIPlugin.getDefaultLabelProvider().getImage(element);
            }
            res = this.labelDecorator.decorateImage(valueImage, element);
        } else {
            res = this.labelDecorator.decorateImage(super.getImage(element), element);
        }
        return res;
    }

    public String getText(Object element) {
        if (element instanceof Adapter) {
            Notifier target = ((Adapter)element).getTarget();
            if (target instanceof DebugTarget) {
                return ((DebugTarget)target).getName();
            }
            if (target instanceof Thread) {
                return ((Thread)target).getName();
            }
            if (target instanceof StackFrame) {
                StackFrame t = (StackFrame)target;
                if (t.getCurrentInstruction() != t.getContext()) {
                    DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();
                    StringBuilder sb = new StringBuilder();
                    Formatter formatter = new Formatter(sb);
                    QualifiedName qn = nameprovider.getFullyQualifiedName(t.getCurrentInstruction());
                    if (qn != null) {
                        formatter.format("%s => %s", t.getName(), qn);
                    } else {
                        String resBasedName = EObjectUtil.getResourceBasedName((EObject)t.getCurrentInstruction(), (boolean)false);
                        if (resBasedName != null) {
                            formatter.format("%s  => %s", t.getName(), resBasedName);
                        } else {
                            formatter.format("%s  => %s", t.getName(), t.getCurrentInstruction());
                        }
                    }
                    formatter.close();
                    return sb.toString();
                }
                return ((StackFrame)target).getName();
            }
        }
        return super.getText(element);
    }

    public Font getFont(Object element) {
        StackFrame t;
        Notifier target;
        if (element instanceof Adapter && (target = ((Adapter)element).getTarget()) instanceof StackFrame && (t = (StackFrame)target).getChildFrame() == null) {
            return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
        return null;
    }
}

