/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.gemoc.dsl.debug.provider.CurrentSessionItemProvider;
import org.eclipse.gemoc.dsl.debug.provider.DebugTargetItemProvider;
import org.eclipse.gemoc.dsl.debug.provider.RegisterGroupItemProvider;
import org.eclipse.gemoc.dsl.debug.provider.RegisterItemProvider;
import org.eclipse.gemoc.dsl.debug.provider.StackFrameItemProvider;
import org.eclipse.gemoc.dsl.debug.provider.ThreadItemProvider;
import org.eclipse.gemoc.dsl.debug.provider.VariableItemProvider;
import org.eclipse.gemoc.dsl.debug.util.DebugAdapterFactory;

public class DebugItemProviderAdapterFactory
extends DebugAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    public static final String copyright = "Copyright (c) 2015 Obeo.\n All rights reserved. This program and the accompanying materials\n are made available under the terms of the Eclipse Public License v1.0\n which accompanies this distribution, and is available at\n http://www.eclipse.org/legal/epl-v10.html\n \n Contributors:\n    Obeo - initial API and implementation";
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected DebugTargetItemProvider debugTargetItemProvider;
    protected ThreadItemProvider threadItemProvider;
    protected StackFrameItemProvider stackFrameItemProvider;
    protected VariableItemProvider variableItemProvider;
    protected CurrentSessionItemProvider currentSessionItemProvider;
    protected RegisterGroupItemProvider registerGroupItemProvider;
    protected RegisterItemProvider registerItemProvider;

    public DebugItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createDebugTargetAdapter() {
        if (this.debugTargetItemProvider == null) {
            this.debugTargetItemProvider = new DebugTargetItemProvider((AdapterFactory)this);
        }
        return this.debugTargetItemProvider;
    }

    public Adapter createThreadAdapter() {
        if (this.threadItemProvider == null) {
            this.threadItemProvider = new ThreadItemProvider((AdapterFactory)this);
        }
        return this.threadItemProvider;
    }

    public Adapter createStackFrameAdapter() {
        if (this.stackFrameItemProvider == null) {
            this.stackFrameItemProvider = new StackFrameItemProvider((AdapterFactory)this);
        }
        return this.stackFrameItemProvider;
    }

    public Adapter createVariableAdapter() {
        if (this.variableItemProvider == null) {
            this.variableItemProvider = new VariableItemProvider((AdapterFactory)this);
        }
        return this.variableItemProvider;
    }

    public Adapter createCurrentSessionAdapter() {
        if (this.currentSessionItemProvider == null) {
            this.currentSessionItemProvider = new CurrentSessionItemProvider((AdapterFactory)this);
        }
        return this.currentSessionItemProvider;
    }

    public Adapter createRegisterGroupAdapter() {
        if (this.registerGroupItemProvider == null) {
            this.registerGroupItemProvider = new RegisterGroupItemProvider((AdapterFactory)this);
        }
        return this.registerGroupItemProvider;
    }

    public Adapter createRegisterAdapter() {
        if (this.registerItemProvider == null) {
            this.registerItemProvider = new RegisterItemProvider((AdapterFactory)this);
        }
        return this.registerItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.debugTargetItemProvider != null) {
            this.debugTargetItemProvider.dispose();
        }
        if (this.threadItemProvider != null) {
            this.threadItemProvider.dispose();
        }
        if (this.stackFrameItemProvider != null) {
            this.stackFrameItemProvider.dispose();
        }
        if (this.variableItemProvider != null) {
            this.variableItemProvider.dispose();
        }
        if (this.currentSessionItemProvider != null) {
            this.currentSessionItemProvider.dispose();
        }
        if (this.registerGroupItemProvider != null) {
            this.registerGroupItemProvider.dispose();
        }
        if (this.registerItemProvider != null) {
            this.registerItemProvider.dispose();
        }
    }
}

