/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.diagnostics.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.AssignmentToResultInVoidOperation;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.AttributeNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.IDiagnosticFormatter;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.InternalError;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Message;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.MethodNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.MissingReturnStatement;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.NotIterable;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Operator;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.ProhibitedAssignmentToSelf;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.TypeMismatch;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.TypeNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.UnsupportedOperator;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.VariableAlreadyDefined;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.VariableNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.util.DiagnosticsSwitch;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.LookalikeStrings;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.Messages;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.Scopes;
import org.eclipse.emf.ecoretools.ale.core.validation.QualifiedNames;

public class ConsoleDiagnosticsFormatter
extends DiagnosticsSwitch<String>
implements IDiagnosticFormatter {
    @Override
    public String adapt(EObject element) {
        return (String)this.doSwitch(element);
    }

    @Override
    public String caseAssignmentToResultInVoidOperation(AssignmentToResultInVoidOperation error) {
        String headline = Messages.variableNotFound(error.getName());
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineFirst(snippet, error.getIncriminatedCode());
        String advises = String.valueOf(Messages.resultNotAvailableInVoidMethod()) + " " + ConsoleDiagnosticsFormatter.replacementProposals(error.getName(), ConsoleDiagnosticsFormatter.getScope(error).getVariableNames());
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline + ConsoleDiagnosticsFormatter.nl() + advises;
    }

    @Override
    public String caseProhibitedAssignmentToSelf(ProhibitedAssignmentToSelf error) {
        String headline = Messages.selfCannotBeAssigned();
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineFirst(snippet, error.getIncriminatedCode());
        String excerpt = ConsoleDiagnosticsFormatter.low(Messages.reservedKeyword());
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline + " " + excerpt;
    }

    @Override
    public String caseAttributeNotFound(AttributeNotFound error) {
        String headline = Messages.attributeNotFound(error.getName(), error.getOwner().getName());
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineFirst(snippet, error.getIncriminatedCode());
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline;
    }

    @Override
    public String caseInternalError(InternalError object) {
        return object.getStacktrace().stream().map(String::valueOf).collect(Collectors.joining(ConsoleDiagnosticsFormatter.nl()));
    }

    @Override
    public String caseMethodNotFound(MethodNotFound error) {
        String headline = Messages.methodNotFound(error.getName(), QualifiedNames.getQualifiedName((IType)error.getArgumentTypes().get(0)));
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineFirst(snippet, error.getIncriminatedCode());
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline;
    }

    @Override
    public String caseMissingReturnStatement(MissingReturnStatement error) {
        String headline = Messages.methodMustAssignResult(error.getMethod().getOperationRef());
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineLast(snippet, "}");
        String excerpt = Messages.missingResultAssignment(error.getMethod().getOperationRef().getName());
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline + " " + excerpt;
    }

    @Override
    public String caseNotIterable(NotIterable error) {
        String headline = Messages.cannotIterateOver(Messages.repr(error.getActualTypes()));
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineLast(snippet, error.getIncriminatedCode());
        String excerpt = "should be a Sequence or an OrderedSet";
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline + " " + excerpt;
    }

    @Override
    public String caseTypeMismatch(TypeMismatch error) {
        String headline = Messages.typeMismatch(error.getExpectedTypes(), error.getActualTypes());
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineFirst(snippet, error.getIncriminatedCode());
        String excerpt = Messages.shouldBe(Messages.repr(error.getExpectedTypes()));
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline + " " + excerpt;
    }

    @Override
    public String caseTypeNotFound(TypeNotFound error) {
        String headline = Messages.typeNotFound(error.getName());
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineFirst(snippet, error.getIncriminatedCode());
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline;
    }

    @Override
    public String caseUnsupportedOperator(UnsupportedOperator error) {
        String headline = Messages.unsupportedOperator(ConsoleDiagnosticsFormatter.op(error.getOperator()), ConsoleDiagnosticsFormatter.typeAsString(error.getTarget()));
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineFirst(snippet, error.getIncriminatedCode());
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline;
    }

    @Override
    public String caseVariableAlreadyDefined(VariableAlreadyDefined error) {
        String headline = Messages.variableAlreadyBound(error.getName());
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineFirst(snippet, error.getIncriminatedCode());
        String excerpt = ConsoleDiagnosticsFormatter.low(Messages.alreadyDeclaredHere(error.getDuplicateLocation().getSource(), error.getDuplicateLocation().getLine()));
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline + " " + excerpt;
    }

    @Override
    public String caseVariableNotFound(VariableNotFound error) {
        String headline = Messages.variableNotFound(error.getName());
        String snippet = Messages.codeSnippet(error.getLocation().getLine(), error.getWholeCode());
        String underline = ConsoleDiagnosticsFormatter.underlineFirst(snippet, error.getIncriminatedCode());
        String advises = ConsoleDiagnosticsFormatter.replacementProposals(error.getName(), ConsoleDiagnosticsFormatter.getScope(error).getVariableNames());
        return String.valueOf(headline) + ConsoleDiagnosticsFormatter.nlnl() + snippet + ConsoleDiagnosticsFormatter.nl() + underline + ConsoleDiagnosticsFormatter.nl() + advises;
    }

    private static String doPropositions(String actual, Collection<String> expected) {
        LookalikeStrings lookalikes = LookalikeStrings.compare(actual).with(expected).now();
        String onePerLine = lookalikes.getNBests(4).stream().map(lookalike -> "    " + lookalike).collect(Collectors.joining(System.lineSeparator()));
        return Messages.propositions(String.valueOf(ConsoleDiagnosticsFormatter.nlnl()) + onePerLine);
    }

    private static Scopes.Scope getScope(Message error) {
        return ((Scopes)error.getContext().getScopes()).getCurrent();
    }

    private static String op(Operator op) {
        switch (op) {
            case ADDITION: {
                return "+";
            }
            case SUBSTRACTION: {
                return "-";
            }
            case GREATER_THAN: {
                return ">";
            }
            case LOWER_THAN: {
                return "<";
            }
            case EQUAL: {
                return "==";
            }
            case ADDITION_ASSIGNMENT: {
                return "+=";
            }
            case SUBSTRACTION_ASSIGNMENT: {
                return "-=";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case LOWER_OR_EQUAL: {
                return "<=";
            }
            case DOT: {
                return ".";
            }
        }
        return "";
    }

    private static String replacementProposals(String originalVariable, Collection<String> expected) {
        if (expected.isEmpty()) {
            return Messages.undeclaredVariable(originalVariable, "<type> " + originalVariable + ";");
        }
        return ConsoleDiagnosticsFormatter.doPropositions(originalVariable, expected);
    }

    private static String typeAsString(Object target) {
        if (target instanceof IType) {
            return QualifiedNames.getQualifiedName((IType)target);
        }
        if (target instanceof EClassifier) {
            return QualifiedNames.getQualifiedName((EClassifier)target);
        }
        if (target instanceof Collection) {
            try {
                return Messages.repr((Collection)target);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return String.valueOf(target);
    }

    private static String underlineFirst(String codeSnippet, String incriminatedCode) {
        int incriminatedCodeStart = -1;
        String[] lines = codeSnippet.split("\\r?\\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (line.contains(incriminatedCode)) {
                int margin = ConsoleDiagnosticsFormatter.margin(line);
                incriminatedCodeStart = ConsoleDiagnosticsFormatter.spaced(line).indexOf(incriminatedCode, margin);
                break;
            }
            ++i;
        }
        if (incriminatedCodeStart < 0) {
            int margin = ConsoleDiagnosticsFormatter.margin(codeSnippet);
            incriminatedCodeStart = ConsoleDiagnosticsFormatter.spaced(codeSnippet).indexOf(incriminatedCode, margin);
        }
        if (incriminatedCodeStart < 0) {
            return "";
        }
        return String.valueOf(ConsoleDiagnosticsFormatter.spaces(incriminatedCodeStart)) + ConsoleDiagnosticsFormatter.carets(incriminatedCode.length());
    }

    private static String underlineLast(String codeSnippet, String incriminatedCode) {
        int incriminatedCodeStart = -1;
        String[] lines = codeSnippet.split("\\r?\\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (line.contains(incriminatedCode)) {
                int margin = ConsoleDiagnosticsFormatter.margin(line);
                incriminatedCodeStart = ConsoleDiagnosticsFormatter.spaced(line).indexOf(incriminatedCode, margin);
            }
            ++i;
        }
        if (incriminatedCodeStart < 0) {
            int margin = ConsoleDiagnosticsFormatter.margin(codeSnippet);
            incriminatedCodeStart = ConsoleDiagnosticsFormatter.spaced(codeSnippet).indexOf(incriminatedCode, margin);
        }
        if (incriminatedCodeStart < 0) {
            return "";
        }
        return String.valueOf(ConsoleDiagnosticsFormatter.spaces(incriminatedCodeStart)) + ConsoleDiagnosticsFormatter.carets(incriminatedCode.length());
    }

    private static String low(String str) {
        return str.toLowerCase();
    }

    private static int margin(String codeSnippet) {
        return Math.max(0, codeSnippet.indexOf(124));
    }

    private static String spaces(int count) {
        return Strings.repeat((String)" ", (int)count);
    }

    private static String carets(int count) {
        return Strings.repeat((String)"^", (int)count);
    }

    private static String spaced(String codeSnippet) {
        return codeSnippet.replace("\t", "    ");
    }

    private static String nl() {
        return System.lineSeparator();
    }

    private static String nlnl() {
        return String.valueOf(ConsoleDiagnosticsFormatter.nl()) + ConsoleDiagnosticsFormatter.nl();
    }
}

