/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.metamodelembedding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.Activator;
import org.eclipse.emf.ecoretools.ale.core.parser.ALELexer;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEParser;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.core.parser.internal.AntlrAstToAleBehaviorsFactory;
import org.eclipse.emf.ecoretools.ale.core.parser.internal.AstVisitors;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationFactory;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

class EAnnotationParser {
    public static final String BODY_KEY = "body";
    private ImplementationFactory factory = (ImplementationFactory)ImplementationPackage.eINSTANCE.getEFactoryInstance();

    EAnnotationParser(IQueryEnvironment qryEnv) {
        AntlrAstToAleBehaviorsFactory.createSingleton(qryEnv);
    }

    public List<ParsedFile<ModelUnit>> parse(List<EPackage> pkgs) {
        ArrayList<ParsedFile<ModelUnit>> results = new ArrayList<ParsedFile<ModelUnit>>();
        for (EPackage pkg : pkgs) {
            this.parse(pkg).ifPresent(results::add);
        }
        return results;
    }

    public Optional<ParsedFile<ModelUnit>> parse(EPackage pkg) {
        ParsedFile<ModelUnit> parseRes = new ParsedFile<ModelUnit>();
        parseRes.setDiagnostic((Diagnostic)new BasicDiagnostic());
        ArrayList<ExtendedClass> allExtensions = new ArrayList<ExtendedClass>();
        for (EClassifier classifier : pkg.getEClassifiers()) {
            EClass cls;
            List<Method> allImplem;
            if (!(classifier instanceof EClass) || (allImplem = this.parse(cls = (EClass)classifier, parseRes)).isEmpty()) continue;
            ExtendedClass xtdCls = this.factory.createExtendedClass();
            xtdCls.setBaseClass(cls);
            xtdCls.setName(cls.getName());
            xtdCls.getMethods().addAll(allImplem);
            allExtensions.add(xtdCls);
        }
        if (!allExtensions.isEmpty()) {
            ModelUnit unit = this.factory.createModelUnit();
            unit.setName(this.qualifiedName(pkg));
            unit.getClassExtensions().addAll(allExtensions);
            parseRes.setRoot(unit);
            return Optional.of(parseRes);
        }
        return Optional.empty();
    }

    public List<Method> parse(EClass cls, ParsedFile<ModelUnit> parseRes) {
        ArrayList<Method> allImplem = new ArrayList<Method>();
        for (EOperation op : cls.getEOperations()) {
            this.parse(op, parseRes).ifPresent(allImplem::add);
        }
        return allImplem;
    }

    public Optional<Method> parse(EOperation op, ParsedFile<ModelUnit> parseRes) {
        String body = EcoreUtil.getAnnotation((EModelElement)op, (String)"http://implementation/", (String)BODY_KEY);
        if (body != null) {
            if (!body.trim().startsWith("{") || !body.trim().endsWith("}")) {
                body = "{" + body + "}";
            }
            try {
                ALEParser.RBlockContext blockAst = this.parse(body);
                Block block = (Block)new AstVisitors.BlockVisitor(parseRes).visit((ParseTree)blockAst);
                return Optional.of(AntlrAstToAleBehaviorsFactory.singleton.buildMethod(op, block, Arrays.asList(new String[0])));
            }
            catch (IOException e) {
                Activator.error("Unable to parse the body of method '" + op.getEContainingClass().getName() + "::" + op.getName() + "' from its EAnnotation", e);
            }
        }
        return Optional.empty();
    }

    private ALEParser.RBlockContext parse(String content) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        ANTLRInputStream input = new ANTLRInputStream((InputStream)stream);
        ALELexer lexer = new ALELexer((CharStream)input);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ALEParser parser = new ALEParser((TokenStream)tokens);
        return parser.rBlock();
    }

    private String qualifiedName(EPackage pkg) {
        return pkg.getESuperPackage() == null ? pkg.getName() : String.valueOf(this.qualifiedName(pkg.getESuperPackage())) + "." + pkg.getName();
    }
}

