/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.ibm.icu.text.Bidi;
import org.eclipse.jdt.internal.debug.ui.JDIContentAssistPreference;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class JDISourceViewer
extends SourceViewer
implements IPropertyChangeListener {
    private static final String BIDI_DELIMITERS = "[ \\p{Punct}&&[^_]]";
    private Font fFont;
    private Color fBackgroundColor;
    private Color fForegroundColor;
    private IPreferenceStore fStore;
    private DisplayViewerConfiguration fConfiguration;

    public JDISourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this(parent, ruler, null, false, styles);
    }

    public JDISourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles) {
        super(parent, ruler, overviewRuler, isOverviewRulerVisible, styles);
        StyledText text = this.getTextWidget();
        final int baseLevel = (styles & 0x4000000) != 0 ? 1 : 0;
        text.addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                try {
                    event.segments = JDISourceViewer.getBidiLineSegments(JDISourceViewer.this.getDocument(), baseLevel, JDISourceViewer.this.widgetOffset2ModelOffset(event.lineOffset), event.lineText);
                }
                catch (BadLocationException badLocationException) {}
            }
        });
    }

    private void updateViewerFont() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            FontData data = null;
            data = store.contains("org.eclipse.jdt.ui.editors.textfont") && !store.isDefault("org.eclipse.jdt.ui.editors.textfont") ? PreferenceConverter.getFontData((IPreferenceStore)store, (String)"org.eclipse.jdt.ui.editors.textfont") : PreferenceConverter.getDefaultFontData((IPreferenceStore)store, (String)"org.eclipse.jdt.ui.editors.textfont");
            if (data != null) {
                Font font = new Font((Device)this.getTextWidget().getDisplay(), data);
                this.applyFont(font);
                if (this.getFont() != null) {
                    this.getFont().dispose();
                }
                this.setFont(font);
                return;
            }
        }
        this.applyFont(JFaceResources.getTextFont());
    }

    private void setFont(Font font) {
        this.fFont = font;
    }

    private Font getFont() {
        return this.fFont;
    }

    private void applyFont(Font font) {
        IDocument doc = this.getDocument();
        if (doc != null && doc.getLength() > 0) {
            Point selection = this.getSelectedRange();
            int topIndex = this.getTopIndex();
            StyledText styledText = this.getTextWidget();
            styledText.setRedraw(false);
            styledText.setFont(font);
            this.setSelectedRange(selection.x, selection.y);
            this.setTopIndex(topIndex);
            styledText.setRedraw(true);
        } else {
            this.getTextWidget().setFont(font);
        }
    }

    public void updateViewerColors() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            StyledText styledText = this.getTextWidget();
            Color color = store.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            this.setForegroundColor(color);
            color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            this.setBackgroundColor(color);
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    protected Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    protected void setBackgroundColor(Color backgroundColor) {
        this.fBackgroundColor = backgroundColor;
    }

    protected Color getForegroundColor() {
        return this.fForegroundColor;
    }

    protected void setForegroundColor(Color foregroundColor) {
        this.fForegroundColor = foregroundColor;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property;
        IContentAssistant assistant = this.getContentAssistant();
        if (assistant instanceof ContentAssistant) {
            JDIContentAssistPreference.changeConfiguration((ContentAssistant)assistant, event);
        }
        if ("org.eclipse.jdt.ui.editors.textfont".equals(property = event.getProperty())) {
            this.updateViewerFont();
        }
        if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property)) {
            this.updateViewerColors();
        }
        if (this.fConfiguration != null && this.fConfiguration.affectsTextPresentation(event)) {
            this.fConfiguration.handlePropertyChangeEvent(event);
            this.invalidateTextPresentation();
        }
    }

    public IContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    public void dispose() {
        if (this.getFont() != null) {
            this.getFont().dispose();
            this.setFont(null);
        }
        if (this.getBackgroundColor() != null) {
            this.setBackgroundColor(null);
        }
        if (this.getForegroundColor() != null) {
            this.setForegroundColor(null);
        }
        if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        if (configuration instanceof DisplayViewerConfiguration) {
            this.fConfiguration = (DisplayViewerConfiguration)configuration;
            this.fStore = this.fConfiguration.getTextPreferenceStore();
            this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.updateViewerFont();
        this.updateViewerColors();
    }

    private IPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    protected static int[] getBidiLineSegments(IDocument document, int baseLevel, int lineStart, String lineText) throws BadLocationException {
        if (lineText == null || document == null) {
            return null;
        }
        int lineLength = lineText.length();
        if (lineLength <= 2) {
            return null;
        }
        Bidi bidi = new Bidi(lineText, baseLevel);
        if (bidi.isLeftToRight()) {
            return null;
        }
        IRegion line = document.getLineInformationOfOffset(lineStart);
        ITypedRegion[] linePartitioning = TextUtilities.computePartitioning((IDocument)document, (String)"___java_partitioning", (int)lineStart, (int)line.getLength(), (boolean)false);
        if (linePartitioning == null || linePartitioning.length < 1) {
            return null;
        }
        int segmentIndex = 1;
        int[] segments = new int[lineLength + 1];
        byte[] levels = bidi.getLevels();
        int nPartitions = linePartitioning.length;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            ITypedRegion partition = linePartitioning[partitionIndex];
            int lineOffset = partition.getOffset() - lineStart;
            if (lineOffset > 0 && JDISourceViewer.isMismatchingLevel(levels[lineOffset], baseLevel) && JDISourceViewer.isMismatchingLevel(levels[lineOffset - 1], baseLevel)) {
                segments[segmentIndex++] = lineOffset;
            }
            if ("__dftl_partition_content_type".equals(partition.getType())) {
                int partitionEnd = Math.min(lineLength, lineOffset + partition.getLength());
                while (++lineOffset < partitionEnd) {
                    if (!JDISourceViewer.isMismatchingLevel(levels[lineOffset], baseLevel) || !String.valueOf(lineText.charAt(lineOffset)).matches(BIDI_DELIMITERS)) continue;
                    segments[segmentIndex++] = lineOffset;
                }
            }
            ++partitionIndex;
        }
        if (segmentIndex <= 1) {
            return null;
        }
        segments[0] = 0;
        if (segments[segmentIndex - 1] != lineLength) {
            segments[segmentIndex++] = lineLength;
        }
        if (segmentIndex == segments.length) {
            return segments;
        }
        int[] newSegments = new int[segmentIndex];
        System.arraycopy(segments, 0, newSegments, 0, segmentIndex);
        return newSegments;
    }

    private static boolean isMismatchingLevel(int level, int baseLevel) {
        return ((level ^ baseLevel) & 1) != 0;
    }
}

